/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.behavior.visitor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.el.ValueExpression;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpServerCodec;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.logging.LoggingHandler;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.robot.driver.RobotException;
import org.kaazing.robot.driver.behavior.Barrier;
import org.kaazing.robot.driver.behavior.Configuration;
import org.kaazing.robot.driver.behavior.handler.CompletionHandler;
import org.kaazing.robot.driver.behavior.handler.ExecutionHandler;
import org.kaazing.robot.driver.behavior.handler.FailureHandler;
import org.kaazing.robot.driver.behavior.handler.LogLastEventHandler;
import org.kaazing.robot.driver.behavior.handler.barrier.AwaitBarrierDownstreamHandler;
import org.kaazing.robot.driver.behavior.handler.barrier.AwaitBarrierUpstreamHandler;
import org.kaazing.robot.driver.behavior.handler.barrier.NotifyBarrierHandler;
import org.kaazing.robot.driver.behavior.handler.codec.HttpMessageAggregatingCodec;
import org.kaazing.robot.driver.behavior.handler.codec.HttpMessageSplittingCodec;
import org.kaazing.robot.driver.behavior.handler.codec.HttpUtils;
import org.kaazing.robot.driver.behavior.handler.codec.MaskingDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.MessageDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.MessageEncoder;
import org.kaazing.robot.driver.behavior.handler.codec.ReadByteArrayBytesDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.ReadByteLengthBytesDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.ReadExactBytesDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.ReadExactTextDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.ReadExpressionDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.ReadIntLengthBytesDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.ReadLongLengthBytesDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.ReadRegexDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.ReadShortLengthBytesDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.ReadVariableLengthBytesDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.WriteBytesEncoder;
import org.kaazing.robot.driver.behavior.handler.codec.WriteExpressionEncoder;
import org.kaazing.robot.driver.behavior.handler.codec.WriteTextEncoder;
import org.kaazing.robot.driver.behavior.handler.codec.http.ReadHttpHeaderDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.http.ReadHttpMethodDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.http.ReadHttpParameterDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.http.ReadHttpStatusDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.http.ReadHttpVersionDecoder;
import org.kaazing.robot.driver.behavior.handler.codec.http.WriteHttpHeaderEncoder;
import org.kaazing.robot.driver.behavior.handler.codec.http.WriteHttpMethodEncoder;
import org.kaazing.robot.driver.behavior.handler.codec.http.WriteHttpParameterEncoder;
import org.kaazing.robot.driver.behavior.handler.codec.http.WriteHttpStatusEncoder;
import org.kaazing.robot.driver.behavior.handler.codec.http.WriteHttpVersionEncoder;
import org.kaazing.robot.driver.behavior.handler.command.CloseHandler;
import org.kaazing.robot.driver.behavior.handler.command.DisconnectHandler;
import org.kaazing.robot.driver.behavior.handler.command.UnbindHandler;
import org.kaazing.robot.driver.behavior.handler.command.WriteHandler;
import org.kaazing.robot.driver.behavior.handler.command.http.CloseWriteHttpRequestHandler;
import org.kaazing.robot.driver.behavior.handler.command.http.CloseWriteHttpResponseHandler;
import org.kaazing.robot.driver.behavior.handler.command.http.EndOfWriteHttpHeadersHandler;
import org.kaazing.robot.driver.behavior.handler.command.http.WriteHttpContentLengthHandler;
import org.kaazing.robot.driver.behavior.handler.command.http.WriteHttpHandler;
import org.kaazing.robot.driver.behavior.handler.event.BoundHandler;
import org.kaazing.robot.driver.behavior.handler.event.ChildClosedHandler;
import org.kaazing.robot.driver.behavior.handler.event.ChildOpenedHandler;
import org.kaazing.robot.driver.behavior.handler.event.ClosedHandler;
import org.kaazing.robot.driver.behavior.handler.event.ConnectedHandler;
import org.kaazing.robot.driver.behavior.handler.event.DisconnectedHandler;
import org.kaazing.robot.driver.behavior.handler.event.OpenedHandler;
import org.kaazing.robot.driver.behavior.handler.event.ReadHandler;
import org.kaazing.robot.driver.behavior.handler.event.UnboundHandler;
import org.kaazing.robot.driver.behavior.handler.event.http.CloseReadHttpRequestHandler;
import org.kaazing.robot.driver.behavior.handler.event.http.CloseReadHttpResponseHandler;
import org.kaazing.robot.driver.behavior.handler.event.http.EndOfReadHttpHeadersHandler;
import org.kaazing.robot.driver.behavior.handler.event.http.ReadHttpHandler;
import org.kaazing.robot.driver.netty.bootstrap.BootstrapFactory;
import org.kaazing.robot.driver.netty.bootstrap.ClientBootstrap;
import org.kaazing.robot.driver.netty.bootstrap.ServerBootstrap;
import org.kaazing.robot.driver.netty.bootstrap.SingletonBootstrapFactory;
import org.kaazing.robot.driver.netty.channel.ChannelAddress;
import org.kaazing.robot.driver.netty.channel.ChannelAddressFactory;
import org.kaazing.robot.lang.LocationInfo;
import org.kaazing.robot.lang.ast.AstAcceptNode;
import org.kaazing.robot.lang.ast.AstAcceptableNode;
import org.kaazing.robot.lang.ast.AstBoundNode;
import org.kaazing.robot.lang.ast.AstChildClosedNode;
import org.kaazing.robot.lang.ast.AstChildOpenedNode;
import org.kaazing.robot.lang.ast.AstCloseHttpRequestNode;
import org.kaazing.robot.lang.ast.AstCloseHttpResponseNode;
import org.kaazing.robot.lang.ast.AstCloseNode;
import org.kaazing.robot.lang.ast.AstClosedNode;
import org.kaazing.robot.lang.ast.AstConnectNode;
import org.kaazing.robot.lang.ast.AstConnectedNode;
import org.kaazing.robot.lang.ast.AstDisconnectNode;
import org.kaazing.robot.lang.ast.AstDisconnectedNode;
import org.kaazing.robot.lang.ast.AstEndOfHttpHeadersNode;
import org.kaazing.robot.lang.ast.AstNode;
import org.kaazing.robot.lang.ast.AstOpenedNode;
import org.kaazing.robot.lang.ast.AstReadAwaitNode;
import org.kaazing.robot.lang.ast.AstReadHttpHeaderNode;
import org.kaazing.robot.lang.ast.AstReadHttpMethodNode;
import org.kaazing.robot.lang.ast.AstReadHttpParameterNode;
import org.kaazing.robot.lang.ast.AstReadHttpStatusNode;
import org.kaazing.robot.lang.ast.AstReadHttpVersionNode;
import org.kaazing.robot.lang.ast.AstReadNotifyNode;
import org.kaazing.robot.lang.ast.AstReadOptionNode;
import org.kaazing.robot.lang.ast.AstReadValueNode;
import org.kaazing.robot.lang.ast.AstScriptNode;
import org.kaazing.robot.lang.ast.AstStreamNode;
import org.kaazing.robot.lang.ast.AstStreamableNode;
import org.kaazing.robot.lang.ast.AstUnbindNode;
import org.kaazing.robot.lang.ast.AstUnboundNode;
import org.kaazing.robot.lang.ast.AstWriteAwaitNode;
import org.kaazing.robot.lang.ast.AstWriteHttpContentLengthNode;
import org.kaazing.robot.lang.ast.AstWriteHttpHeaderNode;
import org.kaazing.robot.lang.ast.AstWriteHttpMethodNode;
import org.kaazing.robot.lang.ast.AstWriteHttpParameterNode;
import org.kaazing.robot.lang.ast.AstWriteHttpStatusNode;
import org.kaazing.robot.lang.ast.AstWriteHttpVersionNode;
import org.kaazing.robot.lang.ast.AstWriteNotifyNode;
import org.kaazing.robot.lang.ast.AstWriteOptionNode;
import org.kaazing.robot.lang.ast.AstWriteValueNode;
import org.kaazing.robot.lang.ast.matcher.AstByteLengthBytesMatcher;
import org.kaazing.robot.lang.ast.matcher.AstExactBytesMatcher;
import org.kaazing.robot.lang.ast.matcher.AstExactTextMatcher;
import org.kaazing.robot.lang.ast.matcher.AstExpressionMatcher;
import org.kaazing.robot.lang.ast.matcher.AstFixedLengthBytesMatcher;
import org.kaazing.robot.lang.ast.matcher.AstIntLengthBytesMatcher;
import org.kaazing.robot.lang.ast.matcher.AstLongLengthBytesMatcher;
import org.kaazing.robot.lang.ast.matcher.AstRegexMatcher;
import org.kaazing.robot.lang.ast.matcher.AstShortLengthBytesMatcher;
import org.kaazing.robot.lang.ast.matcher.AstValueMatcher;
import org.kaazing.robot.lang.ast.matcher.AstVariableLengthBytesMatcher;
import org.kaazing.robot.lang.ast.value.AstExpressionValue;
import org.kaazing.robot.lang.ast.value.AstLiteralBytesValue;
import org.kaazing.robot.lang.ast.value.AstLiteralTextValue;
import org.kaazing.robot.lang.ast.value.AstValue;
import org.kaazing.robot.lang.el.ExpressionContext;

public class GenerateConfigurationVisitor
implements AstNode.Visitor<Configuration, State> {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(GenerateConfigurationVisitor.class);
    private static final MaskingDecoder DEFAULT_READ_UNMASKER = new DefaultReadUnmasker();
    private final ChannelAddressFactory addressFactory = ChannelAddressFactory.newChannelAddressFactory();
    private final BootstrapFactory bootstrapFactory = SingletonBootstrapFactory.getInstance();

    public Configuration visit(AstScriptNode script, State state) throws Exception {
        state.configuration = new Configuration();
        for (AstStreamNode stream : script.getStreams()) {
            stream.accept((AstNode.Visitor)this, (Object)state);
        }
        return state.configuration;
    }

    public Configuration visit(AstAcceptableNode acceptedNode, State state) throws Exception {
        state.readUnmasker = GenerateConfigurationVisitor.DEFAULT_READ_UNMASKER;
        switch (state.getProtocol()) {
            case HTTP: {
                state.pipelineAsMap = new LinkedHashMap();
                state.pipelineAsMap.put("loghandler", new LoggingHandler(true));
                state.pipelineAsMap.put("lastevent", new LogLastEventHandler(acceptedNode.getLocationInfo()));
                state.streamStartLocation = acceptedNode.getLocationInfo();
                HttpServerCodec httpServerCodec = new HttpServerCodec();
                HttpMessageAggregatingCodec httpMessageAggregatingCodec = new HttpMessageAggregatingCodec();
                HttpMessageSplittingCodec httpMessageSplittingCodec = new HttpMessageSplittingCodec();
                state.pipelineAsMap.put("http.codec.httpDefaultCodec", httpServerCodec);
                state.pipelineAsMap.put("http.codec.httpMessageAggregatingCodec", httpMessageAggregatingCodec);
                state.pipelineAsMap.put("http.codec.httpMessageSplittingCodec", httpMessageSplittingCodec);
                break;
            }
            case TCP: {
                state.pipelineAsMap = new LinkedHashMap();
                state.pipelineAsMap.put("loghandler", new LoggingHandler(true));
                state.pipelineAsMap.put("lastevent", new LogLastEventHandler(acceptedNode.getLocationInfo()));
                state.streamStartLocation = acceptedNode.getLocationInfo();
            }
        }
        for (AstStreamableNode streamable : acceptedNode.getStreamables()) {
            streamable.accept((AstNode.Visitor)this, (Object)state);
        }
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("completion#%d", pipelineAsMap.size() + 1);
        CompletionHandler c = new CompletionHandler();
        state.configuration.getCompletionHandlers().add(c);
        pipelineAsMap.put(handlerName, c);
        return null;
    }

    public Configuration visit(AstAcceptNode acceptNode, State state) throws Exception {
        URI acceptURI;
        Map savedPipelineAsMap = state.pipelineAsMap;
        state.readUnmasker = GenerateConfigurationVisitor.DEFAULT_READ_UNMASKER;
        HashSet<ChannelFuture> completionFutures = new HashSet<ChannelFuture>();
        URI tcpURI = acceptURI = acceptNode.getLocation();
        if (HttpUtils.isUriHttp(acceptURI)) {
            state.setProtocol(PROTOCOL.HTTP);
            DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            state.setHttpMessage((HttpMessage)httpResponse, acceptURI);
            tcpURI = this.tcpBindURIFromHttpURI(acceptURI);
        }
        final ArrayList<ChannelPipeline> pipelines = new ArrayList<ChannelPipeline>();
        for (AstAcceptableNode acceptableNode : acceptNode.getAcceptables()) {
            switch (state.getProtocol()) {
                case HTTP: {
                    state.pipelineAsMap = new LinkedHashMap();
                    break;
                }
                case TCP: {
                    state.pipelineAsMap = new LinkedHashMap();
                }
            }
            acceptableNode.accept((AstNode.Visitor)this, (Object)state);
            ChannelPipeline pipeline = GenerateConfigurationVisitor.pipelineFromMap(state.pipelineAsMap, state);
            ChannelHandlerContext context = pipeline.getContext(CompletionHandler.class);
            assert (context != null);
            completionFutures.add(((CompletionHandler)context.getHandler()).getHandlerFuture());
            pipelines.add(pipeline);
        }
        state.pipelineAsMap = savedPipelineAsMap;
        acceptURI = tcpURI;
        ChannelPipelineFactory pipelineFactory = new ChannelPipelineFactory(){
            private final Iterator<ChannelPipeline> i;
            {
                this.i = pipelines.iterator();
            }

            public ChannelPipeline getPipeline() throws Exception {
                return this.i.hasNext() ? this.i.next() : Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new FailureHandler(), new CompletionHandler()});
            }
        };
        Map acceptOptions = acceptNode.getOptions();
        ChannelAddress localAddress = this.addressFactory.newChannelAddress(acceptURI, acceptOptions);
        ServerBootstrap serverBootstrap = this.bootstrapFactory.newServerBootstrap(acceptURI.getScheme());
        serverBootstrap.setOptions(acceptOptions);
        serverBootstrap.setPipelineFactory(pipelineFactory);
        serverBootstrap.setOption("localAddress", localAddress);
        serverBootstrap.setOption("expectedChildCount", pipelines.size());
        serverBootstrap.setOption("completionFutures", completionFutures);
        serverBootstrap.setOption("locationInfo", acceptNode.getLocationInfo());
        state.configuration.getServerBootstraps().add(serverBootstrap);
        return state.configuration;
    }

    public Configuration visit(AstConnectNode connectNode, State state) throws Exception {
        URI connectURI = connectNode.getLocation();
        state.readUnmasker = GenerateConfigurationVisitor.DEFAULT_READ_UNMASKER;
        boolean isHttp = HttpUtils.isUriHttp(connectURI);
        if (isHttp) {
            state.setProtocol(PROTOCOL.HTTP);
            DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, connectURI.toString());
            state.setHttpMessage((HttpMessage)httpRequest, connectURI);
            connectURI = this.tcpBindURIFromHttpURI(connectURI);
        }
        Map connectOptions = connectNode.getOptions();
        state.pipelineAsMap = new LinkedHashMap();
        state.pipelineAsMap.put("loghandler", new LoggingHandler(true));
        if (isHttp) {
            HttpClientCodec httpClientCodec = new HttpClientCodec();
            HttpMessageAggregatingCodec httpMessageAggregatingCodec = new HttpMessageAggregatingCodec();
            HttpMessageSplittingCodec httpMessageSplittingCodec = new HttpMessageSplittingCodec();
            state.pipelineAsMap.put("http.codec.httpDefaultCodec", httpClientCodec);
            state.pipelineAsMap.put("http.codec.httpMessageAggregatingCodec", httpMessageAggregatingCodec);
            state.pipelineAsMap.put("http.codec.httpMessageSplittingCodec", httpMessageSplittingCodec);
        }
        state.pipelineAsMap.put("lastevent", new LogLastEventHandler(connectNode.getLocationInfo()));
        state.streamStartLocation = connectNode.getLocationInfo();
        for (AstStreamableNode streamable : connectNode.getStreamables()) {
            streamable.accept((AstNode.Visitor)this, (Object)state);
        }
        String handlerName = String.format("completion#%d", state.pipelineAsMap.size() + 1);
        CompletionHandler c = new CompletionHandler();
        state.pipelineAsMap.put(handlerName, c);
        state.configuration.getCompletionHandlers().add(c);
        ChannelAddress remoteAddress = this.addressFactory.newChannelAddress(connectURI);
        connectOptions.put("remoteAddress", remoteAddress);
        connectOptions.put("locationInfo", connectNode.getLocationInfo());
        ClientBootstrap clientBootstrap = this.bootstrapFactory.newClientBootstrap(connectURI.getScheme());
        final ChannelPipeline pipeline = GenerateConfigurationVisitor.pipelineFromMap(state.pipelineAsMap, state);
        ChannelPipelineFactory pipelineFactory = new ChannelPipelineFactory(){
            private int numCalled;

            public ChannelPipeline getPipeline() throws Exception {
                if (this.numCalled++ != 0) {
                    throw new RobotException("getPipeline called more than once");
                }
                return pipeline;
            }
        };
        clientBootstrap.setPipelineFactory(pipelineFactory);
        clientBootstrap.setOptions(connectOptions);
        state.configuration.getClientBootstraps().add(clientBootstrap);
        LOGGER.debug("Added client Bootstrap connecting to remoteAddress " + remoteAddress);
        return state.configuration;
    }

    public Configuration visit(AstReadAwaitNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        String barrierName = node.getBarrierName();
        Barrier barrier = state.lookupBarrier(barrierName);
        AwaitBarrierUpstreamHandler handler = new AwaitBarrierUpstreamHandler(barrier);
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("read.await#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        state.configuration.getBarriers().add(barrier);
        return state.configuration;
    }

    public Configuration visit(AstWriteAwaitNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        String barrierName = node.getBarrierName();
        Barrier barrier = state.lookupBarrier(barrierName);
        AwaitBarrierDownstreamHandler handler = new AwaitBarrierDownstreamHandler(barrier);
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("write.await#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        state.configuration.getBarriers().add(barrier);
        return state.configuration;
    }

    public Configuration visit(AstReadNotifyNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        String barrierName = node.getBarrierName();
        Barrier barrier = state.lookupBarrier(barrierName);
        NotifyBarrierHandler handler = new NotifyBarrierHandler(barrier);
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("read.notify#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        state.configuration.getBarriers().add(barrier);
        return state.configuration;
    }

    public Configuration visit(AstWriteNotifyNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        String barrierName = node.getBarrierName();
        Barrier barrier = state.lookupBarrier(barrierName);
        NotifyBarrierHandler handler = new NotifyBarrierHandler(barrier);
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("write.notify#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        state.configuration.getBarriers().add(barrier);
        return state.configuration;
    }

    public Configuration visit(AstWriteValueNode node, State state) throws Exception {
        ArrayList<MessageEncoder> messageEncoders = new ArrayList<MessageEncoder>();
        for (AstValue val : node.getValues()) {
            messageEncoders.add((MessageEncoder)val.accept((AstValue.Visitor)new GenerateWriteEncoderVisitor(), (Object)state.configuration));
        }
        WriteHandler handler = new WriteHandler(messageEncoders);
        handler.setLocationInfo(node.getLocationInfo());
        String handlerName = String.format("write#%d", state.pipelineAsMap.size() + 1);
        state.pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstDisconnectNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        DisconnectHandler handler = new DisconnectHandler();
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("disconnect#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstUnbindNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        UnbindHandler handler = new UnbindHandler();
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("unbind#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstCloseNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        CloseHandler handler = new CloseHandler();
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("close#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstChildOpenedNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        ChildOpenedHandler handler = new ChildOpenedHandler();
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("childOpened#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstChildClosedNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        ChildClosedHandler handler = new ChildClosedHandler();
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("childClosed#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstOpenedNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        OpenedHandler handler = new OpenedHandler();
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("opened#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstBoundNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        BoundHandler handler = new BoundHandler();
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("bound#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstConnectedNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        ConnectedHandler handler = new ConnectedHandler();
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("connected#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstReadValueNode node, State state) throws Exception {
        ArrayList<MessageDecoder> messageDecoders = new ArrayList<MessageDecoder>();
        for (AstValueMatcher matcher : node.getMatchers()) {
            messageDecoders.add((MessageDecoder)matcher.accept((AstValueMatcher.Visitor)new GenerateReadDecoderVisitor(), (Object)state.configuration));
        }
        ReadHandler handler = new ReadHandler(messageDecoders, state.readUnmasker);
        handler.setLocationInfo(node.getLocationInfo());
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("read#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstDisconnectedNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        DisconnectedHandler handler = new DisconnectedHandler();
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("disconnected#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstUnboundNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        UnboundHandler handler = new UnboundHandler();
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("unbound#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstClosedNode node, State state) throws Exception {
        LocationInfo locationInfo = node.getLocationInfo();
        ClosedHandler handler = new ClosedHandler();
        handler.setLocationInfo(locationInfo);
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("closed#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    private static ChannelPipeline pipelineFromMap(Map<String, ChannelHandler> pipelineAsMap, State state) {
        ChannelPipeline pipeline = Channels.pipeline();
        for (Map.Entry<String, ChannelHandler> entry : pipelineAsMap.entrySet()) {
            if (entry.getValue() instanceof ExecutionHandler) {
                ExecutionHandler handler = (ExecutionHandler)entry.getValue();
                handler.setStreamStartLocation(state.streamStartLocation);
            }
            pipeline.addLast(entry.getKey(), entry.getValue());
        }
        return pipeline;
    }

    public Configuration visit(AstReadHttpHeaderNode node, State state) throws Exception {
        AstLiteralTextValue name = node.getName();
        AstValueMatcher value = node.getValue();
        MessageDecoder valueDecoder = (MessageDecoder)value.accept((AstValueMatcher.Visitor)new GenerateReadDecoderVisitor(), (Object)state.configuration);
        ReadHttpHeaderDecoder headerDecoder = new ReadHttpHeaderDecoder(name.getValue(), valueDecoder);
        ReadHttpHandler handler = new ReadHttpHandler(headerDecoder);
        handler.setLocationInfo(node.getLocationInfo());
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("readHttpHeader#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstWriteHttpHeaderNode node, State state) throws Exception {
        AstValue name = node.getName();
        AstValue value = node.getValue();
        MessageEncoder nameEncoder = (MessageEncoder)name.accept((AstValue.Visitor)new GenerateWriteEncoderVisitor(), (Object)state.configuration);
        MessageEncoder valueEncoder = (MessageEncoder)value.accept((AstValue.Visitor)new GenerateWriteEncoderVisitor(), (Object)state.configuration);
        WriteHttpHeaderEncoder httpEncoder = new WriteHttpHeaderEncoder(nameEncoder, valueEncoder);
        WriteHttpHandler handler = new WriteHttpHandler(state.getHttpMessage(), httpEncoder);
        handler.setLocationInfo(node.getLocationInfo());
        String handlerName = String.format("writeHttpHeader#%d", state.pipelineAsMap.size() + 1);
        state.pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstWriteHttpContentLengthNode node, State state) throws Exception {
        WriteHttpContentLengthHandler handler = new WriteHttpContentLengthHandler(state.getHttpMessage());
        handler.setLocationInfo(node.getLocationInfo());
        String handlerName = String.format("writeHttpContentLength#%d", state.pipelineAsMap.size() + 1);
        state.pipelineAsMap.put(handlerName, handler);
        return null;
    }

    public Configuration visit(AstReadHttpMethodNode node, State state) throws Exception {
        AstValueMatcher method = node.getMethod();
        MessageDecoder methodValueDecoder = (MessageDecoder)method.accept((AstValueMatcher.Visitor)new GenerateReadDecoderVisitor(), (Object)state.configuration);
        ReadHttpMethodDecoder httpDecoder = new ReadHttpMethodDecoder(methodValueDecoder);
        ReadHttpHandler handler = new ReadHttpHandler(httpDecoder);
        handler.setLocationInfo(node.getLocationInfo());
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("readHttpMethod#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstWriteHttpMethodNode node, State state) throws Exception {
        AstValue method = node.getMethod();
        MessageEncoder methodEncoder = (MessageEncoder)method.accept((AstValue.Visitor)new GenerateWriteEncoderVisitor(), (Object)state.configuration);
        WriteHttpMethodEncoder httpEncoder = new WriteHttpMethodEncoder(methodEncoder);
        WriteHttpHandler handler = new WriteHttpHandler(state.getHttpMessage(), httpEncoder);
        handler.setLocationInfo(node.getLocationInfo());
        String handlerName = String.format("writeHttpMethod#%d", state.pipelineAsMap.size() + 1);
        state.pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstReadHttpParameterNode node, State state) throws Exception {
        AstLiteralTextValue key = node.getKey();
        AstValueMatcher value = node.getValue();
        MessageDecoder valueDecoder = (MessageDecoder)value.accept((AstValueMatcher.Visitor)new GenerateReadDecoderVisitor(), (Object)state.configuration);
        ReadHttpParameterDecoder paramDecoder = new ReadHttpParameterDecoder(key.getValue(), valueDecoder);
        ReadHttpHandler handler = new ReadHttpHandler(paramDecoder);
        handler.setLocationInfo(node.getLocationInfo());
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("readHttpParameter#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstWriteHttpParameterNode node, State state) throws Exception {
        AstValue key = node.getKey();
        AstValue value = node.getValue();
        MessageEncoder keyEncoder = (MessageEncoder)key.accept((AstValue.Visitor)new GenerateWriteEncoderVisitor(), (Object)state.configuration);
        MessageEncoder valueEncoder = (MessageEncoder)value.accept((AstValue.Visitor)new GenerateWriteEncoderVisitor(), (Object)state.configuration);
        WriteHttpParameterEncoder httpEncoder = new WriteHttpParameterEncoder(keyEncoder, valueEncoder);
        WriteHttpHandler handler = new WriteHttpHandler(state.getHttpMessage(), httpEncoder);
        handler.setLocationInfo(node.getLocationInfo());
        String handlerName = String.format("writeHttpParameter#%d", state.pipelineAsMap.size() + 1);
        state.pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstReadHttpVersionNode node, State state) throws Exception {
        AstValueMatcher version = node.getVersion();
        MessageDecoder versionDecoder = (MessageDecoder)version.accept((AstValueMatcher.Visitor)new GenerateReadDecoderVisitor(), (Object)state.configuration);
        ReadHttpVersionDecoder httpVersionDecoder = new ReadHttpVersionDecoder(versionDecoder);
        ReadHttpHandler handler = new ReadHttpHandler(httpVersionDecoder);
        handler.setLocationInfo(node.getLocationInfo());
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("readHttpVersion#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstWriteHttpVersionNode node, State state) throws Exception {
        AstValue version = node.getVersion();
        MessageEncoder versionEncoder = (MessageEncoder)version.accept((AstValue.Visitor)new GenerateWriteEncoderVisitor(), (Object)state.configuration);
        WriteHttpVersionEncoder httpEncoder = new WriteHttpVersionEncoder(versionEncoder);
        WriteHttpHandler handler = new WriteHttpHandler(state.getHttpMessage(), httpEncoder);
        handler.setLocationInfo(node.getLocationInfo());
        String handlerName = String.format("writeHttpVersion#%d", state.pipelineAsMap.size() + 1);
        state.pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstReadHttpStatusNode node, State state) throws Exception {
        AstValueMatcher code = node.getCode();
        AstValueMatcher reason = node.getReason();
        MessageDecoder codeDecoder = (MessageDecoder)code.accept((AstValueMatcher.Visitor)new GenerateReadDecoderVisitor(), (Object)state.configuration);
        MessageDecoder reasonDecoder = (MessageDecoder)reason.accept((AstValueMatcher.Visitor)new GenerateReadDecoderVisitor(), (Object)state.configuration);
        ReadHttpStatusDecoder statusDecoder = new ReadHttpStatusDecoder(codeDecoder, reasonDecoder);
        ReadHttpHandler handler = new ReadHttpHandler(statusDecoder);
        handler.setLocationInfo(node.getLocationInfo());
        Map pipelineAsMap = state.pipelineAsMap;
        String handlerName = String.format("readHttpStatus#%d", pipelineAsMap.size() + 1);
        pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    public Configuration visit(AstWriteHttpStatusNode node, State state) throws Exception {
        AstValue code = node.getCode();
        AstValue reason = node.getReason();
        MessageEncoder codeEncoder = (MessageEncoder)code.accept((AstValue.Visitor)new GenerateWriteEncoderVisitor(), (Object)state.configuration);
        MessageEncoder reasonEncoder = (MessageEncoder)reason.accept((AstValue.Visitor)new GenerateWriteEncoderVisitor(), (Object)state.configuration);
        WriteHttpStatusEncoder httpEncoder = new WriteHttpStatusEncoder(codeEncoder, reasonEncoder);
        WriteHttpHandler handler = new WriteHttpHandler(state.getHttpMessage(), httpEncoder);
        handler.setLocationInfo(node.getLocationInfo());
        String handlerName = String.format("writeHttpStatus#%d", state.pipelineAsMap.size() + 1);
        state.pipelineAsMap.put(handlerName, handler);
        return state.configuration;
    }

    private URI tcpBindURIFromHttpURI(URI httpURI) {
        URI resultingURI = httpURI.getPort() == -1 ? URI.create(String.format("tcp://%s:80", httpURI.getAuthority())) : URI.create(String.format("tcp://%s", httpURI.getAuthority()));
        return resultingURI;
    }

    public Configuration visit(AstCloseHttpRequestNode node, State state) throws Exception {
        HTTP_DIRECTION direction = state.getAndSwapDirection();
        String handlerName = String.format("closeHttpRequest#%d", state.pipelineAsMap.size() + 1);
        ExecutionHandler handler = null;
        switch (direction) {
            case READ: {
                handler = new CloseReadHttpRequestHandler();
                break;
            }
            case WRITE: {
                handler = new CloseWriteHttpRequestHandler();
            }
        }
        assert (handler != null);
        state.protocol = PROTOCOL.TCP;
        state.pipelineAsMap.put(handlerName, handler);
        handler.setLocationInfo(node.getLocationInfo());
        return state.configuration;
    }

    public Configuration visit(AstCloseHttpResponseNode node, State state) throws Exception {
        HTTP_DIRECTION direction = state.getHttpDirection();
        String handlerName = String.format("closeHttpResponse#%d", state.pipelineAsMap.size() + 1);
        ExecutionHandler handler = null;
        switch (direction) {
            case READ: {
                handler = new CloseReadHttpResponseHandler();
                break;
            }
            case WRITE: {
                handler = new CloseWriteHttpResponseHandler();
            }
        }
        assert (handler != null);
        state.pipelineAsMap.put(handlerName, handler);
        handler.setLocationInfo(node.getLocationInfo());
        return state.configuration;
    }

    public Configuration visit(AstEndOfHttpHeadersNode node, State state) throws Exception {
        HTTP_DIRECTION direction = state.getHttpDirection();
        String handlerName = String.format("endOfHttpHeaders#%d", state.pipelineAsMap.size() + 1);
        ExecutionHandler handler = null;
        switch (direction) {
            case READ: {
                handler = new EndOfReadHttpHeadersHandler();
                break;
            }
            case WRITE: {
                handler = new EndOfWriteHttpHeadersHandler(state.getHttpMessage());
            }
        }
        assert (handler != null);
        state.pipelineAsMap.put(handlerName, handler);
        handler.setLocationInfo(node.getLocationInfo());
        return state.configuration;
    }

    public Configuration visit(AstReadOptionNode node, State parameter) throws Exception {
        return null;
    }

    public Configuration visit(AstWriteOptionNode node, State parameter) throws Exception {
        return null;
    }

    private static final class GenerateReadDecoderVisitor
    implements AstValueMatcher.Visitor<MessageDecoder, Configuration> {
        private GenerateReadDecoderVisitor() {
        }

        public MessageDecoder visit(AstExpressionMatcher matcher, Configuration config) throws Exception {
            ValueExpression expression = matcher.getValue();
            ExpressionContext environment = config.getExpressionContext();
            return new ReadExpressionDecoder(expression, environment);
        }

        public MessageDecoder visit(AstFixedLengthBytesMatcher matcher, Configuration config) throws Exception {
            int length = matcher.getLength();
            String captureName = matcher.getCaptureName();
            ExpressionContext environment = config.getExpressionContext();
            ReadByteArrayBytesDecoder decoder = captureName != null ? new ReadByteArrayBytesDecoder(length, environment, captureName) : new ReadByteArrayBytesDecoder(length);
            return decoder;
        }

        public MessageDecoder visit(AstByteLengthBytesMatcher matcher, Configuration config) throws Exception {
            return this.fixedLengthVisit((AstFixedLengthBytesMatcher)matcher, config, ReadByteLengthBytesDecoder.class);
        }

        public MessageDecoder visit(AstShortLengthBytesMatcher matcher, Configuration config) throws Exception {
            return this.fixedLengthVisit((AstFixedLengthBytesMatcher)matcher, config, ReadShortLengthBytesDecoder.class);
        }

        public MessageDecoder visit(AstIntLengthBytesMatcher matcher, Configuration config) throws Exception {
            return this.fixedLengthVisit((AstFixedLengthBytesMatcher)matcher, config, ReadIntLengthBytesDecoder.class);
        }

        public MessageDecoder visit(AstLongLengthBytesMatcher matcher, Configuration config) throws Exception {
            return this.fixedLengthVisit((AstFixedLengthBytesMatcher)matcher, config, ReadLongLengthBytesDecoder.class);
        }

        private MessageDecoder fixedLengthVisit(AstFixedLengthBytesMatcher matcher, Configuration config, Class<?> clazz) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            String captureName = matcher.getCaptureName();
            ExpressionContext environment = config.getExpressionContext();
            Constructor<?> constructor = clazz.getConstructor(ExpressionContext.class, String.class);
            return (MessageDecoder)constructor.newInstance(environment, captureName);
        }

        public MessageDecoder visit(AstRegexMatcher matcher, Configuration config) throws Exception {
            ExpressionContext environment = config.getExpressionContext();
            ReadRegexDecoder result = new ReadRegexDecoder(matcher.getValue(), CharsetUtil.UTF_8, environment);
            return result;
        }

        public MessageDecoder visit(AstExactTextMatcher matcher, Configuration config) throws Exception {
            return new ReadExactTextDecoder(matcher.getValue(), CharsetUtil.UTF_8);
        }

        public MessageDecoder visit(AstExactBytesMatcher matcher, Configuration config) throws Exception {
            return new ReadExactBytesDecoder(matcher.getValue());
        }

        public MessageDecoder visit(AstVariableLengthBytesMatcher matcher, Configuration config) throws Exception {
            ValueExpression length = matcher.getLength();
            String captureName = matcher.getCaptureName();
            ExpressionContext environment = config.getExpressionContext();
            ReadVariableLengthBytesDecoder decoder = captureName != null ? new ReadVariableLengthBytesDecoder(length, environment, captureName) : new ReadVariableLengthBytesDecoder(length, environment);
            return decoder;
        }
    }

    private static final class GenerateWriteEncoderVisitor
    implements AstValue.Visitor<MessageEncoder, Configuration> {
        private GenerateWriteEncoderVisitor() {
        }

        public MessageEncoder visit(AstExpressionValue value, Configuration config) throws Exception {
            ExpressionContext environment = config.getExpressionContext();
            return new WriteExpressionEncoder(value.getValue(), environment);
        }

        public MessageEncoder visit(AstLiteralTextValue value, Configuration config) throws Exception {
            return new WriteTextEncoder(value.getValue(), CharsetUtil.UTF_8);
        }

        public MessageEncoder visit(AstLiteralBytesValue value, Configuration config) throws Exception {
            return new WriteBytesEncoder(value.getValue());
        }
    }

    public static enum HTTP_DIRECTION {
        READ,
        WRITE;

    }

    public static enum PROTOCOL {
        TCP,
        HTTP;

    }

    private static final class DefaultReadUnmasker
    extends MaskingDecoder {
        private DefaultReadUnmasker() {
        }

        @Override
        public ChannelBuffer applyMask(ChannelBuffer buffer) throws Exception {
            return buffer;
        }

        @Override
        public ChannelBuffer undoMask(ChannelBuffer buffer) throws Exception {
            return buffer;
        }
    }

    public static final class State {
        private final ConcurrentMap<String, Barrier> barriersByName;
        private Configuration configuration;
        private LocationInfo streamStartLocation;
        private PROTOCOL protocol = PROTOCOL.TCP;
        private MaskingDecoder readUnmasker;
        private Map<String, ChannelHandler> pipelineAsMap;
        private HTTP_DIRECTION httpDirection;
        private HttpMessage httpMessage;
        private URI httpURI;

        public State() {
            this.barriersByName = new ConcurrentHashMap<String, Barrier>();
        }

        private Barrier lookupBarrier(String barrierName) {
            Barrier newBarrier;
            Barrier barrier = (Barrier)this.barriersByName.get(barrierName);
            if (barrier == null && (barrier = this.barriersByName.putIfAbsent(barrierName, newBarrier = new Barrier())) == null) {
                barrier = newBarrier;
            }
            return barrier;
        }

        public PROTOCOL getProtocol() {
            return this.protocol;
        }

        public void setProtocol(PROTOCOL protocol) {
            this.protocol = protocol;
        }

        public HttpMessage getHttpMessage() {
            return this.httpMessage;
        }

        public void setHttpMessage(HttpMessage httpMessage, URI httpURI) {
            if (httpMessage instanceof HttpRequest) {
                this.httpDirection = HTTP_DIRECTION.WRITE;
                String path = httpURI.getPath();
                if (path.length() == 0) {
                    path = "/";
                }
                ((HttpRequest)httpMessage).setUri(path);
            } else if (httpMessage instanceof HttpResponse) {
                this.httpDirection = HTTP_DIRECTION.READ;
            }
            this.httpMessage = httpMessage;
            this.setHttpURI(httpURI);
        }

        public HTTP_DIRECTION getHttpDirection() {
            return this.httpDirection;
        }

        public HTTP_DIRECTION getAndSwapDirection() {
            HTTP_DIRECTION currentDirection = this.httpDirection;
            switch (this.httpDirection) {
                case READ: {
                    this.httpDirection = HTTP_DIRECTION.WRITE;
                    break;
                }
                case WRITE: {
                    this.httpDirection = HTTP_DIRECTION.READ;
                }
            }
            return currentDirection;
        }

        public URI getHttpURI() {
            return this.httpURI;
        }

        public void setHttpURI(URI httpURI) {
            this.httpURI = httpURI;
        }

        public class PipelineFactory {
            private Map<URI, List<ChannelPipeline>> pipelines = new HashMap<URI, List<ChannelPipeline>>();

            public List<ChannelPipeline> getPipeline(URI acceptURI) {
                List<ChannelPipeline> pipeline = this.pipelines.get(acceptURI);
                if (pipeline == null) {
                    pipeline = new ArrayList<ChannelPipeline>();
                    this.pipelines.put(acceptURI, pipeline);
                }
                return pipeline;
            }
        }
    }
}

