/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.buffer;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferIndexFinder;

public class FastIndexFinder
implements ChannelBufferIndexFinder {
    private byte[] pattern;
    private int[] partialMatch;

    private void generatePartialMatch() {
        this.partialMatch = new int[this.pattern.length];
        int j = 0;
        for (int i = 1; i < this.pattern.length; ++i) {
            while (j > 0 && this.pattern[j] != this.pattern[i]) {
                j = this.partialMatch[j - 1];
            }
            if (this.pattern[j] == this.pattern[i]) {
                // empty if block
            }
            this.partialMatch[i] = ++j;
        }
    }

    public FastIndexFinder(byte[] pattern) {
        this.pattern = pattern;
        this.generatePartialMatch();
    }

    public FastIndexFinder(ChannelBuffer buf) {
        int len = buf.readableBytes();
        this.pattern = new byte[len];
        buf.getBytes(buf.readerIndex(), this.pattern);
        this.generatePartialMatch();
    }

    public boolean find(ChannelBuffer buf, int guessedIndex) {
        int j = 0;
        if (buf.getByte(guessedIndex) != this.pattern[j]) {
            return false;
        }
        for (int i = guessedIndex; i < buf.readableBytes(); ++i) {
            while (j > 0 && this.pattern[j] != buf.getByte(i)) {
                if ((j = this.partialMatch[j - 1]) != 0) continue;
                return false;
            }
            if (this.pattern[j] == buf.getByte(i)) {
                ++j;
            }
            if (j != this.pattern.length) continue;
            return true;
        }
        return false;
    }
}

