/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.control.handler;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.robot.driver.control.AbortMessage;
import org.kaazing.robot.driver.control.ControlMessage;
import org.kaazing.robot.driver.control.ErrorMessage;
import org.kaazing.robot.driver.control.FinishedMessage;
import org.kaazing.robot.driver.control.PrepareMessage;
import org.kaazing.robot.driver.control.StartMessage;
import org.kaazing.robot.driver.util.Utils;

public class ControlDecoder
extends ReplayingDecoder<State> {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ControlDecoder.class);
    private final int maxInitialLineLength;
    private final int maxHeaderLineLength;
    private final int maxContentLength;
    private ControlMessage message;
    private int contentLength;
    private boolean hasReceivedPrepare;

    public ControlDecoder() {
        this(1024, 1024, 32768);
    }

    public ControlDecoder(int maxInitialLineLength, int maxHeaderLineLength, int maxContentLength) {
        super(false);
        this.maxInitialLineLength = maxInitialLineLength;
        this.maxHeaderLineLength = maxHeaderLineLength;
        this.maxContentLength = maxContentLength;
        this.setState(State.READ_INITIAL);
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, State state) throws Exception {
        LOGGER.debug("decode: state=" + (Object)((Object)state));
        switch (state) {
            case READ_INITIAL: {
                String initialLine = ControlDecoder.readLine(buffer, this.maxInitialLineLength);
                if (initialLine != null) {
                    this.message = this.createMessage(initialLine);
                    this.contentLength = 0;
                    this.checkpoint(State.READ_HEADER);
                    LOGGER.debug("Received initialLine. Message is=" + this.message);
                }
                LOGGER.debug("initialLine is null. Message is=" + this.message);
                return null;
            }
            case READ_HEADER: {
                State nextState = this.readHeader(buffer);
                this.checkpoint(nextState);
                if (nextState == State.READ_INITIAL) {
                    LOGGER.debug("State changed to READ_INITIAL return message=" + this.message);
                    return this.message;
                }
                LOGGER.debug("State didn't change to initial after reading header message=" + this.message);
                return null;
            }
            case READ_CONTENT: {
                State nextState = this.readContent(buffer);
                this.checkpoint(nextState);
                if (nextState != State.READ_CONTENT) {
                    LOGGER.debug("State changed to " + (Object)((Object)nextState) + " after reading content. Message=" + this.message);
                    return this.message;
                }
                LOGGER.debug("State didn't change to initial after reading content. Message=" + this.message);
                return null;
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized decoder state: %s", new Object[]{state}));
    }

    private static String readLine(ChannelBuffer buffer, int maxLineLength) {
        int readableBytes = buffer.readableBytes();
        if (readableBytes == 0) {
            return null;
        }
        int readerIndex = buffer.readerIndex();
        int endOfLineAt = buffer.indexOf(readerIndex, Math.min(readableBytes, maxLineLength) + 1, (byte)10);
        if (readerIndex > 0) {
            LOGGER.debug(String.format("readLine: endofLineAt=%d, readableBytes=%d, readerIndex=%d", endOfLineAt, readableBytes, readerIndex));
        }
        if (endOfLineAt == -1) {
            if (readableBytes >= maxLineLength) {
                throw new IllegalArgumentException("Initial line too long");
            }
            return null;
        }
        StringBuilder sb = new StringBuilder(endOfLineAt);
        for (int i = readerIndex; i < endOfLineAt; ++i) {
            sb.append((char)buffer.readByte());
        }
        byte endOfLine = buffer.readByte();
        assert (endOfLine == 10);
        return sb.toString();
    }

    private ControlMessage createMessage(String initialLine) {
        LOGGER.debug("Creating message with line |" + initialLine + "|");
        ControlMessage.Kind messageKind = ControlMessage.Kind.valueOf(initialLine);
        switch (messageKind) {
            case PREPARE: {
                this.hasReceivedPrepare = true;
                return new PrepareMessage();
            }
            case START: {
                if (!this.hasReceivedPrepare) {
                    PrepareMessage newMessage = new PrepareMessage();
                    newMessage.setCompatibilityKind(messageKind);
                    return newMessage;
                }
                this.hasReceivedPrepare = false;
                return new StartMessage();
            }
            case ABORT: {
                this.hasReceivedPrepare = false;
                return new AbortMessage();
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized message kind: %s", new Object[]{messageKind}));
    }

    private State readHeader(ChannelBuffer buffer) {
        int colonSearchTo;
        int endOfLineSearchTo;
        int readableBytes = buffer.readableBytes();
        if (readableBytes == 0) {
            LOGGER.debug("No readable bytes found");
            return null;
        }
        int endOfLineSearchFrom = buffer.readerIndex();
        int endOfLineAt = buffer.indexOf(endOfLineSearchFrom, (endOfLineSearchTo = Math.min(readableBytes, this.maxHeaderLineLength)) + 1, (byte)10);
        if (endOfLineAt == -1) {
            if (readableBytes >= this.maxHeaderLineLength) {
                throw new IllegalArgumentException("Header line too long");
            }
            LOGGER.debug("endOfLineAt=-1");
            return null;
        }
        if (endOfLineAt == endOfLineSearchFrom) {
            byte endOfLine = buffer.readByte();
            assert (endOfLine == 10);
            if (this.contentLength == 0) {
                LOGGER.debug("Content Length is 0 so returning state initial");
                return State.READ_INITIAL;
            }
            switch (this.message.getKind()) {
                case PREPARE: 
                case FINISHED: 
                case ERROR: {
                    LOGGER.debug("Change state to READ_CONTENT");
                    return State.READ_CONTENT;
                }
            }
            LOGGER.debug("Change state to READ_INITIAL. Message not recongized and endOfLineAt equals endOfLineSearchForm");
            return State.READ_INITIAL;
        }
        int colonSearchFrom = buffer.readerIndex();
        int colonAt = buffer.indexOf(colonSearchFrom, (colonSearchTo = Math.min(readableBytes, endOfLineAt)) + 1, (byte)58);
        if (colonAt == -1) {
            throw new IllegalArgumentException("Colon not found in header line");
        }
        int headerNameLength = colonAt - colonSearchFrom;
        StringBuilder headerNameBuilder = new StringBuilder(headerNameLength);
        for (int i = 0; i < headerNameLength; ++i) {
            headerNameBuilder.append((char)buffer.readByte());
        }
        String headerName = headerNameBuilder.toString();
        byte colon = buffer.readByte();
        assert (colon == 58);
        int headerValueLength = endOfLineAt - colonAt - 1;
        StringBuilder headerValueBuilder = new StringBuilder(headerValueLength);
        for (int i = 0; i < headerValueLength; ++i) {
            headerValueBuilder.append((char)buffer.readByte());
        }
        String headerValue = headerValueBuilder.toString();
        if ("name".equals(headerName)) {
            this.message.setScriptName(headerValue);
        } else if ("content-length".equals(headerName)) {
            this.contentLength = Integer.parseInt(headerValue);
            if (this.contentLength > this.maxContentLength) {
                throw new IllegalArgumentException("Content too long");
            }
        } else {
            switch (this.message.getKind()) {
                case ERROR: {
                    ErrorMessage errorMessage = (ErrorMessage)this.message;
                    if (!"summary".equals(headerName)) break;
                    errorMessage.setSummary(headerValue);
                    break;
                }
                case PREPARE: {
                    PrepareMessage prepareMessage = (PrepareMessage)this.message;
                    if (!"content-type".equals(headerName)) break;
                    prepareMessage.setScriptFormatOverride(headerValue);
                }
            }
        }
        byte endOfLine = buffer.readByte();
        assert (endOfLine == 10);
        return State.READ_HEADER;
    }

    private State readContent(ChannelBuffer buffer) {
        assert (this.contentLength > 0);
        if (buffer.readableBytes() < this.contentLength) {
            return State.READ_CONTENT;
        }
        String content = buffer.readBytes(this.contentLength).toString(CharsetUtil.UTF_8);
        switch (this.message.getKind()) {
            case PREPARE: {
                PrepareMessage prepareMessage = (PrepareMessage)this.message;
                prepareMessage.setExpectedScriptPath(content);
                prepareMessage.setExpectedScript(Utils.readFileIntoString(content));
                break;
            }
            case FINISHED: {
                FinishedMessage finishedMessage = (FinishedMessage)this.message;
                finishedMessage.setObservedScript(content);
                break;
            }
            case ERROR: {
                ErrorMessage errorMessage = (ErrorMessage)this.message;
                errorMessage.setDescription(content);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected message kind: " + (Object)((Object)this.message.getKind()));
            }
        }
        return State.READ_INITIAL;
    }

    static enum State {
        READ_INITIAL,
        READ_HEADER,
        READ_CONTENT;

    }
}

