/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.control.handler;

import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.jboss.netty.util.CharsetUtil;
import org.kaazing.robot.driver.control.ControlMessage;
import org.kaazing.robot.driver.control.ErrorMessage;
import org.kaazing.robot.driver.control.FinishedMessage;
import org.kaazing.robot.driver.control.PreparedMessage;
import org.kaazing.robot.driver.control.StartedMessage;

public class ControlEncoder
extends OneToOneEncoder {
    private static final byte LF = 10;

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object message) throws Exception {
        if (message instanceof ControlMessage) {
            ControlMessage controlMessage = (ControlMessage)message;
            switch (controlMessage.getKind()) {
                case PREPARED: {
                    return this.encodePreparedMessage(ctx, channel, (PreparedMessage)controlMessage);
                }
                case STARTED: {
                    return this.encodeStartedMessage(ctx, channel, (StartedMessage)controlMessage);
                }
                case ERROR: {
                    return this.encodeErrorMessage(ctx, channel, (ErrorMessage)controlMessage);
                }
                case FINISHED: {
                    return this.encodeFinishedMessage(ctx, channel, (FinishedMessage)controlMessage);
                }
            }
        }
        return message;
    }

    private Object encodePreparedMessage(ChannelHandlerContext ctx, Channel channel, PreparedMessage preparedMessage) {
        ControlMessage.Kind kind = preparedMessage.getKind();
        String scriptName = preparedMessage.getScriptName();
        ChannelBuffer header = ChannelBuffers.dynamicBuffer((ChannelBufferFactory)channel.getConfig().getBufferFactory());
        ControlEncoder.encodeInitial(kind, header);
        ControlEncoder.encodeNameHeader(scriptName, header);
        return ControlEncoder.encodeNoContent(header);
    }

    private Object encodeStartedMessage(ChannelHandlerContext ctx, Channel channel, StartedMessage startedMessage) {
        ControlMessage.Kind kind = startedMessage.getKind();
        String scriptName = startedMessage.getScriptName();
        ChannelBuffer header = ChannelBuffers.dynamicBuffer((ChannelBufferFactory)channel.getConfig().getBufferFactory());
        ControlEncoder.encodeInitial(kind, header);
        ControlEncoder.encodeNameHeader(scriptName, header);
        return ControlEncoder.encodeNoContent(header);
    }

    private Object encodeErrorMessage(ChannelHandlerContext ctx, Channel channel, ErrorMessage errorMessage) {
        ControlMessage.Kind kind = errorMessage.getKind();
        String scriptName = errorMessage.getScriptName();
        String summary = errorMessage.getSummary();
        String description = errorMessage.getDescription();
        ChannelBuffer header = ChannelBuffers.dynamicBuffer((ChannelBufferFactory)channel.getConfig().getBufferFactory());
        ControlEncoder.encodeInitial(kind, header);
        ControlEncoder.encodeNameHeader(scriptName, header);
        ControlEncoder.encodeHeader("summary", summary, header);
        return ControlEncoder.encodeContent(description, header);
    }

    private Object encodeFinishedMessage(ChannelHandlerContext ctx, Channel channel, FinishedMessage finishedMessage) {
        ControlMessage.Kind kind = finishedMessage.getKind();
        String scriptName = finishedMessage.getScriptName();
        String expectedScript = finishedMessage.getExpectedScript();
        String observedScript = finishedMessage.getObservedScript();
        ChannelBuffer header = ChannelBuffers.dynamicBuffer((ChannelBufferFactory)channel.getConfig().getBufferFactory());
        ControlEncoder.encodeInitial(kind, header);
        ControlEncoder.encodeNameHeader(scriptName, header);
        Object encoded = ControlEncoder.encodeContent(expectedScript, header);
        ChannelBuffer content = ChannelBuffers.dynamicBuffer((ChannelBufferFactory)channel.getConfig().getBufferFactory());
        Object encodedEnd = ControlEncoder.encodeContent(observedScript, content);
        if (encoded instanceof ChannelBuffer && encodedEnd instanceof ChannelBuffer) {
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{(ChannelBuffer)encoded, (ChannelBuffer)encodedEnd});
        }
        throw new IllegalStateException("Expected Objects returned from encodeContent to be of type ChannelBuffer");
    }

    private static void encodeInitial(ControlMessage.Kind kind, ChannelBuffer header) {
        header.writeBytes(ChannelBuffers.copiedBuffer((CharSequence)kind.toString(), (Charset)CharsetUtil.UTF_8));
        header.writeByte(10);
    }

    private static void encodeNameHeader(String scriptName, ChannelBuffer header) {
        if (scriptName != null) {
            header.writeBytes(ChannelBuffers.copiedBuffer((CharSequence)String.format("name:%s", scriptName), (Charset)CharsetUtil.UTF_8));
            header.writeByte(10);
        }
    }

    private static void encodeHeader(String headerName, Object headerValue, ChannelBuffer header) {
        if (headerValue != null) {
            header.writeBytes(ChannelBuffers.copiedBuffer((CharSequence)String.format("%s:%s", headerName, headerValue), (Charset)CharsetUtil.UTF_8));
            header.writeByte(10);
        }
    }

    private static Object encodeNoContent(ChannelBuffer header) {
        header.writeByte(10);
        return header;
    }

    private static Object encodeContent(String contentAsString, ChannelBuffer header) {
        if (contentAsString != null) {
            ChannelBuffer content = ChannelBuffers.copiedBuffer((CharSequence)contentAsString, (Charset)CharsetUtil.UTF_8);
            ControlEncoder.encodeHeader("content-length", content.readableBytes(), header);
            header.writeByte(10);
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{header, content});
        }
        header.writeBytes(ChannelBuffers.copiedBuffer((CharSequence)"content-length:0", (Charset)CharsetUtil.UTF_8));
        header.writeByte(10);
        header.writeByte(10);
        return header;
    }
}

