/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.control.handler;

import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.Robot;
import org.kaazing.robot.driver.behavior.RobotCompletionFuture;
import org.kaazing.robot.driver.control.AbortMessage;
import org.kaazing.robot.driver.control.ErrorMessage;
import org.kaazing.robot.driver.control.FinishedMessage;
import org.kaazing.robot.driver.control.PrepareMessage;
import org.kaazing.robot.driver.control.PreparedMessage;
import org.kaazing.robot.driver.control.StartMessage;
import org.kaazing.robot.driver.control.StartedMessage;
import org.kaazing.robot.driver.control.handler.ControlUpstreamHandler;
import org.kaazing.robot.lang.parser.ScriptParseException;

public class ControlServerHandler
extends ControlUpstreamHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ControlServerHandler.class);
    private Robot robot;
    private RobotCompletionFuture scriptDoneFuture;
    private final ChannelFuture channelClosedFuture = Channels.future(null);

    public ChannelFuture getChannelClosedFuture() {
        return this.channelClosedFuture;
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        logger.debug("Control channel closed");
        if (this.robot != null) {
            this.robot.destroy();
        }
        this.channelClosedFuture.setSuccess();
        ctx.sendUpstream((ChannelEvent)e);
    }

    @Override
    public void prepareReceived(final ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        ChannelFuture prepareFuture;
        final PrepareMessage prepare = (PrepareMessage)evt.getMessage();
        if (logger.isDebugEnabled()) {
            logger.debug("preparing robot execution for script " + prepare.getScriptName());
        }
        this.robot = new Robot();
        try {
            prepareFuture = this.robot.prepare(prepare.getExpectedScript());
        }
        catch (Exception e) {
            this.sendErrorMessage(ctx, e, prepare.getScriptName());
            return;
        }
        prepareFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) {
                PreparedMessage prepared = new PreparedMessage();
                prepared.setCompatibilityKind(prepare.getCompatibilityKind());
                prepared.setScriptName(prepare.getScriptName());
                Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future(null), (Object)prepared);
            }
        });
    }

    @Override
    public void startReceived(final ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        boolean infoDebugEnabled = logger.isDebugEnabled();
        StartMessage start = (StartMessage)evt.getMessage();
        final String scriptName = start.getScriptName();
        if (infoDebugEnabled) {
            logger.debug("starting robot execution for script " + scriptName);
        }
        try {
            ChannelFuture startFuture = this.robot.start();
            startFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) {
                    StartedMessage started = new StartedMessage();
                    started.setScriptName(scriptName);
                    Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future(null), (Object)started);
                }
            });
        }
        catch (Exception e) {
            this.sendErrorMessage(ctx, e, scriptName);
            return;
        }
        this.scriptDoneFuture = this.robot.getScriptCompleteFuture();
        this.scriptDoneFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) {
                String expectedScript = ControlServerHandler.this.scriptDoneFuture.getExpectedScript();
                String observedScript = ControlServerHandler.this.scriptDoneFuture.getObservedScript();
                if (logger.isDebugEnabled()) {
                    logger.debug("Script " + scriptName + " completed");
                }
                FinishedMessage finished = new FinishedMessage();
                finished.setScriptName(scriptName);
                finished.setExpectedScript(expectedScript);
                finished.setObservedScript(observedScript);
                Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future(null), (Object)finished);
            }
        });
    }

    @Override
    public void abortReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
        AbortMessage abort = (AbortMessage)evt.getMessage();
        if (logger.isInfoEnabled()) {
            logger.debug("Aborting script " + abort.getScriptName());
        }
        this.robot.abort();
    }

    private void sendErrorMessage(ChannelHandlerContext ctx, Exception exception, String scriptName) {
        ErrorMessage error = new ErrorMessage();
        error.setDescription(exception.getMessage());
        error.setScriptName(scriptName);
        if (exception instanceof ScriptParseException) {
            if (logger.isDebugEnabled()) {
                logger.error("Caught exception trying to parse script. Sending error to client", (Throwable)exception);
            } else {
                logger.error("Caught exception trying to parse script. Sending error to client. Due to " + exception);
            }
            error.setSummary("Parse Error");
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future(null), (Object)error);
        } else {
            logger.error("Internal Error. Sending error to client", (Throwable)exception);
            error.setSummary("Internal Error");
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future(null), (Object)error);
        }
    }
}

