/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.control.handler;

import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.kaazing.robot.driver.control.ControlMessage;

public class ControlUpstreamHandler
extends SimpleChannelUpstreamHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(ControlUpstreamHandler.class);

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ControlMessage message = (ControlMessage)e.getMessage();
        switch (message.getKind()) {
            case PREPARE: {
                this.prepareReceived(ctx, e);
                break;
            }
            case START: {
                this.startReceived(ctx, e);
                break;
            }
            case ABORT: {
                this.abortReceived(ctx, e);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unexpected control message: %s", new Object[]{message.getKind()}));
            }
        }
    }

    public void prepareReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void startReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void abortReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        String msg = "Control channel caught exception event: ";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(msg, e.getCause());
        } else {
            LOGGER.info(msg + e.getCause());
        }
    }
}

