/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.netty.bootstrap.channel;

import java.net.SocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.kaazing.robot.driver.netty.bootstrap.BootstrapFactory;
import org.kaazing.robot.driver.netty.bootstrap.ServerBootstrap;
import org.kaazing.robot.driver.netty.bootstrap.channel.AbstractChannelSink;
import org.kaazing.robot.driver.netty.bootstrap.channel.AbstractServerChannel;
import org.kaazing.robot.driver.netty.channel.ChannelAddress;

public abstract class AbstractServerChannelSink<T extends AbstractServerChannel<?>>
extends AbstractChannelSink {
    private final ChannelPipelineFactory pipelineFactory;
    private BootstrapFactory bootstrapFactory;

    protected AbstractServerChannelSink(ChannelPipelineFactory pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
    }

    public void setBootstrapFactory(BootstrapFactory bootstrapFactory) {
        this.bootstrapFactory = bootstrapFactory;
    }

    @Override
    protected void bindRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        AbstractServerChannel channel = (AbstractServerChannel)evt.getChannel();
        ChannelFuture future = evt.getFuture();
        ChannelAddress localAddress = (ChannelAddress)evt.getValue();
        ChannelAddress transportAddress = localAddress.getTransport();
        String transportName = transportAddress.getLocation().getScheme();
        ServerBootstrap bootstrap = this.bootstrapFactory.newServerBootstrap(transportName);
        bootstrap.setParentHandler(this.createParentHandler(channel));
        bootstrap.setPipelineFactory(this.pipelineFactory);
        bootstrap.setOption(String.format("%s.next-protocol", transportName), localAddress.getLocation().getScheme());
        try {
            Channel transport = bootstrap.bind(transportAddress);
            channel.setTransport(transport);
            channel.setLocalAddress(localAddress);
            channel.setBound();
            Channels.fireChannelBound((Channel)channel, (SocketAddress)localAddress);
            future.setSuccess();
        }
        catch (Exception e) {
            future.setFailure((Throwable)e);
        }
    }

    @Override
    protected void unbindRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        AbstractServerChannel channel = (AbstractServerChannel)evt.getChannel();
        ChannelFuture future = evt.getFuture();
        try {
            Channel transport = channel.getTransport();
            transport.unbind().awaitUninterruptibly();
            this.close(channel, future);
        }
        catch (Exception e) {
            future.setFailure((Throwable)e);
        }
    }

    @Override
    protected void closeRequested(ChannelPipeline pipeline, ChannelStateEvent evt) throws Exception {
        AbstractServerChannel channel = (AbstractServerChannel)evt.getChannel();
        ChannelFuture future = evt.getFuture();
        try {
            this.close(channel, future);
        }
        catch (Exception e) {
            future.setFailure((Throwable)e);
        }
    }

    protected abstract ChannelHandler createParentHandler(T var1);

    private void close(T channel, ChannelFuture future) throws Exception {
        Channel transport = ((AbstractServerChannel)((Object)channel)).getTransport();
        transport.close().awaitUninterruptibly();
        future.setSuccess();
    }
}

