/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.netty.bootstrap.tcp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import javax.annotation.Resource;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.kaazing.robot.driver.executor.ExecutorServiceFactory;
import org.kaazing.robot.driver.netty.bootstrap.ClientBootstrap;
import org.kaazing.robot.driver.netty.bootstrap.ServerBootstrap;
import org.kaazing.robot.driver.netty.bootstrap.spi.BootstrapFactorySpi;
import org.kaazing.robot.driver.netty.channel.ChannelAddress;
import org.kaazing.robot.driver.netty.channel.socket.nio.ShareableClientBossPool;
import org.kaazing.robot.driver.netty.channel.socket.nio.ShareableServerBossPool;
import org.kaazing.robot.driver.netty.channel.socket.nio.ShareableWorkerPool;

public class TcpBootstrapFactorySpi
extends BootstrapFactorySpi {
    private ExecutorServiceFactory executorServiceFactory;

    @Resource
    public void setExecutorServiceFactory(ExecutorServiceFactory executorServiceFactory) {
        this.executorServiceFactory = executorServiceFactory;
    }

    @Override
    public String getTransportName() {
        return "tcp";
    }

    @Override
    public synchronized ClientBootstrap newClientBootstrap() throws Exception {
        ShareableWorkerPool workerPool = ShareableWorkerPool.getInstance(this.executorServiceFactory);
        ShareableClientBossPool bossPool = ShareableClientBossPool.getInstance(this.executorServiceFactory);
        NioClientSocketChannelFactory clientSocketFactory = new NioClientSocketChannelFactory((BossPool)bossPool, (WorkerPool)workerPool);
        return new ClientBootstrap((ChannelFactory)clientSocketFactory){

            public ChannelFuture connect(SocketAddress localAddress, SocketAddress remoteAddress) {
                InetSocketAddress localChannelAddress = TcpBootstrapFactorySpi.toInetSocketAddress((ChannelAddress)localAddress);
                InetSocketAddress remoteChannelAddress = TcpBootstrapFactorySpi.toInetSocketAddress((ChannelAddress)remoteAddress);
                return super.connect((SocketAddress)localChannelAddress, (SocketAddress)remoteChannelAddress);
            }
        };
    }

    @Override
    public synchronized ServerBootstrap newServerBootstrap() throws Exception {
        ShareableWorkerPool workerPool = ShareableWorkerPool.getInstance(this.executorServiceFactory);
        ShareableServerBossPool bossPool = ShareableServerBossPool.getInstance(this.executorServiceFactory);
        NioServerSocketChannelFactory serverSocketFactory = new NioServerSocketChannelFactory((BossPool)bossPool, (WorkerPool)workerPool);
        return new ServerBootstrap((ChannelFactory)serverSocketFactory){

            public Channel bind(SocketAddress localAddress) {
                return super.bind(TcpBootstrapFactorySpi.localAddressTransformation(localAddress));
            }

            public ChannelFuture bindAsync(SocketAddress localAddress) {
                return super.bindAsync(TcpBootstrapFactorySpi.localAddressTransformation(localAddress));
            }
        };
    }

    private static SocketAddress localAddressTransformation(SocketAddress localAddress) {
        if (localAddress instanceof ChannelAddress) {
            return TcpBootstrapFactorySpi.toInetSocketAddress((ChannelAddress)localAddress);
        }
        return localAddress;
    }

    private static InetSocketAddress toInetSocketAddress(ChannelAddress channelAddress) {
        if (channelAddress == null) {
            return null;
        }
        URI location = channelAddress.getLocation();
        String hostname = location.getHost();
        int port = location.getPort();
        return new InetSocketAddress(hostname, port);
    }
}

