/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.netty.channel;

import java.net.SocketAddress;
import java.net.URI;
import org.jboss.netty.channel.ChannelException;

public class ChannelAddress
extends SocketAddress {
    private static final long serialVersionUID = 1L;
    private final URI location;
    private final boolean secure;
    private final boolean ephemeral;
    private final ChannelAddress transport;

    public ChannelAddress(URI location) {
        this(location, false, null);
    }

    public ChannelAddress(URI location, boolean secure) {
        this(location, secure, null);
    }

    public ChannelAddress(URI location, ChannelAddress transport) {
        this(location, false, transport);
    }

    public ChannelAddress(URI location, boolean secure, ChannelAddress transport) {
        this(location, secure, transport, false);
    }

    private ChannelAddress(URI location, boolean secure, ChannelAddress transport, boolean ephemeral) {
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.location = location;
        this.secure = secure;
        this.transport = transport;
        this.ephemeral = ephemeral;
    }

    public URI getLocation() {
        return this.location;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public ChannelAddress getTransport() {
        return this.transport;
    }

    public ChannelAddress newEphemeralAddress() {
        if (this.ephemeral) {
            throw new ChannelException("Channel address is already ephemeral");
        }
        return new ChannelAddress(this.location, this.secure, this.transport, true);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ChannelAddress)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        ChannelAddress that = (ChannelAddress)o;
        if (this.ephemeral ^ that.ephemeral) {
            return false;
        }
        return this.location.equals(that.location) && this.secure == that.secure && (this.transport == null && that.transport == null || this.transport != null && this.transport.equals(that.transport));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.location);
        if (this.transport != null) {
            sb.append(" @ ").append(this.transport);
        }
        return sb.toString();
    }
}

