/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.netty.channel;

import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelFutureProgressListener;

public final class ChannelFutureListeners {
    private ChannelFutureListeners() {
    }

    public static ChannelFutureListener chainedFuture(ChannelFuture future) {
        return new ChannelFutureListenerDecorator(future);
    }

    public static ChannelFutureProgressListener chainedFutureWithProgress(ChannelFuture future) {
        return new ChannelFutureProgressListenerDecorator(future);
    }

    private static final class ChannelFutureProgressListenerDecorator
    extends ChannelFutureListenerDecorator
    implements ChannelFutureProgressListener {
        private ChannelFutureProgressListenerDecorator(ChannelFuture future) {
            super(future);
        }

        public void operationProgressed(ChannelFuture f, long amount, long current, long total) throws Exception {
            this.future.setProgress(amount, current, total);
        }
    }

    private static class ChannelFutureListenerDecorator
    implements ChannelFutureListener {
        protected final ChannelFuture future;

        ChannelFutureListenerDecorator(ChannelFuture future) {
            this.future = future;
        }

        public void operationComplete(ChannelFuture f) throws Exception {
            if (f.isSuccess()) {
                this.future.setSuccess();
            } else {
                this.future.setFailure(f.getCause());
            }
        }
    }
}

