/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.netty.channel;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelFutureProgressListener;
import org.jboss.netty.channel.DefaultChannelFuture;

public class CompositeChannelFuture2<E extends ChannelFuture>
extends DefaultChannelFuture {
    private final NotifyingListener listener = new NotifyingListener();
    private final AtomicInteger unnotified = new AtomicInteger();
    private volatile boolean constructionFinished;

    public CompositeChannelFuture2(Channel channel, boolean cancellable, Iterable<E> kids) {
        super(channel, cancellable);
        for (ChannelFuture k : kids) {
            k.addListener((ChannelFutureListener)this.listener);
            this.unnotified.incrementAndGet();
        }
        this.constructionFinished = true;
        if (this.unnotified.get() == 0) {
            this.setSuccess();
        }
    }

    public CompositeChannelFuture2(Channel channel, Iterable<E> kids) {
        this(channel, false, kids);
    }

    public CompositeChannelFuture2(Channel channel, ChannelFuture kid) {
        super(channel, false);
        kid.addListener((ChannelFutureListener)this.listener);
        this.unnotified.incrementAndGet();
        this.constructionFinished = true;
        if (this.unnotified.get() == 0) {
            this.setSuccess();
        }
    }

    private class NotifyingListener
    implements ChannelFutureListener,
    ChannelFutureProgressListener {
        private NotifyingListener() {
        }

        public void operationProgressed(ChannelFuture future, long amount, long current, long total) throws Exception {
            if (CompositeChannelFuture2.this.constructionFinished) {
                CompositeChannelFuture2.this.setProgress(amount, current, total);
            }
        }

        public void operationComplete(ChannelFuture future) {
            if (CompositeChannelFuture2.this.unnotified.decrementAndGet() == 0 && CompositeChannelFuture2.this.constructionFinished) {
                if (future.isSuccess()) {
                    CompositeChannelFuture2.this.setSuccess();
                } else {
                    CompositeChannelFuture2.this.setFailure(future.getCause());
                }
            }
        }
    }
}

