/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.netty.channel.socket.nio;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.kaazing.robot.driver.executor.ExecutorServiceFactory;

public final class ShareableWorkerPool
implements WorkerPool<NioWorker> {
    private static final int NUMBER_WORKERS = 1;
    private static volatile ShareableWorkerPool instance;
    private static final ReentrantReadWriteLock rwl;
    private static final Lock readLock;
    private static final Lock writeLock;
    private final AtomicInteger referenceCount = new AtomicInteger();
    private final AtomicBoolean locked = new AtomicBoolean();
    private final org.jboss.netty.channel.socket.nio.ShareableWorkerPool<NioWorker> wrapped;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShareableWorkerPool getInstance(ExecutorServiceFactory executorServiceFactory) {
        writeLock.lock();
        try {
            if (instance == null) {
                ExecutorService executor = executorServiceFactory.newExecutorService("worker");
                org.jboss.netty.channel.socket.nio.ShareableWorkerPool wrapped = new org.jboss.netty.channel.socket.nio.ShareableWorkerPool((WorkerPool)new NioWorkerPool((Executor)executor, 1));
                instance = new ShareableWorkerPool((org.jboss.netty.channel.socket.nio.ShareableWorkerPool<NioWorker>)wrapped);
            }
            ShareableWorkerPool.instance.referenceCount.incrementAndGet();
        }
        finally {
            writeLock.unlock();
        }
        return instance;
    }

    public void rebuildSelectors() {
        this.wrapped.rebuildSelectors();
    }

    public NioWorker nextWorker() {
        return (NioWorker)this.wrapped.nextWorker();
    }

    public void shutdown() {
        readLock.lock();
        try {
            if (instance != null && this.referenceCount.decrementAndGet() < 1) {
                this.destroy();
            }
        }
        catch (RuntimeException e) {
            this.referenceCount.incrementAndGet();
            throw e;
        }
        finally {
            readLock.unlock();
        }
    }

    private ShareableWorkerPool(org.jboss.netty.channel.socket.nio.ShareableWorkerPool<NioWorker> wrapped) {
        this.wrapped = wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        if (this.locked.compareAndSet(false, true)) {
            try {
                this.wrapped.destroy();
                instance = null;
            }
            finally {
                this.locked.set(false);
            }
        } else {
            throw new IllegalStateException("Can not destroy worker pool more than once");
        }
    }

    static {
        rwl = new ReentrantReadWriteLock();
        readLock = rwl.readLock();
        writeLock = rwl.writeLock();
    }
}

