/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.netty.channel.spi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.annotation.Resource;
import org.jboss.netty.channel.ChannelException;
import org.kaazing.robot.driver.netty.channel.ChannelAddress;
import org.kaazing.robot.driver.netty.channel.ChannelAddressFactory;

public abstract class ChannelAddressFactorySpi {
    public abstract String getSchemeName();

    public final ChannelAddress newChannelAddress(URI location, Map<String, Object> options) {
        int newLocationPort;
        String locationSchemeName = location.getScheme();
        String schemeName = this.getSchemeName();
        if (locationSchemeName == null || !locationSchemeName.equals(schemeName)) {
            throw new ChannelException(String.format("Location scheme %s does not match expected scheme %s", location, schemeName));
        }
        int locationPort = location.getPort();
        if (locationPort == -1 && (newLocationPort = this.getSchemePort()) != -1) {
            try {
                String locationUserInfo = location.getUserInfo();
                String locationHost = location.getHost();
                String locationPath = location.getPath();
                String locationQuery = location.getQuery();
                String locationFragment = location.getFragment();
                location = new URI(locationSchemeName, locationUserInfo, locationHost, newLocationPort, locationPath, locationQuery, locationFragment);
            }
            catch (URISyntaxException e) {
                throw new ChannelException((Throwable)e);
            }
        }
        return this.newChannelAddress0(location, options);
    }

    protected ChannelAddress newChannelAddress0(URI location, Map<String, Object> options) {
        return new ChannelAddress(location);
    }

    protected int getSchemePort() {
        return -1;
    }

    public static abstract class Transportable
    extends ChannelAddressFactorySpi {
        private ChannelAddressFactory channelAddressFactory;

        @Resource
        public void setChannelAddressFactory(ChannelAddressFactory channelAddressFactory) {
            this.channelAddressFactory = channelAddressFactory;
        }

        @Override
        protected final ChannelAddress newChannelAddress0(URI location, Map<String, Object> options) {
            URI transportURI = (URI)options.get(String.format("%s.transport", this.getSchemeName()));
            if (transportURI == null) {
                transportURI = this.createTransportURI(location);
            }
            ChannelAddress transport = this.channelAddressFactory.newChannelAddress(transportURI, options);
            return this.newChannelAddress0(location, transport);
        }

        protected ChannelAddress newChannelAddress0(URI location, ChannelAddress transport) {
            return new ChannelAddress(location, transport);
        }

        protected abstract URI createTransportURI(URI var1);
    }
}

