/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.robot.driver.netty.channel.tcp;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Map;
import org.jboss.netty.channel.ChannelException;
import org.kaazing.robot.driver.netty.channel.ChannelAddress;
import org.kaazing.robot.driver.netty.channel.spi.ChannelAddressFactorySpi;

public class TcpChannelAddressFactorySpi
extends ChannelAddressFactorySpi {
    @Override
    public String getSchemeName() {
        return "tcp";
    }

    @Override
    protected ChannelAddress newChannelAddress0(URI location, Map<String, Object> options) {
        String host = location.getHost();
        int port = location.getPort();
        String path = location.getPath();
        if (host == null) {
            throw new ChannelException(String.format("%s host missing", this.getSchemeName()));
        }
        if (port == -1) {
            throw new ChannelException(String.format("%s port missing", this.getSchemeName()));
        }
        if (path != null && !path.isEmpty()) {
            throw new ChannelException(String.format("%s path \"%s\" unexpected", this.getSchemeName(), path));
        }
        return super.newChannelAddress0(location, options);
    }

    public static abstract class TcpTransportable
    extends ChannelAddressFactorySpi.Transportable {
        @Override
        protected URI createTransportURI(URI location) {
            try {
                InetAddress inetAddress = InetAddress.getByName(location.getHost());
                String ipAddress = inetAddress.getHostAddress();
                int port = location.getPort();
                return URI.create(String.format("tcp://%s:%d", ipAddress, port));
            }
            catch (UnknownHostException e) {
                throw new ChannelException((Throwable)e);
            }
        }
    }
}

