/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.specification.http.internal;

import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.kaazing.specification.http.internal.Base64;

public final class Functions {
    private static final Random RANDOM = new Random();

    @Function
    public static String loginBase64Encoder(String login) {
        byte[] bytes = login.getBytes();
        return Functions.bytesToString(Base64.encode(bytes));
    }

    @Function
    public static String append(String ... strings) {
        StringBuilder x = new StringBuilder();
        for (String s : strings) {
            x.append(s);
        }
        return x.toString();
    }

    private static String bytesToString(byte[] x) {
        String answer = "";
        for (byte aX : x) {
            answer = answer + (char)aX;
        }
        return answer;
    }

    @Function
    public static String randomInvalidVersion() {
        String randomVersion = null;
        Pattern validVersionPattern = Pattern.compile("HTTP/1\\.(\\d)+");
        Matcher validVersionMatcher = null;
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!@#$%^&*()_+-=`~[]\\{}|;':\",./<>?";
        do {
            StringBuilder result = new StringBuilder();
            int randomLength = RANDOM.nextInt(30) + 1;
            for (int i = 0; i < randomLength; ++i) {
                result.append(chars.charAt(RANDOM.nextInt(chars.length())));
            }
            randomVersion = result.toString();
            validVersionMatcher = validVersionPattern.matcher(randomVersion);
        } while (randomVersion.length() > 1 && validVersionMatcher.matches());
        return randomVersion;
    }

    @Function
    public static byte[] randomAscii(int length) {
        Random r = new Random();
        byte[] result = new byte[length];
        String alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!@#$%^&*()_+-=`~[]\\{}|;':\",./<>?";
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)alphabet.charAt(r.nextInt(alphabet.length()));
        }
        return result;
    }

    @Function
    public static byte[] randomBytesUTF8(int length) {
        byte[] bytes = new byte[length];
        Functions.randomBytesUTF8(bytes, 0, length);
        return bytes;
    }

    private static void randomBytesUTF8(byte[] bytes, int start, int end) {
        int offset = start;
        while (offset < end) {
            int remaining = end - offset;
            int width = Math.min(RANDOM.nextInt(4) + 1, remaining);
            offset = Functions.randomCharBytesUTF8(bytes, offset, width);
        }
    }

    private static int randomCharBytesUTF8(byte[] bytes, int offset, int width) {
        switch (width) {
            case 1: {
                bytes[offset++] = (byte)RANDOM.nextInt(128);
                break;
            }
            case 2: {
                bytes[offset++] = (byte)(0xC0 | RANDOM.nextInt(32) | 1 << RANDOM.nextInt(4) + 1);
                bytes[offset++] = (byte)(0x80 | RANDOM.nextInt(64));
                break;
            }
            case 3: {
                bytes[offset++] = (byte)(0xE0 | RANDOM.nextInt(8) | 1 << RANDOM.nextInt(3));
                bytes[offset++] = (byte)(0x80 | RANDOM.nextInt(64));
                bytes[offset++] = (byte)(0x80 | RANDOM.nextInt(64));
                break;
            }
            case 4: {
                bytes[offset++] = (byte)(0xF0 | RANDOM.nextInt(4) | 1 << RANDOM.nextInt(2));
                bytes[offset++] = (byte)(0x80 | RANDOM.nextInt(16));
                bytes[offset++] = (byte)(0x80 | RANDOM.nextInt(64));
                bytes[offset++] = (byte)(0x80 | RANDOM.nextInt(64));
            }
        }
        return offset;
    }

    private Functions() {
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(Functions.class);
        }

        public String getPrefixName() {
            return "http";
        }
    }
}

