/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.specification.http2.internal;

final class Base64URL {
    private static final byte[] INDEXED = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".getBytes();
    private static final byte PADDING_BYTE = 61;

    public static byte[] encode(byte[] decodedArray) {
        int byte1;
        int byte0;
        int decodedSize = decodedArray.length;
        int effectiveDecodedSize = (decodedSize + 2) / 3 * 3;
        int decodedFragmentSize = decodedSize % 3;
        int encodedArraySize = effectiveDecodedSize / 3 * 4;
        byte[] encodedArray = new byte[encodedArraySize];
        int encodedArrayPosition = 0;
        int decodedArrayOffset = 0;
        int decodedArrayPosition = decodedArrayOffset + 0;
        int decodedArrayLimit = decodedArrayOffset + decodedArray.length - decodedFragmentSize;
        while (decodedArrayPosition < decodedArrayLimit) {
            byte0 = decodedArray[decodedArrayPosition++] & 0xFF;
            byte1 = decodedArray[decodedArrayPosition++] & 0xFF;
            int byte2 = decodedArray[decodedArrayPosition++] & 0xFF;
            encodedArray[encodedArrayPosition++] = INDEXED[byte0 >> 2 & 0x3F];
            encodedArray[encodedArrayPosition++] = INDEXED[byte0 << 4 & 0x30 | byte1 >> 4 & 0xF];
            encodedArray[encodedArrayPosition++] = INDEXED[byte1 << 2 & 0x3C | byte2 >> 6 & 3];
            encodedArray[encodedArrayPosition++] = INDEXED[byte2 & 0x3F];
        }
        if (decodedFragmentSize == 1) {
            byte0 = decodedArray[decodedArrayPosition++] & 0xFF;
            encodedArray[encodedArrayPosition++] = INDEXED[byte0 >> 2 & 0x3F];
            encodedArray[encodedArrayPosition++] = INDEXED[byte0 << 4 & 0x30];
            encodedArray[encodedArrayPosition++] = 61;
            encodedArray[encodedArrayPosition++] = 61;
        } else if (decodedFragmentSize == 2) {
            byte0 = decodedArray[decodedArrayPosition++] & 0xFF;
            byte1 = decodedArray[decodedArrayPosition++] & 0xFF;
            encodedArray[encodedArrayPosition++] = INDEXED[byte0 >> 2 & 0x3F];
            encodedArray[encodedArrayPosition++] = INDEXED[byte0 << 4 & 0x30 | byte1 >> 4 & 0xF];
            encodedArray[encodedArrayPosition++] = INDEXED[byte1 << 2 & 0x3C];
            encodedArray[encodedArrayPosition++] = 61;
        }
        return encodedArray;
    }

    public static byte[] decode(byte[] encodedArray) {
        if (encodedArray == null) {
            return null;
        }
        int length = encodedArray.length;
        if (length % 4 != 0) {
            throw new IllegalArgumentException("Invalid Base64URL Encoded String");
        }
        byte[] decodedArray = new byte[length / 4 * 3];
        int decodedArrayOffset = 0;
        int i = 0;
        while (i < length) {
            byte char0 = encodedArray[i++];
            byte char1 = encodedArray[i++];
            byte char2 = encodedArray[i++];
            byte char3 = encodedArray[i++];
            int byte0 = Base64URL.mapped(char0);
            int byte1 = Base64URL.mapped(char1);
            int byte2 = Base64URL.mapped(char2);
            int byte3 = Base64URL.mapped(char3);
            decodedArray[decodedArrayOffset++] = (byte)(byte0 << 2 & 0xFC | byte1 >> 4 & 3);
            if (char2 == 61) continue;
            decodedArray[decodedArrayOffset++] = (byte)(byte1 << 4 & 0xF0 | byte2 >> 2 & 0xF);
            if (char3 == 61) continue;
            decodedArray[decodedArrayOffset++] = (byte)(byte2 << 6 & 0xC0 | byte3 & 0x3F);
        }
        assert (decodedArrayOffset == decodedArray.length);
        return decodedArray;
    }

    private static int mapped(int ch) {
        if ((ch & 0x40) != 0) {
            if ((ch & 0x20) != 0) {
                assert (ch >= 97);
                assert (ch <= 122);
                return ch - 71;
            }
            assert (ch >= 65);
            assert (ch <= 90);
            return ch - 65;
        }
        if ((ch & 0x20) != 0) {
            if ((ch & 0x10) != 0) {
                if ((ch & 8) != 0 && (ch & 4) != 0) {
                    assert (ch == 61);
                    return 0;
                }
                assert (ch >= 48);
                assert (ch <= 57);
                return ch + 4;
            }
            if ((ch & 4) != 0) {
                assert (ch == 45);
                return 63;
            }
            assert (ch == 95);
            return 62;
        }
        throw new IllegalArgumentException("Invalid BASE64 string");
    }

    private Base64URL() {
    }
}

