/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.specification.wse.internal;

import java.util.ArrayList;
import java.util.Random;
import org.kaazing.k3po.lang.el.Function;
import org.kaazing.k3po.lang.el.spi.FunctionMapperSpi;
import org.kaazing.specification.wse.internal.Base64;
import org.kaazing.specification.wse.internal.Encoding;

public final class Functions {
    private static final Random RANDOM = new Random();
    private static final byte[] allBytes = new byte[256];
    private static final Byte BYTE_7F = new Byte(127);

    @Function
    public static byte[] uniqueId() {
        byte[] bytes = new byte[16];
        RANDOM.nextBytes(bytes);
        return Base64.encode(bytes);
    }

    @Function
    public static byte[] allBytes() {
        byte[] bytes = new byte[256];
        for (int i = 0; i < 256; ++i) {
            bytes[i] = (byte)i;
        }
        return bytes;
    }

    @Function
    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)RANDOM.nextInt(256);
        }
        return bytes;
    }

    @Function
    public static byte[] randomBytesIncludingNumberOfEscapedBytes(int length, int numberOfEscapedBytesToInclude) {
        byte[] bytes = new byte[length];
        byte[] escapedBytes = new byte[]{0, 13, 10, 127};
        block3: for (int i = 0; i < length; ++i) {
            if ((length - i) / 2 < numberOfEscapedBytesToInclude) {
                bytes[i] = escapedBytes[RANDOM.nextInt(escapedBytes.length)];
                --numberOfEscapedBytesToInclude;
                continue;
            }
            byte randomByte = (byte)RANDOM.nextInt(100);
            switch (randomByte) {
                case 0: 
                case 10: 
                case 13: 
                case 127: {
                    if (numberOfEscapedBytesToInclude > 0) {
                        bytes[i] = randomByte;
                        --numberOfEscapedBytesToInclude;
                        continue block3;
                    }
                    --i;
                    continue block3;
                }
                default: {
                    bytes[i] = randomByte;
                }
            }
        }
        return bytes;
    }

    @Function
    public static byte[] convertEscapedUtf8BytesToEscapedWindows1252(byte[] in) {
        byte[] out = new byte[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i] == 0 ? 48 : in[i];
        }
        return out;
    }

    @Function
    public static byte[] decodeUtf8Bytes(byte[] bytes) {
        return Encoding.UTF8.decode(bytes);
    }

    @Function
    public static byte[] encodeBytesAsUtf8(byte[] bytes) {
        return Encoding.UTF8.encode(bytes);
    }

    @Function
    public static byte[] escapeBytesForUtf8(byte[] bytes) {
        int i;
        ArrayList<Byte> listOfEscapedBytes = new ArrayList<Byte>();
        block6: for (i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            switch (b) {
                case 0: {
                    listOfEscapedBytes.add(BYTE_7F);
                    listOfEscapedBytes.add(new Byte(0));
                    continue block6;
                }
                case 10: {
                    listOfEscapedBytes.add(BYTE_7F);
                    listOfEscapedBytes.add(new Byte(110));
                    continue block6;
                }
                case 13: {
                    listOfEscapedBytes.add(BYTE_7F);
                    listOfEscapedBytes.add(new Byte(114));
                    continue block6;
                }
                case 127: {
                    listOfEscapedBytes.add(BYTE_7F);
                    listOfEscapedBytes.add(BYTE_7F);
                    continue block6;
                }
                default: {
                    listOfEscapedBytes.add(new Byte(b));
                }
            }
        }
        bytes = new byte[listOfEscapedBytes.size()];
        for (i = 0; i < listOfEscapedBytes.size(); ++i) {
            bytes[i] = (Byte)listOfEscapedBytes.get(i);
        }
        return bytes;
    }

    @Function
    public static byte[] escapeBytesForWindows1252(byte[] bytes) {
        int i;
        ArrayList<Byte> listOfEscapedBytes = new ArrayList<Byte>();
        block6: for (i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            switch (b) {
                case 0: {
                    listOfEscapedBytes.add(BYTE_7F);
                    listOfEscapedBytes.add(new Byte(48));
                    continue block6;
                }
                case 10: {
                    listOfEscapedBytes.add(BYTE_7F);
                    listOfEscapedBytes.add(new Byte(110));
                    continue block6;
                }
                case 13: {
                    listOfEscapedBytes.add(BYTE_7F);
                    listOfEscapedBytes.add(new Byte(114));
                    continue block6;
                }
                case 127: {
                    listOfEscapedBytes.add(BYTE_7F);
                    listOfEscapedBytes.add(BYTE_7F);
                    continue block6;
                }
                default: {
                    listOfEscapedBytes.add(new Byte(b));
                }
            }
        }
        bytes = new byte[listOfEscapedBytes.size()];
        for (i = 0; i < listOfEscapedBytes.size(); ++i) {
            bytes[i] = (Byte)listOfEscapedBytes.get(i);
        }
        return bytes;
    }

    @Function
    public static byte[] padding(int size) {
        if ((size & 1) != 0) {
            ++size;
        }
        byte[] padding = new byte[size + 2];
        padding[0] = 1;
        for (int i = 1; i < padding.length - 2; i += 2) {
            padding[i] = 48;
            padding[i + 1] = 48;
        }
        padding[padding.length - 1] = -1;
        return padding;
    }

    @Function
    public static int randomInt(int upperBound) {
        return RANDOM.nextInt(upperBound);
    }

    @Function
    public static String asString(int value) {
        return Integer.toString(value);
    }

    @Function
    public static String append(String ... strings) {
        StringBuilder result = new StringBuilder();
        for (String string : strings) {
            result.append(string);
        }
        return result.toString();
    }

    private Functions() {
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Functions.allBytes[i] = (byte)i;
        }
    }

    public static class Mapper
    extends FunctionMapperSpi.Reflective {
        public Mapper() {
            super(Functions.class);
        }

        public String getPrefixName() {
            return "wse";
        }
    }
}

