/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.specification.wse.internal;

public enum Encoding {
    UTF8{

        @Override
        public byte[] encode(byte[] decoded) {
            return Encoding.encodeBinaryAsText(decoded);
        }

        @Override
        public byte[] decode(byte[] encoded) {
            return Encoding.decodeTextAsBinary(encoded);
        }
    };


    public abstract byte[] encode(byte[] var1);

    public abstract byte[] decode(byte[] var1);

    private static byte[] encodeBinaryAsText(byte[] decodedArray) {
        byte[] encodedArray = decodedArray;
        int candidateEncodedArrayLength = decodedArray.length;
        int encodedDataLength = 0;
        for (int decodedArrayPosition = 0; decodedArrayPosition < decodedArray.length; ++decodedArrayPosition) {
            byte decodedValue = decodedArray[decodedArrayPosition];
            if ((decodedValue & 0x80) != 0) {
                byte[] tempArray = new byte[++candidateEncodedArrayLength];
                System.arraycopy(encodedArray, 0, tempArray, 0, encodedDataLength);
                byte encodedByte0 = (byte)((decodedValue & 0xFF) >> 6 & 3 | 0xC0);
                byte encodedByte1 = (byte)(decodedValue & 0xBF);
                tempArray[encodedDataLength++] = encodedByte0;
                tempArray[encodedDataLength++] = encodedByte1;
                encodedArray = tempArray;
                continue;
            }
            if (encodedArray == null) continue;
            encodedArray[encodedDataLength++] = decodedValue;
        }
        return encodedArray;
    }

    private static byte[] decodeTextAsBinary(byte[] encodedArray) {
        byte[] decodedArray;
        byte[] candidateDecodedArray = new byte[encodedArray.length];
        int decodedDataLength = 0;
        for (int encodedArrayPosition = 0; encodedArrayPosition < encodedArray.length; ++encodedArrayPosition) {
            byte encodedByte1 = encodedArray[encodedArrayPosition];
            if ((encodedByte1 & 0x80) != 0) {
                byte encodedByte2 = encodedArray[++encodedArrayPosition];
                byte decodedByte = (byte)(encodedByte1 << 6 | encodedByte2 & 0x3F);
                candidateDecodedArray[decodedDataLength++] = decodedByte;
                continue;
            }
            candidateDecodedArray[decodedDataLength++] = encodedByte1;
        }
        if (decodedDataLength == encodedArray.length) {
            decodedArray = candidateDecodedArray;
        } else {
            decodedArray = new byte[decodedDataLength];
            System.arraycopy(candidateDecodedArray, 0, decodedArray, 0, decodedDataLength);
        }
        return decodedArray;
    }
}

