/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket.cdi.event;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Qualifier;
import org.kasource.web.websocket.cdi.event.AnnotationWebsocketBinding;

public class CdiWebSocketMapping
implements AnnotationWebsocketBinding {
    private final Map<String, Annotation> mapping;

    public CdiWebSocketMapping() {
        this.mapping = new HashMap<String, Annotation>();
    }

    private CdiWebSocketMapping(Builder builder) {
        this.mapping = builder.mapping;
    }

    @Override
    public Annotation getAnnotationForSocket(String socketName) {
        return this.mapping.get(socketName);
    }

    public static class Builder {
        private Map<String, Annotation> mapping = new HashMap<String, Annotation>();

        public Builder map(String socketName, Class<? extends Annotation> annotationClass) {
            if (annotationClass.isAnnotationPresent(Qualifier.class)) {
                this.mapping.put(socketName, this.getAnnotation(annotationClass));
                return this;
            }
            throw new IllegalArgumentException(annotationClass + " must be annotated with @" + Qualifier.class);
        }

        private <T extends Annotation> T getAnnotation(final Class<T> annoClass) {
            return (T)new AnnotationLiteral<T>(){

                public Class<? extends Annotation> annotationType() {
                    return annoClass;
                }
            };
        }

        public CdiWebSocketMapping build() {
            return new CdiWebSocketMapping(this);
        }
    }
}

