/*
 * Decompiled with CFR 0.152.
 */
package org.kasource.web.websocket.cdi.event;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.ejb.Startup;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.kasource.web.websocket.cdi.event.AnnotationWebsocketBinding;
import org.kasource.web.websocket.cdi.event.Configured;
import org.kasource.web.websocket.channel.WebSocketChannel;
import org.kasource.web.websocket.event.WebSocketBinaryMessageEvent;
import org.kasource.web.websocket.event.WebSocketClientConnectionEvent;
import org.kasource.web.websocket.event.WebSocketClientDisconnectedEvent;
import org.kasource.web.websocket.event.WebSocketEvent;
import org.kasource.web.websocket.event.WebSocketTextMessageEvent;
import org.kasource.web.websocket.event.extension.BroadcastObjectAsWebSocketBinaryMessageEvent;
import org.kasource.web.websocket.event.extension.BroadcastObjectAsWebSocketTextMessageEvent;
import org.kasource.web.websocket.event.extension.BroadcastWebSocketBinaryMessageEvent;
import org.kasource.web.websocket.event.extension.BroadcastWebSocketTextMessageEvent;
import org.kasource.web.websocket.event.extension.SendObjectAsWebSocketBinaryMessageEvent;
import org.kasource.web.websocket.event.extension.SendObjectAsWebSocketTextMessageEvent;
import org.kasource.web.websocket.event.extension.SendWebSocketBinaryMessageEvent;
import org.kasource.web.websocket.event.extension.SendWebSocketTextMessageEvent;
import org.kasource.web.websocket.listener.WebSocketEventListener;
import org.kasource.web.websocket.register.WebSocketListenerRegisterImpl;
import org.kasource.web.websocket.register.WebSocketListenerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Startup
@ApplicationScoped
public class EventBridge
implements WebSocketEventListener,
WebSocketListenerRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(EventBridge.class);
    @Inject
    @Any
    private Event<WebSocketEvent> socketEvent;
    @Inject
    @Configured
    private AnnotationWebsocketBinding mapping;

    public void onServletContextInitialized(@Observes ServletContext servletContext) {
        WebSocketListenerRegisterImpl listenerRegister = new WebSocketListenerRegisterImpl(servletContext);
        listenerRegister.registerListener((Object)this);
    }

    public void onSendTextMessage(@Observes SendWebSocketTextMessageEvent event) {
        WebSocketChannel webSocket = event.getSource();
        try {
            webSocket.sendMessage(event.getMessage(), event.getRecipient(), event.getRecipientType());
        }
        catch (Exception e) {
            LOG.warn("Could not send message: " + event.getMessage() + " to " + event.getRecipientType() + ": " + event.getRecipient());
        }
    }

    public void onSendTextMessage(@Observes SendObjectAsWebSocketTextMessageEvent event) {
        WebSocketChannel webSocket = event.getSource();
        try {
            webSocket.sendMessage(event.getMessage(), event.getProtocolHandler(), event.getRecipient(), event.getRecipientType());
        }
        catch (Exception e) {
            LOG.warn("Could not send message: " + event.getMessage() + " to " + event.getRecipientType() + ": " + event.getRecipient());
        }
    }

    public void onSendBinaryMessage(@Observes SendWebSocketBinaryMessageEvent event) {
        WebSocketChannel webSocket = event.getSource();
        try {
            webSocket.sendBinaryMessage(event.getMessage(), event.getRecipient(), event.getRecipientType());
        }
        catch (Exception e) {
            LOG.warn("Could not send message: " + event.getMessage() + " to " + event.getRecipientType() + ": " + event.getRecipient());
        }
    }

    public void onSendBinaryProtocolMessage(@Observes SendObjectAsWebSocketBinaryMessageEvent event) throws IOException {
        WebSocketChannel webSocket = event.getSource();
        try {
            webSocket.sendBinaryMessage(event.getMessage(), event.getProtocolHandler(), event.getRecipient(), event.getRecipientType());
        }
        catch (Exception e) {
            LOG.warn("Could not send message: " + event.getMessage() + " to " + event.getRecipientType() + ": " + event.getRecipient());
        }
    }

    public void onBroadcastTextMessage(@Observes BroadcastWebSocketTextMessageEvent event) {
        WebSocketChannel webSocket = event.getSource();
        webSocket.broadcast(event.getMessage());
    }

    public void onBroadcastTextProtocolMessage(@Observes BroadcastObjectAsWebSocketTextMessageEvent event) {
        WebSocketChannel webSocket = event.getSource();
        webSocket.broadcastObject(event.getMessage(), event.getProtocolHandler());
    }

    public void onBroadcastBinaryMessage(@Observes BroadcastWebSocketBinaryMessageEvent event) {
        WebSocketChannel webSocket = event.getSource();
        webSocket.broadcastBinary(event.getMessage());
    }

    public void onBroadcastBinaryProtocolMessage(@Observes BroadcastObjectAsWebSocketBinaryMessageEvent event) {
        WebSocketChannel webSocket = event.getSource();
        webSocket.broadcastBinaryObject(event.getMessage(), event.getProtocolHandler());
    }

    public void onWebSocketEvent(WebSocketEvent event) {
        Annotation annotation = this.mapping.getAnnotationForSocket(event.getSource().getUrl());
        if (event instanceof WebSocketTextMessageEvent) {
            if (annotation == null) {
                this.socketEvent.select(WebSocketTextMessageEvent.class, new Annotation[0]).fire((Object)((WebSocketTextMessageEvent)event));
            } else {
                this.socketEvent.select(WebSocketTextMessageEvent.class, new Annotation[]{annotation}).fire((Object)((WebSocketTextMessageEvent)event));
            }
        } else if (event instanceof WebSocketBinaryMessageEvent) {
            if (annotation == null) {
                this.socketEvent.select(WebSocketBinaryMessageEvent.class, new Annotation[0]).fire((Object)((WebSocketBinaryMessageEvent)event));
            } else {
                this.socketEvent.select(WebSocketBinaryMessageEvent.class, new Annotation[]{annotation}).fire((Object)((WebSocketBinaryMessageEvent)event));
            }
        } else if (event instanceof WebSocketClientConnectionEvent) {
            if (annotation == null) {
                this.socketEvent.select(WebSocketClientConnectionEvent.class, new Annotation[0]).fire((Object)((WebSocketClientConnectionEvent)event));
            } else {
                this.socketEvent.select(WebSocketClientConnectionEvent.class, new Annotation[]{annotation}).fire((Object)((WebSocketClientConnectionEvent)event));
            }
        } else if (event instanceof WebSocketClientDisconnectedEvent) {
            if (annotation == null) {
                this.socketEvent.select(WebSocketClientDisconnectedEvent.class, new Annotation[0]).fire((Object)((WebSocketClientDisconnectedEvent)event));
            } else {
                this.socketEvent.select(WebSocketClientDisconnectedEvent.class, new Annotation[]{annotation}).fire((Object)((WebSocketClientDisconnectedEvent)event));
            }
        } else if (annotation == null) {
            this.socketEvent.fire((Object)event);
        } else {
            this.socketEvent.select(new Annotation[]{annotation}).fire((Object)event);
        }
    }

    public String getWebSocketChannelName() {
        return "*";
    }
}

