/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KModel;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.meta.KMeta;
import org.kevoree.modeling.meta.KMetaClass;
import org.kevoree.modeling.meta.KPrimitiveTypes;
import org.kevoree.modeling.meta.impl.MetaModel;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public class CompareTest {
    @Test
    public void test() {
        MetaModel metaModel = new MetaModel("MyMetaModel");
        final KMetaClass sensorMetaClass = metaModel.addMetaClass("Sensor");
        sensorMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        sensorMetaClass.addAttribute("value", KPrimitiveTypes.DOUBLE);
        sensorMetaClass.addRelation("siblings", sensorMetaClass, null);
        final KModel universe = metaModel.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect((KCallback)new KCallback<Throwable>(){

            public void on(Throwable throwable) {
                KObject sensor = universe.universe(0L).time(0L).create(sensorMetaClass);
                sensor.setByName("name", (Object)"Name1");
                KObject sensor2 = universe.universe(0L).time(0L).create(sensorMetaClass);
                sensor2.setByName("name", (Object)"Name1");
                KMeta[] emptyResult = sensor.compare(sensor2);
                Assert.assertEquals((long)emptyResult.length, (long)0L);
                KObject sensor3 = universe.universe(0L).time(0L).create(sensorMetaClass);
                sensor3.setByName("name", (Object)"Name3");
                KMeta[] diffOne = sensor.compare(sensor3);
                Assert.assertEquals((long)diffOne.length, (long)1L);
                sensor3.setByName("name", (Object)"Name3");
                sensor3.setByName("value", (Object)3.0);
                KMeta[] diffTwo = sensor.compare(sensor3);
                Assert.assertEquals((long)diffTwo.length, (long)2L);
            }
        });
    }
}

