/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KModelContext;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.cloudmodel.CloudModel;
import org.kevoree.modeling.cloudmodel.CloudUniverse;
import org.kevoree.modeling.cloudmodel.CloudView;
import org.kevoree.modeling.cloudmodel.Element;
import org.kevoree.modeling.cloudmodel.Node;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;
import org.kevoree.modeling.traversal.visitor.KModelVisitor;
import org.kevoree.modeling.traversal.visitor.KVisitResult;

public class HelloTest {
    @Test
    public void badLookupTest() {
        final CloudModel model = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect((KCallback)new KCallback<Throwable>(){

            public void on(Throwable throwable) {
                if (throwable != null) {
                    throwable.printStackTrace();
                } else {
                    CloudUniverse universe = (CloudUniverse)model.newUniverse();
                    CloudView time0 = (CloudView)universe.time(0L);
                    Node root = time0.createNode();
                    root.setName("root");
                    Assert.assertEquals((Object)"root", (Object)root.getName());
                    Node n1 = time0.createNode();
                    n1.setName("n1");
                    Node n2 = time0.createNode();
                    n2.setName("n2");
                    root.addChildren(n1);
                    root.addChildren(n2);
                    time0.lookup(42L, (KCallback)new KCallback<KObject>(){

                        public void on(KObject kObject) {
                            Assert.assertNull((Object)kObject);
                        }
                    });
                }
            }
        });
    }

    @Test
    public void simpleTest() {
        final CloudModel model = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect((KCallback)new KCallback<Throwable>(){

            public void on(Throwable throwable) {
                if (throwable != null) {
                    throwable.printStackTrace();
                } else {
                    CloudUniverse universe = (CloudUniverse)model.newUniverse();
                    CloudView time0 = (CloudView)universe.time(0L);
                    final Node root = time0.createNode();
                    root.setName("root");
                    Assert.assertEquals((Object)"root", (Object)root.getName());
                    Node n1 = time0.createNode();
                    n1.setName("n1");
                    Node n2 = time0.createNode();
                    n2.setName("n2");
                    root.addChildren(n1);
                    root.addChildren(n2);
                    time0.lookup(root.uuid(), (KCallback)new KCallback<KObject>(){

                        public void on(KObject kObject) {
                            Assert.assertNotNull((Object)kObject);
                            Assert.assertEquals((Object)kObject, (Object)root);
                        }
                    });
                }
            }
        });
    }

    @Test
    public void helloTest() {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                Assert.assertNotNull((Object)((Object)dimension0));
                CloudView t0 = (CloudView)dimension0.time(0L);
                Assert.assertNotNull((Object)t0);
                Assert.assertEquals((long)t0.now(), (long)0L);
                Node nodeT0 = t0.createNode();
                Assert.assertNotNull((Object)nodeT0);
                Assert.assertNotNull((Object)nodeT0.uuid());
                Assert.assertNull((Object)nodeT0.getName());
                nodeT0.setName("node0");
                Assert.assertEquals((Object)"node0", (Object)nodeT0.getName());
                Assert.assertEquals((long)0L, (long)nodeT0.now());
                Element child0 = t0.createElement();
                Node nodeT1 = t0.createNode();
                nodeT1.setName("n1");
                nodeT0.addChildren(nodeT1);
                final int[] i = new int[]{0};
                final int[] j = new int[]{0};
                nodeT0.getChildren(new KCallback<Node[]>(){

                    public void on(Node[] n) {
                        for (int k = 0; k < n.length; ++k) {
                            i[0] = i[0] + 1;
                        }
                    }
                });
                Node nodeT3 = t0.createNode();
                nodeT3.setName("n3");
                nodeT1.addChildren(nodeT3);
                i[0] = 0;
                j[0] = 0;
                nodeT0.visit(new KModelVisitor(){

                    public KVisitResult visit(KObject elem) {
                        i[0] = i[0] + 1;
                        return KVisitResult.CONTINUE;
                    }
                }, (KCallback)new KCallback<Throwable>(){

                    public void on(Throwable t) {
                        j[0] = j[0] + 1;
                    }
                });
                Assert.assertEquals((Object)"{\"universe\":1,\"time\":0,\"uuid\":1,\"data\":{\"name\":\"node0\",\"children\":[4]}}", (Object)nodeT0.toJSON());
                Assert.assertEquals((Object)"{\"universe\":1,\"time\":0,\"uuid\":1,\"data\":{\"name\":\"node0\",\"children\":[4]}}", (Object)nodeT0.toString());
            }
        });
    }

    @Test
    public void contextTest() {
        final CloudModel model = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect((KCallback)new KCallback<Throwable>(){

            public void on(Throwable throwable) {
                if (throwable != null) {
                    throwable.printStackTrace();
                } else {
                    CloudUniverse universe = (CloudUniverse)model.newUniverse();
                    CloudView time0 = (CloudView)universe.time(0L);
                    Node root = time0.createNode();
                    root.setName("root");
                    Assert.assertEquals((Object)"root", (Object)root.getName());
                    Node n1 = time0.createNode();
                    n1.setName("n1");
                    Node n2 = time0.createNode();
                    n2.setName("n2");
                    root.addChildren(n1);
                    root.addChildren(n2);
                    final int[] counter = new int[]{0};
                    KModelContext context = model.createModelContext();
                    context.listen((KCallback)new KCallback<long[]>(){

                        public void on(long[] o) {
                            counter[0] = counter[0] + 1;
                        }
                    });
                    context.set(0L, 0L, 0L, 0L);
                    Assert.assertEquals((long)counter[0], (long)1L);
                }
            }
        });
    }
}

