/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.KObjectIndex;
import org.kevoree.modeling.cloudmodel.CloudModel;
import org.kevoree.modeling.cloudmodel.CloudUniverse;
import org.kevoree.modeling.cloudmodel.CloudView;
import org.kevoree.modeling.cloudmodel.Node;
import org.kevoree.modeling.cloudmodel.meta.MetaNode;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.meta.KMetaClass;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public class IndexTest {
    @Test
    public void test() {
        final CloudModel model = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect((KCallback)new KCallback<Throwable>(){

            public void on(Throwable throwable) {
                if (throwable != null) {
                    throwable.printStackTrace();
                } else {
                    model.indexByName(0L, 0L, "root", (KCallback)new KCallback<KObjectIndex>(){

                        public void on(final KObjectIndex index) {
                            long empty = index.getIndex("root");
                            Assert.assertEquals((long)empty, (long)0x1FFFFFFFFFFFFFL);
                            index.setIndex("root", 42L);
                            long nonEmpty = index.getIndex("root");
                            Assert.assertEquals((long)nonEmpty, (long)42L);
                            model.lookup(0L, 0L, index.uuid(), (KCallback)new KCallback<KObject>(){

                                public void on(KObject kObject) {
                                    Assert.assertEquals((long)index.uuid(), (long)kObject.uuid());
                                }
                            });
                            model.indexByName(0L, 100L, "root", (KCallback)new KCallback<KObjectIndex>(){

                                public void on(KObjectIndex index2) {
                                    Assert.assertEquals((long)index2.getIndex("root"), (long)42L);
                                }
                            });
                            model.save(new KCallback(){

                                public void on(Object o) {
                                }
                            });
                        }
                    });
                    MetaNode.ATT_NAME.setKey(true);
                    final Node node0 = (Node)model.create((KMetaClass)MetaNode.getInstance(), 0L, 0L);
                    node0.setName("node0");
                    node0.setName("node0");
                    model.find((KMetaClass)MetaNode.getInstance(), 0L, 0L, "name=node0", (KCallback)new KCallback<KObject>(){

                        public void on(KObject resolvedObject) {
                            Assert.assertEquals((long)resolvedObject.uuid(), (long)node0.uuid());
                        }
                    });
                    model.find((KMetaClass)MetaNode.getInstance(), 0L, 10L, "name=node0", (KCallback)new KCallback<KObject>(){

                        public void on(KObject resolvedObject) {
                            Assert.assertEquals((long)resolvedObject.uuid(), (long)node0.uuid());
                        }
                    });
                    node0.jump(10L, (KCallback)new KCallback<KObject>(){

                        public void on(KObject t10elem) {
                            Node t10node0 = (Node)t10elem;
                            Assert.assertEquals((Object)t10node0.getName(), (Object)"node0");
                            t10node0.setName("n0");
                            Assert.assertEquals((Object)t10node0.getName(), (Object)"n0");
                            model.find((KMetaClass)MetaNode.getInstance(), 0L, 10L, "name=node0", (KCallback)new KCallback<KObject>(){

                                public void on(KObject resolvedObject) {
                                    Assert.assertEquals((Object)resolvedObject, null);
                                }
                            });
                            model.find((KMetaClass)MetaNode.getInstance(), 0L, 10L, "name=n0", (KCallback)new KCallback<KObject>(){

                                public void on(KObject resolvedObject) {
                                    Assert.assertEquals((long)resolvedObject.uuid(), (long)node0.uuid());
                                }
                            });
                            model.find((KMetaClass)MetaNode.getInstance(), 0L, 5L, "name=node0", (KCallback)new KCallback<KObject>(){

                                public void on(KObject resolvedObject) {
                                    Assert.assertEquals((long)resolvedObject.uuid(), (long)node0.uuid());
                                }
                            });
                            ((CloudView)((CloudUniverse)model.universe(0L)).time(10L)).select("@org.kevoree.modeling.microframework.test.cloud.Node[name=n0]", (KCallback)new KCallback<Object[]>(){

                                public void on(Object[] resolvedObject) {
                                    Assert.assertEquals((long)resolvedObject.length, (long)1L);
                                    Assert.assertEquals((long)((KObject)resolvedObject[0]).uuid(), (long)node0.uuid());
                                }
                            });
                            ((CloudView)((CloudUniverse)model.universe(0L)).time(5L)).select("@org.kevoree.modeling.microframework.test.cloud.Node[name=node0]", (KCallback)new KCallback<Object[]>(){

                                public void on(Object[] resolvedObject) {
                                    Assert.assertEquals((long)resolvedObject.length, (long)1L);
                                    Assert.assertEquals((long)((KObject)resolvedObject[0]).uuid(), (long)node0.uuid());
                                }
                            });
                            model.findAllByName("org.kevoree.modeling.microframework.test.cloud.Node", 0L, 10L, (KCallback)new KCallback<KObject[]>(){

                                public void on(KObject[] resolvedObject) {
                                    Assert.assertEquals((long)resolvedObject.length, (long)1L);
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    @Test
    public void testDoubleIndex() {
        final CloudModel model = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect((KCallback)new KCallback<Throwable>(){

            public void on(Throwable throwable) {
                if (throwable != null) {
                    throwable.printStackTrace();
                } else {
                    MetaNode.ATT_NAME.setKey(true);
                    MetaNode.ATT_VALUE.setKey(true);
                    final Node node0 = (Node)model.create((KMetaClass)MetaNode.getInstance(), 0L, 0L);
                    node0.setName("node0");
                    model.find((KMetaClass)MetaNode.getInstance(), 0L, 0L, "name=node0", (KCallback)new KCallback<KObject>(){

                        public void on(KObject resolvedObject) {
                            Assert.assertEquals((long)resolvedObject.uuid(), (long)node0.uuid());
                        }
                    });
                    node0.setValue("version0");
                    model.find((KMetaClass)MetaNode.getInstance(), 0L, 0L, "name=node0", (KCallback)new KCallback<KObject>(){

                        public void on(KObject resolvedObject) {
                            Assert.assertEquals((Object)resolvedObject, null);
                        }
                    });
                    model.find((KMetaClass)MetaNode.getInstance(), 0L, 0L, "name=node0,value=version0", (KCallback)new KCallback<KObject>(){

                        public void on(KObject resolvedObject) {
                            Assert.assertEquals((long)resolvedObject.uuid(), (long)node0.uuid());
                        }
                    });
                    model.find((KMetaClass)MetaNode.getInstance(), 0L, 0L, "value=version0,name=node0", (KCallback)new KCallback<KObject>(){

                        public void on(KObject resolvedObject) {
                            Assert.assertEquals((long)resolvedObject.uuid(), (long)node0.uuid());
                        }
                    });
                }
            }
        });
    }
}

