/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling;

import java.util.concurrent.CountDownLatch;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KModel;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.KUniverse;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.meta.KMetaClass;
import org.kevoree.modeling.meta.KPrimitiveTypes;
import org.kevoree.modeling.meta.impl.MetaModel;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public class MultiUniverseTest {
    private MetaModel dynamicMetaModel;
    private KMetaClass sensorMetaClass;
    private KModel model;
    private KObject object;

    @Test
    public void testMultiVerse() {
        final long timeOrigine = 1000L;
        this.dynamicMetaModel = new MetaModel("MyMetaModel");
        this.sensorMetaClass = this.dynamicMetaModel.addMetaClass("Sensor");
        this.sensorMetaClass.addAttribute("value", KPrimitiveTypes.DOUBLE);
        this.sensorMetaClass.addRelation("siblings", this.sensorMetaClass, null);
        this.model = this.dynamicMetaModel.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        this.model.connect(new KCallback(){

            public void on(Object o) {
                MultiUniverseTest.this.object = MultiUniverseTest.this.model.universe(0L).time(timeOrigine).create(MultiUniverseTest.this.sensorMetaClass);
                long unit = 1000L;
                MultiUniverseTest.this.insert(0L, timeOrigine, 1.0);
                MultiUniverseTest.this.insert(0L, timeOrigine + unit, 5.0);
                MultiUniverseTest.this.insert(0L, timeOrigine + 4L * unit, 8.0);
                assert (MultiUniverseTest.this.get(0L, timeOrigine + 5L * unit) == 8.0);
                MultiUniverseTest.this.split(0, timeOrigine + 2L * unit);
                assert (MultiUniverseTest.this.get(0L, timeOrigine + unit) == 5.0);
                assert (MultiUniverseTest.this.get(1L, timeOrigine + unit) == 5.0);
                assert (MultiUniverseTest.this.get(0L, timeOrigine + 5L * unit) == 8.0);
                assert (MultiUniverseTest.this.get(1L, timeOrigine + 5L * unit) == 8.0);
                MultiUniverseTest.this.insert(0L, timeOrigine + 3L * unit, -2.0);
                assert (MultiUniverseTest.this.get(0L, timeOrigine + 3L * unit) == -2.0);
                assert (MultiUniverseTest.this.get(1L, timeOrigine + 3L * unit) == -2.0);
                MultiUniverseTest.this.insert(1L, timeOrigine + 3L * unit, 7.0);
                assert (MultiUniverseTest.this.get(0L, timeOrigine + 3L * unit) == -2.0);
                assert (MultiUniverseTest.this.get(1L, timeOrigine + 3L * unit) == 7.0);
                MultiUniverseTest.this.split(1, timeOrigine + 20L * unit);
                MultiUniverseTest.this.split(2, timeOrigine + 30L * unit);
                assert (MultiUniverseTest.this.get(2L, timeOrigine + 40L * unit) == 7.0);
                MultiUniverseTest.this.insert(0L, timeOrigine + 10L * unit, -20.0);
                MultiUniverseTest.this.insert(1L, timeOrigine + 4L * unit, -15.0);
                assert (MultiUniverseTest.this.get(1L, timeOrigine + 4L * unit) == -15.0);
                assert (MultiUniverseTest.this.get(2L, timeOrigine + 4L * unit) == -15.0);
                assert (MultiUniverseTest.this.get(3L, timeOrigine + 4L * unit) == -15.0);
                MultiUniverseTest.this.insert(3L, timeOrigine + 17L * unit, 80.0);
                assert (MultiUniverseTest.this.get(0L, timeOrigine + 17L * unit) == -20.0);
                assert (MultiUniverseTest.this.get(1L, timeOrigine + 17L * unit) == -15.0);
                assert (MultiUniverseTest.this.get(2L, timeOrigine + 17L * unit) == -15.0);
                assert (MultiUniverseTest.this.get(3L, timeOrigine + 17L * unit) == 80.0);
                MultiUniverseTest.this.insert(1L, timeOrigine + 18L * unit, 100.0);
                assert (MultiUniverseTest.this.get(0L, timeOrigine + 18L * unit) == -20.0);
                assert (MultiUniverseTest.this.get(1L, timeOrigine + 18L * unit) == 100.0);
                assert (MultiUniverseTest.this.get(2L, timeOrigine + 18L * unit) == 100.0);
                assert (MultiUniverseTest.this.get(3L, timeOrigine + 18L * unit) == 80.0);
                MultiUniverseTest.this.insert(3L, timeOrigine + 40L * unit, 78.0);
                assert (MultiUniverseTest.this.get(0L, timeOrigine + 40L * unit) == -20.0);
                assert (MultiUniverseTest.this.get(1L, timeOrigine + 40L * unit) == 100.0);
                assert (MultiUniverseTest.this.get(2L, timeOrigine + 40L * unit) == 100.0);
                assert (MultiUniverseTest.this.get(3L, timeOrigine + 40L * unit) == 78.0);
                MultiUniverseTest.this.insert(2L, timeOrigine + 25L * unit, -11.0);
                assert (MultiUniverseTest.this.get(0L, timeOrigine + 25L * unit) == -20.0);
                assert (MultiUniverseTest.this.get(1L, timeOrigine + 25L * unit) == 100.0);
                assert (MultiUniverseTest.this.get(2L, timeOrigine + 25L * unit) == -11.0);
                assert (MultiUniverseTest.this.get(3L, timeOrigine + 25L * unit) == 80.0);
                MultiUniverseTest.this.insert(2L, timeOrigine + 45L * unit, 35.0);
                assert (MultiUniverseTest.this.get(0L, timeOrigine + 45L * unit) == -20.0);
                assert (MultiUniverseTest.this.get(1L, timeOrigine + 45L * unit) == 100.0);
                assert (MultiUniverseTest.this.get(2L, timeOrigine + 45L * unit) == 35.0);
                assert (MultiUniverseTest.this.get(3L, timeOrigine + 45L * unit) == 78.0);
                assert (MultiUniverseTest.this.get(3L, timeOrigine + 1L * unit) == 5.0);
            }
        });
    }

    private void split(int parent, long splitTime) {
        KUniverse uni = this.model.universe((long)parent).diverge();
    }

    private void insert(long uId, long time, final double value) {
        final CountDownLatch latch = new CountDownLatch(1);
        this.model.universe(uId).time(time).lookup(this.object.uuid(), (KCallback)new KCallback<KObject>(){

            public void on(KObject kObject) {
                kObject.set(kObject.metaClass().attribute("value"), (Object)value);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public double get(long uId, long time) {
        final Object[] myvalue = new Object[]{null};
        final CountDownLatch latch = new CountDownLatch(1);
        this.model.universe(uId).time(time).lookup(this.object.uuid(), (KCallback)new KCallback<KObject>(){

            public void on(KObject kObject) {
                myvalue[0] = kObject.get(kObject.metaClass().attribute("value"));
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return (Double)myvalue[0];
    }
}

