/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling;

import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KModel;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.meta.KMetaAttribute;
import org.kevoree.modeling.meta.KMetaClass;
import org.kevoree.modeling.meta.KPrimitiveTypes;
import org.kevoree.modeling.meta.impl.MetaAttribute;
import org.kevoree.modeling.meta.impl.MetaModel;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public class SpeedTest {
    public void test() {
        MetaModel dynamicMetaModel = new MetaModel("MyMetaModel");
        final KMetaClass sensorMetaClass = dynamicMetaModel.addMetaClass("Sensor");
        sensorMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        sensorMetaClass.addAttribute("value", KPrimitiveTypes.DOUBLE);
        sensorMetaClass.addRelation("siblings", sensorMetaClass, null);
        KMetaClass homeMetaClass = dynamicMetaModel.addMetaClass("Home");
        homeMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        homeMetaClass.addRelation("sensors", sensorMetaClass, null);
        final KModel universe = dynamicMetaModel.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect((KCallback)new KCallback<Throwable>(){

            public void on(Throwable throwable) {
                KObject home = universe.universe(0L).time(0L).create(universe.metaModel().metaClassByName("Home"));
                home.set(home.metaClass().attribute("name"), (Object)"MainHome");
                KObject sensor = universe.universe(0L).time(0L).create(sensorMetaClass);
                sensor.set(sensor.metaClass().attribute("name"), (Object)"Sensor#1");
                home.addByName("sensors", sensor);
                long before = System.currentTimeMillis();
                final KMetaAttribute att = sensor.metaClass().attribute("value");
                ((MetaAttribute)att)._precision = 0.1;
                for (int i = 0; i < 5000000; ++i) {
                    sensor.jump((long)i, (KCallback)new KCallback<KObject>(){

                        public void on(KObject timedObject) {
                            timedObject.set(att, (Object)3.0);
                        }
                    });
                }
                long middle = System.currentTimeMillis();
                long after = System.currentTimeMillis();
                System.out.println(middle - before);
                System.out.println(after - middle);
            }
        });
    }
}

