/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.cloudmodel.CloudModel;
import org.kevoree.modeling.cloudmodel.CloudUniverse;
import org.kevoree.modeling.cloudmodel.CloudView;
import org.kevoree.modeling.cloudmodel.Element;
import org.kevoree.modeling.cloudmodel.Node;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public class TimeTest {
    final int[] jumpCounter = new int[]{4};
    private KCallback<KObject> jumpCallback = new KCallback<KObject>(){

        public void on(KObject kObject) {
            if (TimeTest.this.jumpCounter[0] > 0) {
                TimeTest.this.jumpCounter[0] = TimeTest.this.jumpCounter[0] - 1;
                if (kObject != null) {
                    Node n = (Node)kObject;
                    n.jump(TimeTest.this.jumpCounter[0], TimeTest.this.jumpCallback);
                }
            }
        }
    };

    @Test
    public void timeCreationTest() {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                Assert.assertNotNull((Object)((Object)dimension0));
                CloudView t0 = (CloudView)dimension0.time(0L);
                Assert.assertNotNull((Object)t0);
                Assert.assertEquals((long)t0.now(), (long)0L);
                CloudView t1 = (CloudView)dimension0.time(1L);
                Assert.assertNotNull((Object)t1);
                Assert.assertEquals((long)t1.now(), (long)1L);
            }
        });
    }

    @Test
    public void jumpTest() {
        final CloudModel cloud = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        cloud.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse universe = (CloudUniverse)cloud.newUniverse();
                CloudView view3 = (CloudView)universe.time(3L);
                Node n = view3.createNode();
                cloud.save(null);
                CloudView view5 = (CloudView)universe.time(5L);
                n.jump(TimeTest.this.jumpCounter[0], TimeTest.this.jumpCallback);
            }
        });
    }

    @Test
    public void simpleTimeNavigationTest() {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                Assert.assertNotNull((Object)((Object)dimension0));
                final CloudView t0 = (CloudView)dimension0.time(0L);
                Node node0 = t0.createNode();
                final Element element0 = t0.createElement();
                node0.addElement(element0);
                t0.lookup(node0.uuid(), (KCallback)new KCallback<KObject>(){

                    public void on(KObject kObject) {
                        ((Node)kObject).getElement(new KCallback<Element>(){

                            public void on(Element element) {
                                Assert.assertEquals((Object)element0, (Object)element);
                                Assert.assertEquals((long)element.now(), (long)t0.now());
                            }
                        });
                    }
                });
            }
        });
    }

    @Test
    public void distortedTimeNavigationTest() {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                Assert.assertNotNull((Object)((Object)dimension0));
                CloudView t0 = (CloudView)dimension0.time(0L);
                Node node0 = t0.createNode();
                node0.getElement(new KCallback<Element>(){

                    public void on(Element element) {
                        Assert.assertNull((Object)element);
                    }
                });
                t0.lookup(node0.uuid(), (KCallback)new KCallback<KObject>(){

                    public void on(KObject kObject) {
                        ((Node)kObject).getElement(new KCallback<Element>(){

                            public void on(Element element) {
                                Assert.assertNull((Object)element);
                            }
                        });
                    }
                });
                final CloudView t1 = (CloudView)dimension0.time(1L);
                final Element elem1 = t1.createElement();
                node0.addElement(elem1);
                t0.lookup(node0.uuid(), (KCallback)new KCallback<KObject>(){

                    public void on(KObject kObject) {
                        ((Node)kObject).getElement(new KCallback<Element>(){

                            public void on(Element element) {
                                Assert.assertNull((Object)element);
                            }
                        });
                    }
                });
                t1.lookup(node0.uuid(), (KCallback)new KCallback<KObject>(){

                    public void on(KObject kObject) {
                        ((Node)kObject).getElement(new KCallback<Element>(){

                            public void on(Element element) {
                                Assert.assertNotNull((Object)element);
                                Assert.assertEquals((Object)element, (Object)elem1);
                                Assert.assertEquals((long)element.now(), (long)t1.now());
                            }
                        });
                    }
                });
            }
        });
    }

    @Test
    public void objectModificationTest() {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                Assert.assertNotNull((Object)((Object)dimension0));
                CloudView t0 = (CloudView)dimension0.time(0L);
                Node node0 = t0.createNode();
                node0.setName("node at 0");
                node0.setValue("0");
                Element elem0 = t0.createElement();
                node0.addElement(elem0);
                CloudView t1 = (CloudView)dimension0.time(1L);
                t1.lookup(node0.uuid(), (KCallback)new KCallback<KObject>(){

                    public void on(KObject kObject) {
                        ((Node)kObject).setName("node at 1");
                        ((Node)kObject).setValue("1");
                    }
                });
                t0.lookup(node0.uuid(), (KCallback)new KCallback<KObject>(){

                    public void on(KObject kObject) {
                        Assert.assertEquals((Object)((Node)kObject).getName(), (Object)"node at 0");
                        Assert.assertEquals((Object)((Node)kObject).getValue(), (Object)"0");
                    }
                });
                t1.lookup(node0.uuid(), (KCallback)new KCallback<KObject>(){

                    public void on(KObject kObject) {
                        Assert.assertEquals((Object)((Node)kObject).getName(), (Object)"node at 1");
                        Assert.assertEquals((Object)((Node)kObject).getValue(), (Object)"1");
                    }
                });
            }
        });
    }

    @Test
    public void timeUpdateWithLookupTest() {
        final CloudModel model = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse universe = (CloudUniverse)model.newUniverse();
                CloudView t0 = (CloudView)universe.time(0L);
                Node node0 = t0.createNode();
                node0.setName("Node0");
                model.save((KCallback)new KCallback<Throwable>(){

                    public void on(Throwable aBoolean) {
                    }
                });
                CloudView t1 = (CloudView)universe.time(1L);
                final Element element = t1.createElement();
                element.setName("Element1");
                t1.lookup(node0.uuid(), (KCallback)new KCallback<KObject>(){

                    public void on(KObject node0Back) {
                        ((Node)node0Back).addElement(element);
                    }
                });
                model.save((KCallback)new KCallback<Throwable>(){

                    public void on(Throwable aBoolean) {
                    }
                });
                CloudView t0_2 = (CloudView)universe.time(0L);
                t0_2.select("@root", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] kObjects) {
                        if (kObjects == null || kObjects.length > 0) {
                            // empty if block
                        }
                    }
                });
            }
        });
    }
}

