/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.memory.chunk.KLongLongMap;
import org.kevoree.modeling.memory.chunk.impl.ArrayLongLongMap;
import org.kevoree.modeling.memory.resolver.impl.DistortedTimeResolver;

public class UniverseResolutionTest {
    @Test
    public void test() {
        ArrayLongLongMap globalUniverse = new ArrayLongLongMap(-1L, -1L, -1L, null);
        globalUniverse.put(0L, 0L);
        globalUniverse.put(1L, 0L);
        globalUniverse.put(3L, 1L);
        globalUniverse.put(2L, 0L);
        globalUniverse.put(4L, 2L);
        ArrayLongLongMap objectUniverse = new ArrayLongLongMap(-1L, -1L, -1L, null);
        objectUniverse.put(0L, 0L);
        objectUniverse.put(3L, 10L);
        objectUniverse.put(2L, 8L);
        Assert.assertEquals((long)0L, (long)DistortedTimeResolver.resolve_universe((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)0L, (long)0L));
        Assert.assertEquals((long)3L, (long)DistortedTimeResolver.resolve_universe((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)10L, (long)3L));
        Assert.assertEquals((long)3L, (long)DistortedTimeResolver.resolve_universe((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)50L, (long)3L));
        Assert.assertEquals((long)0L, (long)DistortedTimeResolver.resolve_universe((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)10L, (long)1L));
        Assert.assertEquals((long)2L, (long)DistortedTimeResolver.resolve_universe((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)10L, (long)2L));
        Assert.assertEquals((long)0L, (long)DistortedTimeResolver.resolve_universe((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)1L, (long)2L));
        Assert.assertEquals((long)2L, (long)DistortedTimeResolver.resolve_universe((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)50L, (long)4L));
        Assert.assertEquals((long)0L, (long)DistortedTimeResolver.resolve_universe((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)5L, (long)4L));
    }

    @Test
    public void testRange() {
        ArrayLongLongMap globalUniverse = new ArrayLongLongMap(-1L, -1L, -1L, null);
        globalUniverse.put(0L, 0L);
        globalUniverse.put(1L, 0L);
        globalUniverse.put(3L, 1L);
        globalUniverse.put(2L, 0L);
        globalUniverse.put(4L, 2L);
        ArrayLongLongMap objectUniverse = new ArrayLongLongMap(-1L, -1L, -1L, null);
        objectUniverse.put(0L, 0L);
        objectUniverse.put(3L, 10L);
        objectUniverse.put(2L, 8L);
        long[] collected = DistortedTimeResolver.universeSelectByRange((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)-9007199254740990L, (long)0x1FFFFFFFFFFFFEL, (long)4L);
        Assert.assertEquals((long)collected[0], (long)2L);
        Assert.assertEquals((long)collected[1], (long)0L);
        collected = DistortedTimeResolver.universeSelectByRange((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)-9007199254740990L, (long)0x1FFFFFFFFFFFFEL, (long)3L);
        Assert.assertEquals((long)collected[0], (long)3L);
        Assert.assertEquals((long)collected[1], (long)0L);
        collected = DistortedTimeResolver.universeSelectByRange((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)8L, (long)0x1FFFFFFFFFFFFEL, (long)4L);
        Assert.assertEquals((long)collected[0], (long)2L);
        collected = DistortedTimeResolver.universeSelectByRange((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)7L, (long)0x1FFFFFFFFFFFFEL, (long)4L);
        Assert.assertEquals((long)collected[0], (long)2L);
        Assert.assertEquals((long)collected[1], (long)0L);
        collected = DistortedTimeResolver.universeSelectByRange((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)8L, (long)9L, (long)4L);
        Assert.assertEquals((long)collected[0], (long)2L);
        collected = DistortedTimeResolver.universeSelectByRange((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)8L, (long)9L, (long)3L);
        Assert.assertEquals((long)collected[0], (long)0L);
        collected = DistortedTimeResolver.universeSelectByRange((KLongLongMap)globalUniverse, (KLongLongMap)objectUniverse, (long)-3L, (long)11L, (long)3L);
        Assert.assertEquals((long)collected[0], (long)3L);
        Assert.assertEquals((long)collected[1], (long)0L);
    }
}

