/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.extrapolation;

import org.junit.Assert;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.cloudmodel.CloudModel;
import org.kevoree.modeling.cloudmodel.CloudUniverse;
import org.kevoree.modeling.cloudmodel.CloudView;
import org.kevoree.modeling.cloudmodel.Element;
import org.kevoree.modeling.cloudmodel.Node;
import org.kevoree.modeling.cloudmodel.meta.MetaElement;
import org.kevoree.modeling.defer.KDefer;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public class PolynomialKMFTest {
    public void test() throws InterruptedException {
        final int[] nbAssert = new int[]{0};
        final CloudModel model = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)model.newUniverse();
                double[] val = new double[1000];
                final double[] coef = new double[]{2.0, 2.0, 3.0};
                CloudView t0 = (CloudView)dimension0.time(0L);
                Node node = t0.createNode();
                node.setName("n0");
                final Element element = t0.createElement();
                element.setName("e0");
                node.addElement(element);
                KDefer waiter = model.defer();
                for (int i = 200; i < 1000; ++i) {
                    ((CloudView)dimension0.time(i)).lookup(element.uuid(), waiter.waitResult());
                }
                waiter.then((KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        final double[] val = new double[objects.length];
                        for (int i = 200; i < 1000; ++i) {
                            long temp = 1L;
                            val[i - 200] = 0.0;
                            for (int j = 0; j < coef.length; ++j) {
                                val[i - 200] = val[i - 200] + coef[j] * (double)temp;
                                temp *= (long)i;
                            }
                            ((Element)objects[i - 200]).setValue(val[i - 200]);
                        }
                        element.allTimes((KCallback)new KCallback<long[]>(){

                            public void on(long[] collected) {
                                Assert.assertEquals((long)2L, (long)collected.length);
                                nbAssert[0] = nbAssert[0] + 1;
                                KDefer defer2 = model.defer();
                                for (int i = 200; i < 1000; ++i) {
                                    element.jump(i, defer2.waitResult());
                                }
                                defer2.then((KCallback)new KCallback<Object[]>(){

                                    public void on(Object[] objects) {
                                        for (int i = 200; i < 1000; ++i) {
                                            nbAssert[0] = nbAssert[0] + 1;
                                            Assert.assertTrue((Math.abs(((Element)objects[i - 200]).getValue() - val[i - 200]) < 5.0 ? 1 : 0) != 0);
                                        }
                                        Assert.assertEquals((long)nbAssert[0], (long)801L);
                                        element.allTimes((KCallback)new KCallback<long[]>(){

                                            public void on(long[] collected2) {
                                                Assert.assertEquals((long)2L, (long)collected2.length);
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    public void test2() {
        final int[] nbAssert = new int[]{0};
        final int max = 1000;
        final CloudModel model = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)model.newUniverse();
                final double[] val = new double[]{787.0, 301.0, 298.0, 254.0, 755.0, 780.0, 788.0, 782.0, 273.0, 301.0, 310.0, 296.0, 272.0, 309.0, 277.0, 782.0, 22.0, 27.0, 785.0, 785.0, 300.0, 782.0, 302.0, 783.0, 308.0, 782.0, 786.0, 302.0, 785.0, 301.0, 784.0, 303.0, 262.0, 298.0, 78.0, 302.0, 785.0, 779.0, 787.0, 310.0, 299.0, 302.0, 305.0, 303.0, 788.0, 783.0, 296.0, 788.0, 300.0, 289.0, 42.0, 783.0, 42.0, 296.0, 783.0, 782.0, 783.0, 786.0, 782.0, 787.0, 787.0, 243.0, 785.0, 310.0, 277.0, 786.0, 61.0, 22.0, 784.0, 305.0, 783.0, 787.0, 786.0, 785.0, 733.0, 782.0, 781.0, 784.0, 311.0, 786.0, 28.0, 782.0, 781.0, 84.0, 301.0, 787.0, 267.0, 43.0, 783.0, 783.0, 787.0, 786.0, 44.0, 787.0, 783.0, 781.0, 309.0, 782.0, 310.0, 785.0, 300.0, 36.0, 308.0, 788.0, 306.0, 92.0, 785.0, 781.0, 781.0, 785.0, 787.0, 782.0, 786.0, 298.0, 309.0, 787.0, 788.0, 784.0, 784.0, 333.0, 27.0, 297.0, 306.0, 309.0, 782.0, 787.0, 782.0, 275.0, 784.0, 786.0, 308.0, 784.0, 782.0, 295.0, 310.0, 292.0, 783.0, 306.0, 305.0, 42.0, 300.0, 786.0, 296.0, 301.0, 784.0, 306.0, 786.0, 71.0, 301.0, 784.0, 299.0, 300.0, 787.0, 301.0, 310.0, 783.0, 309.0, 782.0, 43.0, 784.0, 298.0, 309.0, 785.0, 788.0, 300.0, 782.0, 780.0, 784.0, 48.0, 787.0, 786.0, 72.0, 309.0, 787.0, 302.0, 309.0, 785.0, 272.0, 787.0, 307.0, 278.0, 25.0, 301.0, 786.0, 785.0, 301.0, 785.0, 786.0, 297.0, 305.0, 296.0, 299.0, 784.0, 27.0, 21.0, 784.0, 787.0, 310.0, 783.0, 787.0, 296.0, 304.0, 788.0, 299.0, 298.0, 783.0, 787.0, 784.0, 783.0, 788.0, 787.0, 306.0, 783.0, 309.0, 298.0, 782.0, 304.0, 781.0, 49.0, 295.0, 773.0, 45.0, 306.0, 287.0, 308.0, 81.0, 278.0, 310.0, 304.0, 782.0, 782.0, 300.0, 38.0, 309.0, 305.0, 298.0, 785.0, 787.0, 304.0, 309.0, 301.0, 61.0, 785.0, 785.0, 296.0, 291.0, 309.0, 299.0, 283.0, 304.0, 784.0, 783.0, 783.0, 788.0, 306.0, 784.0, 783.0, 283.0, 788.0, 31.0, 272.0, 784.0, 786.0, 310.0, 786.0, 299.0, 296.0, 308.0, 788.0, 305.0, 299.0, 306.0, 783.0, 783.0, 296.0, 299.0, 783.0, 277.0, 784.0, 785.0, 300.0, 306.0, 784.0, 753.0, 301.0, 787.0, 785.0, 788.0, 299.0, 782.0, 785.0, 304.0, 290.0, 296.0, 310.0, 788.0, 310.0, 788.0, 308.0, 782.0, 785.0, 784.0, 296.0, 781.0, 298.0, 786.0, 304.0, 306.0, 788.0, 782.0, 775.0, 296.0, 21.0, 310.0, 782.0, 56.0, 782.0, 781.0, 270.0, 307.0, 63.0, 304.0, 775.0, 310.0, 787.0, 299.0, 310.0, 298.0, 784.0, 300.0, 309.0, 271.0, 784.0, 271.0, 783.0, 297.0, 301.0, 783.0, 302.0, 308.0, 71.0, 788.0, 787.0, 310.0, 27.0, 299.0, 299.0, 786.0, 781.0, 310.0, 300.0, 299.0, 787.0, 90.0, 308.0, 273.0, 782.0, 786.0, 28.0, 21.0, 268.0, 787.0, 310.0, 309.0, 782.0, 299.0, 299.0, 788.0, 787.0, 783.0, 297.0, 784.0, 780.0, 782.0, 786.0, 784.0, 298.0, 300.0, 303.0, 782.0, 291.0, 785.0, 301.0, 781.0, 785.0, 787.0, 292.0, 782.0, 266.0, 303.0, 788.0, 788.0, 305.0, 299.0, 296.0, 76.0, 786.0, 277.0, 309.0, 785.0, 300.0, 305.0, 785.0, 300.0, 784.0, 786.0, 781.0, 305.0, 781.0, 783.0, 784.0, 273.0, 298.0, 785.0, 292.0, 786.0, 299.0, 781.0, 296.0, 299.0, 310.0, 781.0, 786.0, 783.0, 273.0, 782.0, 306.0, 310.0, 304.0, 297.0, 782.0, 784.0, 784.0, 310.0, 267.0, 786.0, 278.0, 304.0, 32.0, 308.0, 305.0, 278.0, 725.0, 28.0, 786.0, 309.0, 310.0, 300.0, 309.0, 782.0, 782.0, 278.0, 100.0, 301.0, 301.0, 298.0, 304.0, 299.0, 787.0, 788.0, 298.0, 31.0, 298.0, 784.0, 297.0, 27.0, 308.0, 779.0, 786.0, 782.0, 298.0, 305.0, 783.0, 302.0, 309.0, 785.0, 787.0, 784.0, 302.0, 271.0, 269.0, 296.0, 299.0, 307.0, 782.0, 781.0, 38.0, 310.0, 784.0, 298.0, 295.0, 303.0, 781.0, 305.0, 784.0, 296.0, 788.0, 271.0, 782.0, 299.0, 782.0, 784.0, 302.0, 310.0, 298.0, 784.0, 309.0, 297.0, 304.0, 781.0, 785.0, 303.0, 309.0, 300.0, 29.0, 77.0, 306.0, 782.0, 780.0, 306.0, 301.0, 306.0, 309.0, 785.0, 786.0, 308.0, 305.0, 787.0, 786.0, 43.0, 785.0, 787.0, 306.0, 786.0, 310.0, 308.0, 305.0, 784.0, 23.0, 292.0, 787.0, 296.0, 782.0, 41.0, 784.0, 781.0, 787.0, 300.0, 781.0, 784.0, 781.0, 298.0, 29.0, 785.0, 297.0, 788.0, 787.0, 301.0, 783.0, 788.0, 786.0, 788.0, 70.0, 785.0, 310.0, 783.0, 305.0, 785.0, 298.0, 35.0, 299.0, 788.0, 786.0, 310.0, 302.0, 787.0, 783.0, 298.0, 786.0, 787.0, 21.0, 306.0, 295.0, 305.0, 788.0, 784.0, 298.0, 783.0, 308.0, 787.0, 296.0, 786.0, 783.0, 782.0, 45.0, 302.0, 781.0, 787.0, 276.0, 21.0, 783.0, 300.0, 60.0, 301.0, 784.0, 782.0, 784.0, 298.0, 782.0, 298.0, 781.0, 73.0, 784.0, 288.0, 787.0, 301.0, 303.0, 781.0, 296.0, 305.0, 784.0, 305.0, 786.0, 306.0, 293.0, 273.0, 274.0, 783.0, 304.0, 781.0, 782.0, 309.0, 787.0, 787.0, 65.0, 305.0, 781.0, 784.0, 785.0, 28.0, 784.0, 15.0, 309.0, 783.0, 786.0, 309.0, 265.0, 301.0, 301.0, 788.0, 784.0, 782.0, 784.0, 783.0, 784.0, 310.0, 303.0, 310.0, 24.0, 299.0, 780.0, 308.0, 786.0, 733.0, 774.0, 274.0, 299.0, 298.0, 782.0, 786.0, 787.0, 782.0, 787.0, 788.0, 785.0, 303.0, 783.0, 305.0, 300.0, 307.0, 45.0, 300.0, 304.0, 780.0, 309.0, 71.0, 309.0, 786.0, 786.0, 302.0, 304.0, 785.0, 786.0, 296.0, 299.0, 788.0, 310.0, 783.0, 779.0, 275.0, 783.0, 293.0, 782.0, 787.0, 296.0, 306.0, 307.0, 785.0, 784.0, 786.0, 41.0, 299.0, 292.0, 782.0, 304.0, 782.0, 782.0, 296.0, 782.0, 785.0, 273.0, 782.0, 784.0, 306.0, 786.0, 68.0, 782.0, 305.0, 785.0, 787.0, 784.0, 106.0, 298.0, 309.0, 273.0, 787.0, 310.0, 309.0, 784.0, 296.0, 783.0, 786.0, 301.0, 787.0, 299.0, 310.0, 304.0, 783.0, 782.0, 300.0, 788.0, 781.0, 786.0, 303.0, 50.0, 309.0, 781.0, 131.0, 309.0, 787.0, 788.0, 785.0, 298.0, 299.0, 305.0, 308.0, 785.0, 310.0, 298.0, 787.0, 782.0, 784.0, 296.0, 272.0, 786.0, 787.0, 788.0, 783.0, 709.0, 782.0, 301.0, 273.0, 68.0, 310.0, 25.0, 305.0, 33.0, 280.0, 781.0, 785.0, 783.0, 273.0, 784.0, 305.0, 782.0, 301.0, 784.0, 41.0, 787.0, 309.0, 299.0, 787.0, 780.0, 299.0, 782.0, 306.0, 32.0, 299.0, 784.0, 305.0, 302.0, 270.0, 786.0, 305.0, 782.0, 16.0, 786.0, 310.0, 301.0, 302.0, 781.0, 302.0, 782.0, 783.0, 786.0, 302.0, 773.0, 296.0, 786.0, 785.0, 29.0, 781.0, 301.0, 299.0, 38.0, 786.0, 788.0, 780.0, 167.0, 785.0, 308.0, 787.0, 302.0, 788.0, 308.0, 783.0, 44.0, 785.0, 309.0, 300.0, 305.0, 296.0, 310.0, 301.0, 773.0, 304.0, 784.0, 788.0, 786.0, 301.0, 787.0, 296.0, 782.0, 787.0, 23.0, 784.0, 781.0, 78.0, 278.0, 297.0, 785.0, 147.0, 783.0, 297.0, 781.0, 277.0, 787.0, 781.0, 787.0, 309.0, 782.0, 784.0, 268.0, 30.0, 299.0, 57.0, 787.0, 785.0, 310.0, 306.0, 783.0, 309.0, 305.0, 79.0, 784.0, 300.0, 309.0, 299.0, 787.0, 304.0, 274.0, 294.0, 296.0, 787.0, 23.0, 786.0, 27.0, 309.0, 780.0, 785.0, 787.0, 41.0, 296.0, 308.0, 22.0, 297.0, 780.0, 300.0, 277.0, 788.0, 302.0, 309.0, 15.0, 296.0, 784.0, 306.0, 29.0, 781.0, 782.0, 787.0, 23.0, 15.0, 43.0, 786.0, 309.0, 788.0, 304.0, 784.0, 302.0, 788.0, 46.0, 787.0, 788.0, 782.0, 308.0, 785.0, 308.0, 785.0, 788.0, 788.0, 787.0, 782.0, 310.0, 787.0, 308.0, 771.0, 305.0, 781.0, 732.0, 22.0, 788.0, 304.0, 788.0, 781.0, 302.0, 787.0, 306.0, 784.0, 781.0, 307.0, 29.0, 308.0, 788.0, 303.0, 305.0, 309.0, 783.0, 783.0, 298.0, 785.0, 299.0, 310.0, 308.0, 302.0, 779.0, 22.0, 310.0, 787.0, 735.0, 281.0, 309.0, 787.0, 298.0, 788.0, 785.0, 51.0, 299.0, 305.0, 782.0, 309.0, 787.0, 788.0, 785.0, 781.0, 30.0, 297.0, 787.0, 279.0, 785.0, 784.0, 304.0, 306.0, 787.0, 296.0, 298.0, 307.0, 308.0, 787.0, 305.0, 304.0, 781.0, 309.0, 310.0, 784.0, 309.0, 299.0, 785.0, 306.0, 782.0, 783.0, 43.0, 309.0, 302.0, 298.0, 271.0, 782.0, 31.0, 783.0, 300.0, 787.0, 787.0, 298.0, 787.0, 70.0, 780.0, 786.0, 783.0, 784.0, 26.0, 785.0, 301.0, 77.0, 298.0, 309.0, 273.0, 274.0, 782.0, 309.0, 306.0, 305.0, 785.0, 308.0, 301.0, 300.0, 296.0, 305.0, 308.0, 296.0, 302.0, 302.0, 788.0, 302.0, 300.0, 296.0, 299.0, 301.0, 297.0, 785.0, 787.0, 268.0, 786.0, 300.0, 304.0, 782.0, 285.0, 780.0, 42.0, 785.0, 310.0, 298.0, 276.0, 782.0, 787.0, 296.0, 270.0, 302.0, 15.0, 301.0, 298.0, 784.0, 299.0, 309.0, 291.0, 42.0, 294.0, 298.0, 787.0, 309.0, 306.0, 296.0, 305.0, 781.0, 788.0, 70.0, 301.0, 304.0, 305.0, 309.0, 785.0, 297.0, 617.0, 299.0, 301.0, 781.0, 308.0, 25.0, 298.0, 302.0, 788.0, 784.0, 786.0, 305.0, 784.0, 305.0, 783.0, 307.0, 784.0, 786.0, 296.0, 785.0, 787.0, 301.0, 309.0, 782.0, 784.0, 785.0, 786.0, 302.0, 787.0, 296.0, 309.0, 781.0, 783.0, 310.0, 308.0, 782.0, 305.0, 782.0, 304.0, 310.0, 304.0, 308.0, 782.0, 785.0, 234.0, 783.0, 784.0, 782.0, 786.0, 309.0, 301.0, 79.0, 299.0, 783.0, 296.0, 301.0, 38.0, 280.0, 298.0, 305.0, 783.0, 787.0, 310.0, 783.0, 308.0, 308.0, 273.0, 295.0, 299.0, 304.0, 310.0, 783.0, 788.0, 784.0, 298.0, 308.0, 785.0, 301.0, 309.0, 786.0, 780.0, 782.0, 273.0, 278.0, 292.0, 23.0, 241.0, 310.0, 783.0, 785.0, 278.0, 782.0, 787.0, 784.0, 310.0, 308.0, 784.0, 308.0, 781.0, 786.0, 780.0, 277.0, 289.0, 306.0, 788.0, 783.0, 48.0, 30.0, 782.0, 306.0, 779.0, 782.0, 782.0, 303.0, 788.0, 299.0, 300.0, 783.0, 784.0, 785.0, 788.0, 278.0, 256.0, 272.0, 782.0, 94.0, 782.0, 787.0, 298.0, 300.0, 784.0, 291.0, 781.0, 774.0, 310.0, 43.0, 37.0, 299.0, 786.0, 785.0, 308.0, 302.0, 785.0, 277.0, 784.0, 782.0, 47.0, 304.0, 305.0, 302.0, 23.0, 781.0, 784.0, 309.0, 300.0, 306.0, 306.0, 279.0, 785.0, 783.0, 786.0, 785.0, 784.0, 787.0, 787.0, 783.0, 783.0, 298.0, 308.0, 305.0, 785.0, 94.0, 783.0, 275.0, 299.0, 309.0, 783.0, 784.0, 296.0, 785.0, 20.0, 785.0, 780.0, 271.0, 786.0, 296.0, 270.0, 291.0, 787.0, 305.0, 304.0, 309.0, 305.0, 784.0, 784.0, 305.0, 299.0, 784.0, 298.0, 302.0, 781.0, 788.0, 297.0, 301.0, 785.0, 300.0, 303.0, 302.0, 785.0, 785.0, 303.0, 310.0, 299.0, 787.0, 787.0, 787.0, 299.0, 785.0, 298.0, 787.0, 781.0, 785.0, 751.0, 17.0, 786.0, 270.0, 785.0, 309.0, 296.0, 299.0, 782.0, 785.0, 785.0, 781.0, 786.0, 785.0, 787.0, 785.0, 300.0, 299.0, 53.0, 309.0, 298.0, 299.0, 784.0, 782.0, 782.0, 272.0, 782.0, 787.0, 303.0, 301.0, 783.0, 292.0, 305.0, 787.0, 85.0, 309.0, 787.0, 309.0, 783.0, 307.0, 781.0, 301.0, 782.0, 303.0, 785.0, 310.0, 308.0, 305.0, 301.0, 299.0, 309.0, 267.0, 101.0, 310.0, 788.0, 308.0, 785.0, 304.0, 784.0, 783.0, 787.0, 22.0, 309.0, 27.0, 277.0, 779.0, 31.0, 304.0, 310.0, 106.0, 304.0, 785.0, 782.0, 302.0, 280.0, 788.0, 276.0, 305.0, 301.0, 267.0, 306.0, 785.0, 273.0, 785.0, 308.0, 788.0, 785.0, 784.0, 28.0, 787.0, 299.0, 297.0, 301.0, 788.0, 787.0, 310.0, 781.0, 783.0, 301.0, 785.0, 300.0, 784.0, 782.0, 80.0, 786.0, 304.0, 73.0, 310.0, 787.0, 274.0, 788.0, 309.0, 309.0, 305.0, 781.0, 305.0, 77.0, 788.0, 784.0, 786.0, 787.0, 781.0, 21.0, 787.0, 305.0, 783.0, 783.0, 783.0, 74.0, 787.0, 781.0, 785.0, 787.0, 27.0, 295.0, 309.0, 310.0, 310.0, 783.0, 298.0, 783.0, 782.0, 28.0, 308.0, 736.0, 787.0, 292.0, 300.0, 303.0, 28.0, 309.0, 297.0, 782.0, 310.0, 42.0, 296.0, 786.0, 782.0, 787.0, 305.0, 21.0, 40.0, 300.0, 783.0, 310.0, 299.0, 65.0, 391.0, 299.0, 785.0, 298.0, 783.0, 786.0, 301.0, 308.0, 787.0, 300.0, 297.0, 309.0, 779.0, 788.0, 779.0, 296.0, 298.0, 301.0, 782.0, 310.0, 273.0, 783.0, 786.0, 784.0, 48.0, 296.0, 298.0, 24.0, 782.0, 56.0, 47.0, 782.0, 782.0, 276.0, 298.0, 783.0, 788.0, 784.0, 299.0, 305.0, 289.0, 783.0, 306.0, 782.0, 309.0, 784.0, 787.0, 304.0, 296.0, 20.0, 782.0, 781.0, 788.0, 301.0, 784.0, 299.0, 782.0, 309.0, 787.0, 306.0, 305.0, 306.0, 784.0, 785.0, 780.0, 310.0, 310.0, 786.0, 783.0, 782.0, 784.0, 787.0, 22.0, 784.0, 295.0, 301.0, 298.0, 43.0, 787.0, 781.0, 781.0, 301.0, 779.0, 299.0, 299.0, 301.0, 787.0, 785.0, 72.0, 783.0, 787.0, 782.0, 784.0, 24.0, 783.0, 781.0, 787.0, 784.0, 306.0, 784.0, 783.0, 788.0, 782.0, 786.0, 783.0, 309.0, 298.0, 785.0, 301.0, 295.0, 786.0, 304.0, 787.0, 27.0, 784.0, 310.0, 297.0, 302.0, 310.0, 301.0, 295.0, 27.0, 308.0, 785.0, 784.0, 300.0, 278.0, 303.0, 775.0, 787.0, 305.0, 298.0, 786.0, 267.0, 784.0, 787.0, 309.0, 782.0, 303.0, 773.0, 787.0, 301.0, 298.0, 75.0, 306.0, 787.0, 781.0, 27.0, 782.0, 304.0, 781.0, 787.0, 310.0, 781.0, 783.0, 784.0, 785.0, 785.0, 295.0, 68.0, 787.0, 307.0, 783.0, 785.0, 781.0, 291.0, 298.0, 783.0, 49.0, 788.0, 305.0, 309.0, 304.0, 31.0, 785.0, 787.0, 783.0, 783.0, 74.0, 782.0, 782.0, 310.0, 310.0, 301.0, 309.0, 783.0, 301.0, 780.0, 296.0, 785.0, 781.0, 298.0, 310.0, 781.0, 273.0, 787.0, 302.0, 30.0, 309.0, 310.0, 296.0, 269.0, 48.0, 292.0, 305.0, 783.0, 785.0, 785.0, 784.0, 788.0, 781.0, 787.0, 787.0, 787.0, 257.0, 753.0, 781.0, 32.0, 296.0, 785.0, 308.0, 307.0, 53.0, 782.0, 782.0, 305.0, 305.0, 785.0, 296.0, 775.0, 783.0, 787.0, 785.0, 309.0, 784.0, 299.0, 787.0, 23.0, 782.0, 299.0, 783.0, 71.0, 298.0, 308.0, 302.0, 305.0, 785.0, 309.0, 306.0, 309.0, 782.0, 310.0, 299.0, 787.0, 24.0, 780.0, 784.0, 786.0, 277.0, 309.0, 309.0, 782.0, 783.0, 305.0, 783.0, 301.0, 301.0, 305.0, 788.0, 299.0, 301.0, 786.0, 79.0, 785.0, 784.0, 298.0, 786.0, 308.0, 786.0, 787.0, 298.0, 302.0, 304.0, 782.0, 783.0, 781.0, 787.0, 303.0, 303.0, 310.0, 302.0, 783.0, 787.0, 787.0, 301.0, 784.0, 785.0, 782.0, 295.0, 781.0, 781.0, 301.0, 783.0, 310.0, 310.0, 308.0, 305.0, 309.0, 300.0, 786.0, 787.0, 781.0, 785.0, 785.0, 786.0, 784.0, 786.0, 787.0, 276.0, 787.0, 788.0, 299.0, 305.0, 788.0, 275.0, 296.0, 782.0, 785.0, 784.0, 784.0, 305.0, 787.0, 39.0, 23.0, 781.0, 784.0, 279.0, 628.0, 783.0, 305.0, 273.0, 306.0, 298.0, 783.0, 786.0, 786.0, 298.0, 309.0, 298.0, 297.0, 303.0, 296.0, 787.0, 783.0, 550.0, 781.0, 784.0, 782.0, 782.0, 295.0, 306.0, 277.0, 278.0, 787.0, 782.0, 303.0, 781.0, 785.0, 305.0, 295.0, 308.0, 783.0, 780.0, 43.0, 310.0, 306.0, 309.0, 785.0, 787.0, 81.0, 299.0, 785.0, 299.0, 788.0, 299.0, 784.0, 783.0, 783.0, 783.0, 784.0, 783.0, 783.0, 783.0, 783.0, 298.0, 297.0, 299.0, 298.0, 783.0, 299.0, 295.0, 783.0, 784.0, 308.0, 296.0, 299.0, 785.0, 88.0, 785.0, 304.0, 310.0, 310.0, 308.0, 786.0, 783.0, 786.0, 786.0, 782.0, 786.0, 310.0, 273.0, 298.0, 276.0, 783.0, 786.0, 784.0, 787.0, 299.0, 296.0, 273.0, 309.0, 296.0, 763.0, 298.0, 302.0, 784.0, 310.0, 310.0, 300.0, 786.0, 22.0, 787.0, 780.0, 301.0, 782.0, 785.0, 786.0, 310.0, 310.0, 310.0, 309.0, 787.0, 782.0, 30.0, 309.0, 308.0, 782.0, 787.0, 786.0, 782.0, 296.0, 782.0, 278.0, 292.0, 309.0, 301.0, 785.0, 786.0, 783.0, 780.0, 298.0, 73.0, 785.0, 273.0, 98.0, 784.0, 780.0, 787.0, 310.0, 783.0, 784.0, 298.0, 787.0, 784.0, 305.0, 787.0, 786.0, 787.0, 785.0, 27.0, 57.0};
                CloudView t0 = (CloudView)dimension0.time(0L);
                Node node = t0.createNode();
                node.setName("n0");
                final Element element = t0.createElement();
                element.setName("e0");
                node.addElement(element);
                KDefer defer = model.defer();
                for (int i = 0; i < max; ++i) {
                    element.jump(i, defer.waitResult());
                }
                defer.then((KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        for (int i = 0; i < max; ++i) {
                            ((Element)objects[i]).setValue(val[i]);
                        }
                        element.allTimes((KCallback)new KCallback<long[]>(){

                            public void on(long[] collectedTimes) {
                                Assert.assertEquals((long)87L, (long)collectedTimes.length);
                                KDefer defer2 = model.defer();
                                for (int i = 0; i < max; ++i) {
                                    element.jump(i, defer2.waitResult());
                                }
                                nbAssert[0] = nbAssert[0] + 1;
                                defer2.then((KCallback)new KCallback<Object[]>(){

                                    public void on(Object[] objects) {
                                        for (int i = 0; i < max; ++i) {
                                            nbAssert[0] = nbAssert[0] + 1;
                                            double valss = ((Element)objects[i]).getValue();
                                            Assert.assertTrue((Math.abs(valss - val[i]) < MetaElement.ATT_VALUE.precision() ? 1 : 0) != 0);
                                        }
                                        Assert.assertEquals((long)nbAssert[0], (long)(max + 1));
                                        element.allTimes((KCallback)new KCallback<long[]>(){

                                            public void on(long[] collected2) {
                                                Assert.assertEquals((long)87L, (long)collected2.length);
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }
}

