/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.format.json;

import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.cloudmodel.CloudModel;
import org.kevoree.modeling.cloudmodel.CloudUniverse;
import org.kevoree.modeling.cloudmodel.CloudView;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public class JSONLoadTest {
    @Test
    public void jsonLoadTest() {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                final int[] passed = new int[]{0};
                final CloudView time0 = (CloudView)dimension0.time(0L);
                time0.json().load("[\n{\"@class\":\"org.kevoree.modeling.microframework.test.cloud.Node\",\"@uuid\":1,\"name\":\"root\",\"children\":[2,3]},\n{\"@class\":\"org.kevoree.modeling.microframework.test.cloud.Node\",\"@uuid\":2,\"name\":\"n1\"},\n{\"@class\":\"org.kevoree.modeling.microframework.test.cloud.Node\",\"@uuid\":3,\"name\":\"n2\"}\n]\n", (KCallback)new KCallback<Throwable>(){

                    public void on(Throwable res) {
                        final CountDownLatch latch = new CountDownLatch(3);
                        time0.lookup(1L, (KCallback)new KCallback<KObject>(){

                            public void on(KObject r) {
                                Assert.assertEquals((Object)"{\"universe\":1,\"time\":0,\"uuid\":1,\"data\":{\"name\":\"root\",\"children\":[2,3]}}", (Object)r.toJSON());
                                Assert.assertNotNull((Object)r);
                                passed[0] = passed[0] + 1;
                                latch.countDown();
                            }
                        });
                        time0.lookup(2L, (KCallback)new KCallback<KObject>(){

                            public void on(KObject r) {
                                Assert.assertEquals((Object)"{\"universe\":1,\"time\":0,\"uuid\":2,\"data\":{\"name\":\"n1\"}}", (Object)r.toJSON());
                                Assert.assertNotNull((Object)r);
                                passed[0] = passed[0] + 1;
                                latch.countDown();
                            }
                        });
                        time0.lookup(3L, (KCallback)new KCallback<KObject>(){

                            public void on(KObject r) {
                                Assert.assertEquals((Object)"{\"universe\":1,\"time\":0,\"uuid\":3,\"data\":{\"name\":\"n2\"}}", (Object)r.toJSON());
                                Assert.assertNotNull((Object)r);
                                passed[0] = passed[0] + 1;
                                latch.countDown();
                            }
                        });
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        Assert.assertEquals((long)passed[0], (long)3L);
                    }
                });
            }
        });
    }
}

