/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.format.json;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.cloudmodel.CloudModel;
import org.kevoree.modeling.cloudmodel.CloudUniverse;
import org.kevoree.modeling.cloudmodel.CloudView;
import org.kevoree.modeling.cloudmodel.Node;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public class JSONSaveTest {
    @Test
    public void escapeJsonTest() {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                CloudView time0 = (CloudView)dimension0.time(0L);
                final Node root = time0.createNode();
                root.setName("root\nhello");
                final String[] result = new String[1];
                time0.json().save((KObject)root, (KCallback)new KCallback<String>(){

                    public void on(String model) {
                        result[0] = model;
                        Assert.assertEquals((Object)result[0], (Object)"[\n{\"@class\":\"org.kevoree.modeling.microframework.test.cloud.Node\",\"@uuid\":1,\"name\":\"root\\nhello\"}\n]\n");
                        CloudUniverse dimension1 = (CloudUniverse)universe.newUniverse();
                        final CloudView time10 = (CloudView)dimension1.time(0L);
                        time10.json().load("[\n\t{\n\t\t\"@class\": \"org.kevoree.modeling.microframework.test.cloud.Node\",\n\t\t\"@uuid\": \"1\",\n\t\t\"@root\": \"true\",\n\t\t\"name\": \"root\\nhello\"\n\t}\n]\n", (KCallback)new KCallback<Throwable>(){

                            public void on(Throwable throwable) {
                                if (throwable != null) {
                                    throwable.printStackTrace();
                                }
                                time10.json().save((KObject)root, (KCallback)new KCallback<String>(){

                                    public void on(String model) {
                                        result[0] = model;
                                    }
                                });
                                Assert.assertEquals((Object)result[0], (Object)"[\n{\"@class\":\"org.kevoree.modeling.microframework.test.cloud.Node\",\"@uuid\":1,\"name\":\"root\\nhello\"}\n]\n");
                            }
                        });
                    }
                });
            }
        });
    }

    @Test
    public void jsonSaveTest() {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                CloudView time0 = (CloudView)dimension0.time(0L);
                Node root = time0.createNode();
                root.setName("root");
                Node n1 = time0.createNode();
                n1.setName("n1");
                Node n2 = time0.createNode();
                n2.setName("n2");
                root.addChildren(n1);
                root.addChildren(n2);
                final String[] result = new String[1];
                time0.json().save((KObject)root, (KCallback)new KCallback<String>(){

                    public void on(String model) {
                        result[0] = model;
                        String payloadResult = "[\n{\"@class\":\"org.kevoree.modeling.microframework.test.cloud.Node\",\"@uuid\":1,\"name\":\"root\",\"children\":[3,4]},\n{\"@class\":\"org.kevoree.modeling.microframework.test.cloud.Node\",\"@uuid\":3,\"name\":\"n1\",\"op_children\":[1]},\n{\"@class\":\"org.kevoree.modeling.microframework.test.cloud.Node\",\"@uuid\":4,\"name\":\"n2\",\"op_children\":[1]}\n]\n";
                        Assert.assertEquals((Object)result[0], (Object)payloadResult);
                    }
                });
            }
        });
    }
}

