/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.infer;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KModel;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.KObjectInfer;
import org.kevoree.modeling.infer.KInferAlg;
import org.kevoree.modeling.infer.impl.StatInferAlg;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.meta.KMetaClass;
import org.kevoree.modeling.meta.KMetaEnum;
import org.kevoree.modeling.meta.KMetaModel;
import org.kevoree.modeling.meta.KPrimitiveTypes;
import org.kevoree.modeling.meta.impl.MetaModel;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public class BaseKObjectInferTest {
    private KMetaModel createMetaModel() {
        MetaModel metaModel = new MetaModel("InferTestMM");
        KMetaClass metaClassSensor = metaModel.addMetaClass("Sensor");
        metaClassSensor.addAttribute("name", KPrimitiveTypes.STRING);
        metaClassSensor.addAttribute("value", KPrimitiveTypes.DOUBLE);
        metaClassSensor.addRelation("siblings", metaClassSensor, null);
        KMetaEnum metaEnumState = metaModel.addMetaEnum("State");
        metaEnumState.addLiteral("OK");
        metaEnumState.addLiteral("NOK");
        KMetaClass inferAvg = metaModel.addInferMetaClass("SensorProfile", (KInferAlg)new StatInferAlg());
        inferAvg.addDependency("sensors", metaClassSensor.index());
        inferAvg.addInput("sensors", "=value");
        inferAvg.addOutput("avg", KPrimitiveTypes.DOUBLE);
        return metaModel;
    }

    @Test
    public void test() {
        KMetaModel mm = this.createMetaModel();
        final KModel model = mm.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect(new KCallback(){

            public void on(Object o) {
                KObject sensor1 = model.createByName("Sensor", 0L, 0L);
                sensor1.setByName("name", (Object)"sensor#1");
                sensor1.setByName("value", (Object)0.42);
                KObject sensor2 = model.createByName("Sensor", 0L, 0L);
                sensor2.setByName("name", (Object)"sensor#2");
                sensor2.setByName("value", (Object)0.22);
                KObjectInfer sensorProfile = (KObjectInfer)model.createByName("SensorProfile", 0L, 0L);
                sensorProfile.genericTrain(new KObject[]{sensor1}, null, null);
                sensorProfile.genericTrain(new KObject[]{sensor2}, null, null);
                sensorProfile.genericInfer(new KObject[]{sensor2}, (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        Assert.assertEquals((Object)objects[0], (Object)0.32);
                    }
                });
            }
        });
    }
}

