/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.infer;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KModel;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.KObjectInfer;
import org.kevoree.modeling.KType;
import org.kevoree.modeling.infer.KInferAlg;
import org.kevoree.modeling.infer.impl.StatInferAlg;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.meta.KMetaClass;
import org.kevoree.modeling.meta.KMetaEnum;
import org.kevoree.modeling.meta.KMetaModel;
import org.kevoree.modeling.meta.KPrimitiveTypes;
import org.kevoree.modeling.meta.impl.MetaModel;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public class BasicEnumInferTest {
    private KMetaModel createMetaModel() {
        MetaModel metaModel = new MetaModel("InferTestMM");
        KMetaEnum metaEnumState = metaModel.addMetaEnum("State");
        metaEnumState.addLiteral("OK");
        metaEnumState.addLiteral("NOK");
        KMetaClass metaClassSensor = metaModel.addMetaClass("Sensor");
        metaClassSensor.addAttribute("name", KPrimitiveTypes.STRING);
        metaClassSensor.addAttribute("state", (KType)metaEnumState);
        KMetaClass inferAvg = metaModel.addInferMetaClass("SensorProfile", (KInferAlg)new StatInferAlg());
        inferAvg.addDependency("sensors", metaClassSensor.index());
        inferAvg.addInput("sensors", "=state");
        inferAvg.addOutput("avg_state", (KType)metaEnumState);
        return metaModel;
    }

    @Test
    public void test() {
        final KMetaModel mm = this.createMetaModel();
        final KModel model = mm.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect(new KCallback(){

            public void on(Object o) {
                KObject sensor1 = model.createByName("Sensor", 0L, 0L);
                sensor1.setByName("name", (Object)"sensor#1");
                sensor1.setByName("state", (Object)mm.metaTypeByName("State").literalByName("OK"));
                Assert.assertEquals((Object)sensor1.getByName("state"), (Object)mm.metaTypeByName("State").literalByName("OK"));
                sensor1.setByName("state", (Object)"NOK");
                Assert.assertEquals((Object)sensor1.getByName("state"), (Object)mm.metaTypeByName("State").literalByName("NOK"));
                sensor1.setByName("state", (Object)"OK");
                KObject sensor2 = model.createByName("Sensor", 0L, 0L);
                sensor2.setByName("name", (Object)"sensor#2");
                sensor2.setByName("state", (Object)mm.metaTypeByName("State").literalByName("NOK"));
                KObjectInfer sensorProfile = (KObjectInfer)model.createByName("SensorProfile", 0L, 0L);
                sensorProfile.genericTrain(new KObject[]{sensor1}, null, null);
                sensorProfile.genericTrain(new KObject[]{sensor2}, null, null);
                sensorProfile.genericTrain(new KObject[]{sensor2}, null, null);
                sensorProfile.genericInfer(new KObject[]{sensor2}, (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        Assert.assertEquals((Object)objects[0], (Object)mm.metaTypeByName("State").literalByName("NOK"));
                    }
                });
            }
        });
    }
}

