/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.infer;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KModel;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.KObjectInfer;
import org.kevoree.modeling.infer.KInferAlg;
import org.kevoree.modeling.infer.impl.LinearRegressionAlg;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.meta.KMetaClass;
import org.kevoree.modeling.meta.KMetaModel;
import org.kevoree.modeling.meta.KPrimitiveTypes;
import org.kevoree.modeling.meta.impl.MetaModel;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;
import org.kevoree.modeling.util.PrimitiveHelper;

public class LinearRegressionInferTest {
    private static Random rand = new Random();
    private static KMetaModel mm;
    private static KModel model;

    private KMetaModel createMetaModel() {
        MetaModel metaModel = new MetaModel("GaussianClassificationTestMM");
        KMetaClass metaClassHouse = metaModel.addMetaClass("House");
        metaClassHouse.addAttribute("length", KPrimitiveTypes.DOUBLE);
        metaClassHouse.addAttribute("width", KPrimitiveTypes.DOUBLE);
        metaClassHouse.addAttribute("height", KPrimitiveTypes.DOUBLE);
        metaClassHouse.addAttribute("numOfRooms", KPrimitiveTypes.DOUBLE);
        metaClassHouse.addAttribute("price", KPrimitiveTypes.DOUBLE);
        KMetaClass regressionProfile = metaModel.addInferMetaClass("RegressionProfile", (KInferAlg)new LinearRegressionAlg());
        regressionProfile.addDependency("House", metaClassHouse.index());
        regressionProfile.addInput("House", "=length");
        regressionProfile.addInput("House", "=width");
        regressionProfile.addInput("House", "=height");
        regressionProfile.addInput("House", "=numOfRooms");
        regressionProfile.addOutput("price", KPrimitiveTypes.DOUBLE);
        return metaModel;
    }

    private double getPrice(double length, double width, double height, double rooms) {
        return 13.0 * length + 21.0 * width + 0.01 * height + 15.0 * rooms - 20.0;
    }

    private KObject createHouse() {
        KObject house = model.createByName("House", 0L, 0L);
        double length = rand.nextDouble();
        double width = rand.nextDouble();
        double height = rand.nextDouble();
        double rooms = rand.nextDouble();
        double price = this.getPrice(length, width, height, rooms);
        house.setByName("length", (Object)length);
        house.setByName("width", (Object)width);
        house.setByName("height", (Object)height);
        house.setByName("numOfRooms", (Object)rooms);
        house.setByName("price", (Object)price);
        return house;
    }

    @Test
    public void test() {
        mm = this.createMetaModel();
        model = mm.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect(new KCallback(){

            public void on(Object o) {
                KObjectInfer regProfile = (KObjectInfer)model.createByName("RegressionProfile", 0L, 0L);
                int trainingSize = 10000;
                for (int i = 0; i < trainingSize; ++i) {
                    KObject house = LinearRegressionInferTest.this.createHouse();
                    Object[] output = new Object[]{PrimitiveHelper.parseDouble((String)house.getByName("price").toString())};
                    regProfile.genericTrain(new KObject[]{house}, output, null);
                }
                final KObject[] test = new KObject[]{LinearRegressionInferTest.this.createHouse()};
                regProfile.genericInfer(test, (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        double calcPrice;
                        double price = PrimitiveHelper.parseDouble((String)test[0].getByName("price").toString());
                        Assert.assertTrue((Math.abs(price - (calcPrice = PrimitiveHelper.parseDouble((String)objects[0].toString()))) < 10.0 ? 1 : 0) != 0);
                    }
                });
            }
        });
    }
}

