/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.infer;

import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KModel;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.KObjectInfer;
import org.kevoree.modeling.infer.KInferAlg;
import org.kevoree.modeling.infer.impl.RecommendationAlg;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.meta.KMetaClass;
import org.kevoree.modeling.meta.KMetaModel;
import org.kevoree.modeling.meta.KPrimitiveTypes;
import org.kevoree.modeling.meta.impl.MetaModel;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public class Recommandation {
    private KMetaModel createMetaModel() {
        MetaModel metaModel = new MetaModel("RecommendationMM");
        KMetaClass metaClassUser = metaModel.addMetaClass("User");
        metaClassUser.addAttribute("name", KPrimitiveTypes.STRING);
        KMetaClass metaClassProduct = metaModel.addMetaClass("Product");
        metaClassProduct.addAttribute("name", KPrimitiveTypes.STRING);
        KMetaClass metaClassRating = metaModel.addMetaClass("Rating");
        metaClassRating.addRelation("ownerUser", metaClassUser, "userRatings");
        metaClassUser.addRelation("userRatings", metaClassRating, "ownerUser");
        metaClassRating.addRelation("ratedProduct", metaClassUser, "productRatings");
        metaClassProduct.addRelation("productRatings", metaClassRating, "ratedProduct");
        metaClassRating.addAttribute("ratingValue", KPrimitiveTypes.DOUBLE);
        KMetaClass recommendationSystem = metaModel.addInferMetaClass("Recommendation", (KInferAlg)new RecommendationAlg());
        recommendationSystem.addDependency("user", metaClassUser.index());
        recommendationSystem.addDependency("product", metaClassProduct.index());
        recommendationSystem.addOutput("rating", KPrimitiveTypes.DOUBLE);
        return metaModel;
    }

    @Test
    public void recTest() {
        KMetaModel mm = this.createMetaModel();
        final KModel model = mm.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect(new KCallback(){

            public void on(Object o) {
                KObject user = model.createByName("User", 0L, 0L);
                KObjectInfer recommendation = (KObjectInfer)model.createByName("Recommendation", 0L, 0L);
                KObject user1 = model.createByName("User", 0L, 0L);
                long uid = user1.uuid();
                KObject product1 = model.createByName("Product", 0L, 0L);
                long pid = product1.uuid();
            }
        });
    }
}

