/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.memory.chunk;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KModel;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.memory.chunk.KObjectChunk;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.memory.manager.internal.KInternalDataManager;
import org.kevoree.modeling.meta.KMetaClass;
import org.kevoree.modeling.meta.KMetaModel;
import org.kevoree.modeling.meta.KPrimitiveTypes;
import org.kevoree.modeling.meta.impl.MetaModel;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public abstract class BaseKObjectChunkTest {
    public abstract KObjectChunk createKObjectChunk();

    public abstract KInternalDataManager createKInternalDataManger();

    @Test
    public void attributeTest() {
        MetaModel dynamicMetaModel = new MetaModel("MyMetaModel");
        final KMetaClass sensorMetaClass = dynamicMetaModel.addMetaClass("Sensor");
        sensorMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        sensorMetaClass.addAttribute("value", KPrimitiveTypes.DOUBLE);
        sensorMetaClass.addRelation("siblings", sensorMetaClass, null);
        KMetaClass homeMetaClass = dynamicMetaModel.addMetaClass("Home");
        homeMetaClass.addAttribute("attr_long", KPrimitiveTypes.LONG);
        homeMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        homeMetaClass.addRelation("sensors", sensorMetaClass, null);
        final KModel model = dynamicMetaModel.createModel(this.createKInternalDataManger());
        model.connect((KCallback)new KCallback<Throwable>((KMetaModel)dynamicMetaModel, homeMetaClass){
            final /* synthetic */ KMetaModel val$dynamicMetaModel;
            final /* synthetic */ KMetaClass val$homeMetaClass;
            {
                this.val$dynamicMetaModel = kMetaModel;
                this.val$homeMetaClass = kMetaClass2;
            }

            public void on(Throwable throwable) {
                KObject home = model.universe(0L).time(0L).create(model.metaModel().metaClassByName("Home"));
                home.set(home.metaClass().attribute("name"), (Object)"MainHome");
                KObject sensor = model.universe(0L).time(0L).create(sensorMetaClass);
                sensor.set(sensor.metaClass().attribute("name"), (Object)"Sensor#1");
                KObject sensor2 = model.universe(0L).time(0L).create(sensorMetaClass);
                sensor2.set(sensor.metaClass().attribute("name"), (Object)"Sensor#2");
                home.addByName("sensors", sensor);
                KObjectChunk objectChunk = BaseKObjectChunkTest.this.createKObjectChunk();
                objectChunk.init(null, this.val$dynamicMetaModel, this.val$homeMetaClass.index());
                objectChunk.setPrimitiveType(this.val$homeMetaClass.attribute("attr_long").index(), (Object)10L, this.val$homeMetaClass);
                long attr = (Long)objectChunk.getPrimitiveType(this.val$homeMetaClass.attribute("attr_long").index(), this.val$homeMetaClass);
                Assert.assertEquals((long)10L, (long)attr);
                objectChunk.setPrimitiveType(this.val$homeMetaClass.attribute("name").index(), (Object)"test", this.val$homeMetaClass);
                String name = (String)objectChunk.getPrimitiveType(this.val$homeMetaClass.attribute("name").index(), this.val$homeMetaClass);
                Assert.assertEquals((Object)"test", (Object)name);
                objectChunk.addLongToArray(this.val$homeMetaClass.reference("sensors").index(), sensor.uuid(), this.val$homeMetaClass);
                objectChunk.addLongToArray(this.val$homeMetaClass.reference("sensors").index(), sensor2.uuid(), this.val$homeMetaClass);
                long[] ref = objectChunk.getLongArray(this.val$homeMetaClass.reference("sensors").index(), this.val$homeMetaClass);
                Assert.assertArrayEquals((long[])ref, (long[])new long[]{sensor.uuid(), sensor2.uuid()});
                objectChunk.removeLongToArray(this.val$homeMetaClass.reference("sensors").index(), sensor.uuid(), this.val$homeMetaClass);
                long[] ref2 = objectChunk.getLongArray(this.val$homeMetaClass.reference("sensors").index(), this.val$homeMetaClass);
                Assert.assertArrayEquals((long[])ref2, (long[])new long[]{sensor2.uuid()});
                objectChunk.removeLongToArray(this.val$homeMetaClass.reference("sensors").index(), sensor2.uuid(), this.val$homeMetaClass);
                long[] ref3 = objectChunk.getLongArray(this.val$homeMetaClass.reference("sensors").index(), this.val$homeMetaClass);
                Assert.assertArrayEquals((long[])ref3, null);
                objectChunk.free(this.val$dynamicMetaModel);
            }
        });
    }

    @Test
    public void referenceTest() {
        MetaModel dynamicMetaModel = new MetaModel("MyMetaModel");
        final KMetaClass sensorMetaClass = dynamicMetaModel.addMetaClass("Sensor");
        sensorMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        sensorMetaClass.addAttribute("value", KPrimitiveTypes.DOUBLE);
        sensorMetaClass.addRelation("siblings", sensorMetaClass, null);
        KMetaClass homeMetaClass = dynamicMetaModel.addMetaClass("Home");
        homeMetaClass.addAttribute("attr_long", KPrimitiveTypes.LONG);
        homeMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        homeMetaClass.addRelation("sensors", sensorMetaClass, null);
        final KModel model = dynamicMetaModel.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect((KCallback)new KCallback<Throwable>((KMetaModel)dynamicMetaModel, homeMetaClass){
            final /* synthetic */ KMetaModel val$dynamicMetaModel;
            final /* synthetic */ KMetaClass val$homeMetaClass;
            {
                this.val$dynamicMetaModel = kMetaModel;
                this.val$homeMetaClass = kMetaClass2;
            }

            public void on(Throwable throwable) {
                KObject home = model.universe(0L).time(0L).create(model.metaModel().metaClassByName("Home"));
                home.set(home.metaClass().attribute("name"), (Object)"MainHome");
                KObject sensor = model.universe(0L).time(0L).create(sensorMetaClass);
                sensor.set(sensor.metaClass().attribute("name"), (Object)"Sensor#1");
                KObject sensor2 = model.universe(0L).time(0L).create(sensorMetaClass);
                sensor2.set(sensor.metaClass().attribute("name"), (Object)"Sensor#2");
                home.addByName("sensors", sensor);
                KObjectChunk objectChunk = BaseKObjectChunkTest.this.createKObjectChunk();
                objectChunk.init(null, this.val$dynamicMetaModel, this.val$homeMetaClass.index());
                objectChunk.setPrimitiveType(this.val$homeMetaClass.attribute("attr_long").index(), (Object)10L, this.val$homeMetaClass);
                objectChunk.setPrimitiveType(this.val$homeMetaClass.attribute("name").index(), (Object)"test", this.val$homeMetaClass);
                objectChunk.addLongToArray(this.val$homeMetaClass.reference("sensors").index(), sensor.uuid(), this.val$homeMetaClass);
                objectChunk.addLongToArray(this.val$homeMetaClass.reference("sensors").index(), sensor2.uuid(), this.val$homeMetaClass);
                long[] ref = objectChunk.getLongArray(this.val$homeMetaClass.reference("sensors").index(), this.val$homeMetaClass);
                Assert.assertArrayEquals((long[])ref, (long[])new long[]{sensor.uuid(), sensor2.uuid()});
                Assert.assertEquals((long)2L, (long)objectChunk.getLongArraySize(this.val$homeMetaClass.reference("sensors").index(), this.val$homeMetaClass));
                Assert.assertEquals((long)sensor.uuid(), (long)objectChunk.getLongArrayElem(this.val$homeMetaClass.reference("sensors").index(), 0, this.val$homeMetaClass));
                Assert.assertEquals((long)sensor2.uuid(), (long)objectChunk.getLongArrayElem(this.val$homeMetaClass.reference("sensors").index(), 1, this.val$homeMetaClass));
                objectChunk.removeLongToArray(this.val$homeMetaClass.reference("sensors").index(), sensor.uuid(), this.val$homeMetaClass);
                long[] ref2 = objectChunk.getLongArray(this.val$homeMetaClass.reference("sensors").index(), this.val$homeMetaClass);
                Assert.assertArrayEquals((long[])ref2, (long[])new long[]{sensor2.uuid()});
                Assert.assertEquals((long)1L, (long)objectChunk.getLongArraySize(this.val$homeMetaClass.reference("sensors").index(), this.val$homeMetaClass));
                objectChunk.removeLongToArray(this.val$homeMetaClass.reference("sensors").index(), sensor2.uuid(), this.val$homeMetaClass);
                long[] ref3 = objectChunk.getLongArray(this.val$homeMetaClass.reference("sensors").index(), this.val$homeMetaClass);
                Assert.assertArrayEquals((long[])ref3, null);
                objectChunk.free(this.val$dynamicMetaModel);
            }
        });
    }

    @Test
    public void cloneTest() {
        MetaModel dynamicMetaModel = new MetaModel("MyMetaModel");
        final KMetaClass sensorMetaClass = dynamicMetaModel.addMetaClass("Sensor");
        sensorMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        sensorMetaClass.addAttribute("value", KPrimitiveTypes.DOUBLE);
        sensorMetaClass.addRelation("siblings", sensorMetaClass, null);
        KMetaClass homeMetaClass = dynamicMetaModel.addMetaClass("Home");
        homeMetaClass.addAttribute("attr_long", KPrimitiveTypes.LONG);
        homeMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        homeMetaClass.addRelation("sensors", sensorMetaClass, null);
        final KModel model = dynamicMetaModel.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect((KCallback)new KCallback<Throwable>((KMetaModel)dynamicMetaModel, homeMetaClass){
            final /* synthetic */ KMetaModel val$dynamicMetaModel;
            final /* synthetic */ KMetaClass val$homeMetaClass;
            {
                this.val$dynamicMetaModel = kMetaModel;
                this.val$homeMetaClass = kMetaClass2;
            }

            public void on(Throwable throwable) {
                KObject home = model.universe(0L).time(0L).create(model.metaModel().metaClassByName("Home"));
                home.set(home.metaClass().attribute("name"), (Object)"MainHome");
                KObject sensor = model.universe(0L).time(0L).create(sensorMetaClass);
                sensor.set(sensor.metaClass().attribute("name"), (Object)"Sensor#1");
                KObject sensor2 = model.universe(0L).time(0L).create(sensorMetaClass);
                sensor2.set(sensor.metaClass().attribute("name"), (Object)"Sensor#2");
                home.addByName("sensors", sensor);
                KObjectChunk objectChunk = BaseKObjectChunkTest.this.createKObjectChunk();
                objectChunk.init(null, this.val$dynamicMetaModel, this.val$homeMetaClass.index());
                objectChunk.setPrimitiveType(this.val$homeMetaClass.attribute("attr_long").index(), (Object)10L, this.val$homeMetaClass);
                objectChunk.setPrimitiveType(this.val$homeMetaClass.attribute("name").index(), (Object)"test", this.val$homeMetaClass);
                objectChunk.addLongToArray(this.val$homeMetaClass.reference("sensors").index(), sensor.uuid(), this.val$homeMetaClass);
                objectChunk.addLongToArray(this.val$homeMetaClass.reference("sensors").index(), sensor2.uuid(), this.val$homeMetaClass);
                KObjectChunk clonedChunk = objectChunk.clone(-1L, -1L, -1L, this.val$dynamicMetaModel);
                Assert.assertEquals((Object)objectChunk.getPrimitiveType(this.val$homeMetaClass.attribute("attr_long").index(), this.val$homeMetaClass), (Object)clonedChunk.getPrimitiveType(this.val$homeMetaClass.attribute("attr_long").index(), this.val$homeMetaClass));
                Assert.assertEquals((Object)objectChunk.getPrimitiveType(this.val$homeMetaClass.attribute("name").index(), this.val$homeMetaClass), (Object)clonedChunk.getPrimitiveType(this.val$homeMetaClass.attribute("name").index(), this.val$homeMetaClass));
                Assert.assertArrayEquals((long[])objectChunk.getLongArray(this.val$homeMetaClass.reference("sensors").index(), this.val$homeMetaClass), (long[])clonedChunk.getLongArray(this.val$homeMetaClass.reference("sensors").index(), this.val$homeMetaClass));
                Assert.assertTrue(((clonedChunk.getFlags() & 1L) == 1L ? 1 : 0) != 0);
                clonedChunk.free(this.val$dynamicMetaModel);
            }
        });
    }

    @Test
    public void freeMemoryTest() {
        MetaModel dynamicMetaModel = new MetaModel("MyMetaModel");
        final KMetaClass sensorMetaClass = dynamicMetaModel.addMetaClass("Sensor");
        sensorMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        sensorMetaClass.addAttribute("value", KPrimitiveTypes.DOUBLE);
        sensorMetaClass.addRelation("siblings", sensorMetaClass, null);
        KMetaClass homeMetaClass = dynamicMetaModel.addMetaClass("Home");
        homeMetaClass.addAttribute("attr_long", KPrimitiveTypes.LONG);
        homeMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        homeMetaClass.addRelation("sensors", sensorMetaClass, null);
        final KModel model = dynamicMetaModel.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect((KCallback)new KCallback<Throwable>((KMetaModel)dynamicMetaModel, homeMetaClass){
            final /* synthetic */ KMetaModel val$dynamicMetaModel;
            final /* synthetic */ KMetaClass val$homeMetaClass;
            {
                this.val$dynamicMetaModel = kMetaModel;
                this.val$homeMetaClass = kMetaClass2;
            }

            public void on(Throwable throwable) {
                KObject home = model.universe(0L).time(0L).create(model.metaModel().metaClassByName("Home"));
                home.set(home.metaClass().attribute("name"), (Object)"MainHome");
                KObject sensor = model.universe(0L).time(0L).create(sensorMetaClass);
                sensor.set(sensor.metaClass().attribute("name"), (Object)"Sensor#1");
                KObject sensor2 = model.universe(0L).time(0L).create(sensorMetaClass);
                sensor2.set(sensor.metaClass().attribute("name"), (Object)"Sensor#2");
                home.addByName("sensors", sensor);
                KObjectChunk objectChunkEntry = BaseKObjectChunkTest.this.createKObjectChunk();
                objectChunkEntry.init(null, this.val$dynamicMetaModel, this.val$homeMetaClass.index());
                objectChunkEntry.setPrimitiveType(this.val$homeMetaClass.attribute("attr_long").index(), (Object)10L, this.val$homeMetaClass);
                objectChunkEntry.setPrimitiveType(this.val$homeMetaClass.attribute("name").index(), (Object)"test", this.val$homeMetaClass);
                objectChunkEntry.addLongToArray(this.val$homeMetaClass.reference("sensors").index(), sensor.uuid(), this.val$homeMetaClass);
                objectChunkEntry.addLongToArray(this.val$homeMetaClass.reference("sensors").index(), sensor2.uuid(), this.val$homeMetaClass);
                ArrayList<KObjectChunk> chunks = new ArrayList<KObjectChunk>();
                for (int i = 0; i < 50; ++i) {
                    chunks.add(objectChunkEntry.clone(-1L, -1L, -1L, this.val$dynamicMetaModel));
                }
                KObjectChunk[] loopChunks = chunks.toArray(new KObjectChunk[chunks.size()]);
                for (int i = 0; i < loopChunks.length; ++i) {
                    loopChunks[i].free(this.val$dynamicMetaModel);
                }
                objectChunkEntry.free(this.val$dynamicMetaModel);
            }
        });
    }

    @Test
    public void modifiedIndexesTest() {
        MetaModel dynamicMetaModel = new MetaModel("MyMetaModel");
        final KMetaClass sensorMetaClass = dynamicMetaModel.addMetaClass("Sensor");
        sensorMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        sensorMetaClass.addAttribute("value", KPrimitiveTypes.DOUBLE);
        sensorMetaClass.addRelation("siblings", sensorMetaClass, null);
        KMetaClass homeMetaClass = dynamicMetaModel.addMetaClass("Home");
        homeMetaClass.addAttribute("attr_long", KPrimitiveTypes.LONG);
        homeMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        homeMetaClass.addRelation("sensors", sensorMetaClass, null);
        final KModel model = dynamicMetaModel.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect((KCallback)new KCallback<Throwable>((KMetaModel)dynamicMetaModel, homeMetaClass){
            final /* synthetic */ KMetaModel val$dynamicMetaModel;
            final /* synthetic */ KMetaClass val$homeMetaClass;
            {
                this.val$dynamicMetaModel = kMetaModel;
                this.val$homeMetaClass = kMetaClass2;
            }

            public void on(Throwable throwable) {
                KObject home = model.universe(0L).time(0L).create(model.metaModel().metaClassByName("Home"));
                home.set(home.metaClass().attribute("name"), (Object)"MainHome");
                KObject sensor = model.universe(0L).time(0L).create(sensorMetaClass);
                sensor.set(sensor.metaClass().attribute("name"), (Object)"Sensor#1");
                KObject sensor2 = model.universe(0L).time(0L).create(sensorMetaClass);
                sensor2.set(sensor.metaClass().attribute("name"), (Object)"Sensor#2");
                home.addByName("sensors", sensor);
                KObjectChunk objectChunk = BaseKObjectChunkTest.this.createKObjectChunk();
                objectChunk.init(null, this.val$dynamicMetaModel, this.val$homeMetaClass.index());
                Assert.assertFalse(((objectChunk.getFlags() & 1L) == 1L ? 1 : 0) != 0);
                objectChunk.setPrimitiveType(this.val$homeMetaClass.attribute("attr_long").index(), (Object)10L, this.val$homeMetaClass);
                long attr = (Long)objectChunk.getPrimitiveType(this.val$homeMetaClass.attribute("attr_long").index(), this.val$homeMetaClass);
                Assert.assertEquals((long)10L, (long)attr);
                Assert.assertTrue(((objectChunk.getFlags() & 1L) == 1L ? 1 : 0) != 0);
                objectChunk.setPrimitiveType(this.val$homeMetaClass.attribute("name").index(), (Object)"test", this.val$homeMetaClass);
                String name = (String)objectChunk.getPrimitiveType(this.val$homeMetaClass.attribute("name").index(), this.val$homeMetaClass);
                Assert.assertEquals((Object)"test", (Object)name);
                objectChunk.free(this.val$dynamicMetaModel);
            }
        });
    }

    @Test
    public void inferTest() {
        MetaModel dynamicMetaModel = new MetaModel("MyMetaModel");
        final KMetaClass sensorMetaClass = dynamicMetaModel.addMetaClass("Sensor");
        sensorMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        sensorMetaClass.addAttribute("value", KPrimitiveTypes.CONTINUOUS);
        sensorMetaClass.addRelation("siblings", sensorMetaClass, null);
        final KModel model = dynamicMetaModel.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect((KCallback)new KCallback<Throwable>((KMetaModel)dynamicMetaModel){
            final /* synthetic */ KMetaModel val$dynamicMetaModel;
            {
                this.val$dynamicMetaModel = kMetaModel;
            }

            public void on(Throwable throwable) {
                KObject sensor = model.universe(0L).time(0L).create(sensorMetaClass);
                sensor.set(sensorMetaClass.attribute("name"), (Object)"Sensor#1");
                KObjectChunk objectChunkEntry = BaseKObjectChunkTest.this.createKObjectChunk();
                objectChunkEntry.init(null, this.val$dynamicMetaModel, sensorMetaClass.index());
                Assert.assertFalse(((objectChunkEntry.getFlags() & 1L) == 1L ? 1 : 0) != 0);
                double[] inferPayload0 = objectChunkEntry.getDoubleArray(sensorMetaClass.attribute("value").index(), sensorMetaClass);
                Assert.assertNull((Object)inferPayload0);
                objectChunkEntry.extendDoubleArray(sensorMetaClass.attribute("value").index(), 1, sensorMetaClass);
                Assert.assertTrue(((objectChunkEntry.getFlags() & 1L) == 1L ? 1 : 0) != 0);
                double[] inferPayload1 = objectChunkEntry.getDoubleArray(sensorMetaClass.attribute("value").index(), sensorMetaClass);
                Assert.assertNotNull((Object)inferPayload1);
                objectChunkEntry.setDoubleArrayElem(sensorMetaClass.attribute("value").index(), 0, 42.0, sensorMetaClass);
                double[] inferPayload2 = objectChunkEntry.getDoubleArray(sensorMetaClass.attribute("value").index(), sensorMetaClass);
                Assert.assertNotNull((Object)inferPayload2);
                Assert.assertEquals((long)1L, (long)objectChunkEntry.getDoubleArraySize(sensorMetaClass.attribute("value").index(), sensorMetaClass));
                Assert.assertTrue((inferPayload2[0] == 42.0 ? 1 : 0) != 0);
                objectChunkEntry.extendDoubleArray(sensorMetaClass.attribute("value").index(), 10, sensorMetaClass);
                double[] inferPayload3 = objectChunkEntry.getDoubleArray(sensorMetaClass.attribute("value").index(), sensorMetaClass);
                Assert.assertNotNull((Object)inferPayload3);
                Assert.assertTrue((inferPayload3[0] == 42.0 ? 1 : 0) != 0);
                objectChunkEntry.setDoubleArrayElem(sensorMetaClass.attribute("value").index(), 9, 52.0, sensorMetaClass);
                double[] inferPayload4 = objectChunkEntry.getDoubleArray(sensorMetaClass.attribute("value").index(), sensorMetaClass);
                Assert.assertTrue((inferPayload4[9] == 52.0 ? 1 : 0) != 0);
                Assert.assertTrue((inferPayload3[0] == 42.0 ? 1 : 0) != 0);
                KObjectChunk clone = objectChunkEntry.clone(-1L, -1L, -1L, this.val$dynamicMetaModel);
                double[] inferPayload5 = clone.getDoubleArray(sensorMetaClass.attribute("value").index(), sensorMetaClass);
                double[] inferPayload6 = clone.getDoubleArray(sensorMetaClass.attribute("value").index(), sensorMetaClass);
                Assert.assertTrue((inferPayload5[9] == 52.0 ? 1 : 0) != 0);
                Assert.assertTrue((inferPayload6[0] == 42.0 ? 1 : 0) != 0);
                objectChunkEntry.free(this.val$dynamicMetaModel);
                clone.free(this.val$dynamicMetaModel);
            }
        });
    }

    @Test
    public void serializationTest() {
        MetaModel dynamicMetaModel = new MetaModel("MyMetaModel");
        final KMetaClass sensorMetaClass = dynamicMetaModel.addMetaClass("Sensor");
        sensorMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        sensorMetaClass.addAttribute("value", KPrimitiveTypes.CONTINUOUS);
        sensorMetaClass.addRelation("siblings", sensorMetaClass, null);
        KMetaClass homeMetaClass = dynamicMetaModel.addMetaClass("Home");
        homeMetaClass.addAttribute("attr_long", KPrimitiveTypes.LONG);
        homeMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        homeMetaClass.addRelation("sensors", sensorMetaClass, null);
        homeMetaClass.addAttribute("value", KPrimitiveTypes.CONTINUOUS);
        final KModel model = dynamicMetaModel.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect((KCallback)new KCallback<Throwable>((KMetaModel)dynamicMetaModel, homeMetaClass){
            final /* synthetic */ KMetaModel val$dynamicMetaModel;
            final /* synthetic */ KMetaClass val$homeMetaClass;
            {
                this.val$dynamicMetaModel = kMetaModel;
                this.val$homeMetaClass = kMetaClass2;
            }

            public void on(Throwable throwable) {
                KObject home = model.universe(0L).time(0L).create(model.metaModel().metaClassByName("Home"));
                home.set(home.metaClass().attribute("name"), (Object)"MainHome");
                KObject sensor = model.universe(0L).time(0L).create(sensorMetaClass);
                sensor.set(sensor.metaClass().attribute("name"), (Object)"Sensor#1");
                KObject sensor2 = model.universe(0L).time(0L).create(sensorMetaClass);
                sensor2.set(sensor.metaClass().attribute("name"), (Object)"Sensor#2");
                home.addByName("sensors", sensor);
                KObjectChunk objectChunk = BaseKObjectChunkTest.this.createKObjectChunk();
                objectChunk.init(null, this.val$dynamicMetaModel, this.val$homeMetaClass.index());
                Assert.assertFalse(((objectChunk.getFlags() & 1L) == 1L ? 1 : 0) != 0);
                objectChunk.addLongToArray(this.val$homeMetaClass.reference("sensors").index(), sensor.uuid(), this.val$homeMetaClass);
                objectChunk.addLongToArray(this.val$homeMetaClass.reference("sensors").index(), sensor2.uuid(), this.val$homeMetaClass);
                objectChunk.setPrimitiveType(this.val$homeMetaClass.attribute("attr_long").index(), (Object)10L, this.val$homeMetaClass);
                long attr = (Long)objectChunk.getPrimitiveType(this.val$homeMetaClass.attribute("attr_long").index(), this.val$homeMetaClass);
                Assert.assertEquals((long)10L, (long)attr);
                Assert.assertEquals((long)objectChunk.getDoubleArraySize(this.val$homeMetaClass.attribute("value").index(), this.val$homeMetaClass), (long)0L);
                objectChunk.extendDoubleArray(this.val$homeMetaClass.attribute("value").index(), 3, this.val$homeMetaClass);
                Assert.assertTrue(((objectChunk.getFlags() & 1L) == 1L ? 1 : 0) != 0);
                objectChunk.setDoubleArrayElem(this.val$homeMetaClass.attribute("value").index(), 0, 0.1, this.val$homeMetaClass);
                objectChunk.setDoubleArrayElem(this.val$homeMetaClass.attribute("value").index(), 1, 1.1, this.val$homeMetaClass);
                objectChunk.setDoubleArrayElem(this.val$homeMetaClass.attribute("value").index(), 2, 2.1, this.val$homeMetaClass);
                Assert.assertEquals((Object)"YXR0cl9sb25n$U%c2Vuc29ycw$E$E$G%dmFsdWU$G$P7JmZmZmZma$P/BmZmZmZma$QAAzMzMzMzN", (Object)objectChunk.serialize(this.val$dynamicMetaModel));
                KObjectChunk newObjectChunk = BaseKObjectChunkTest.this.createKObjectChunk();
                try {
                    String serialized = objectChunk.serialize(this.val$dynamicMetaModel);
                    newObjectChunk.init(serialized, this.val$dynamicMetaModel, this.val$homeMetaClass.index());
                    String newSeriliazed = newObjectChunk.serialize(this.val$dynamicMetaModel);
                    Assert.assertEquals((Object)serialized, (Object)newSeriliazed);
                    Assert.assertEquals((Object)objectChunk.getPrimitiveType(this.val$homeMetaClass.attribute("attr_long").index(), this.val$homeMetaClass), (Object)newObjectChunk.getPrimitiveType(this.val$homeMetaClass.attribute("attr_long").index(), this.val$homeMetaClass));
                    Assert.assertArrayEquals((long[])objectChunk.getLongArray(this.val$homeMetaClass.reference("sensors").index(), this.val$homeMetaClass), (long[])newObjectChunk.getLongArray(this.val$homeMetaClass.reference("sensors").index(), this.val$homeMetaClass));
                    double[] originInfer = objectChunk.getDoubleArray(this.val$homeMetaClass.attribute("value").index(), this.val$homeMetaClass);
                    double[] newInfer = newObjectChunk.getDoubleArray(this.val$homeMetaClass.attribute("value").index(), this.val$homeMetaClass);
                    Assert.assertEquals((long)originInfer.length, (long)newInfer.length);
                    Assert.assertFalse(((newObjectChunk.getFlags() & 1L) == 1L ? 1 : 0) != 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                objectChunk.free(this.val$dynamicMetaModel);
                newObjectChunk.free(this.val$dynamicMetaModel);
            }
        });
    }
}

