/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.memory.manager;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KModel;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.defer.KDefer;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.meta.KMetaClass;
import org.kevoree.modeling.meta.KPrimitiveTypes;
import org.kevoree.modeling.meta.impl.MetaModel;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public class BaseKDataManagerTest {
    @Test
    public void temporalResolutionTest() {
        MetaModel metaModel = new MetaModel("Test");
        KMetaClass metaClassSensor = metaModel.addMetaClass("Sensor");
        metaClassSensor.addAttribute("name", KPrimitiveTypes.STRING);
        metaClassSensor.addAttribute("value", KPrimitiveTypes.DOUBLE);
        metaClassSensor.setTemporalResolution(10L);
        final KModel model = metaModel.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect(new KCallback(){

            public void on(Object o) {
                final KObject origin = model.createByName("Sensor", 0L, 0L);
                origin.setByName("name", (Object)"Sensor#1");
                KDefer defer = model.defer();
                for (int i = 0; i < 100; ++i) {
                    origin.jump((long)i, defer.waitResult());
                }
                defer.then((KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        for (int i = 0; i < 100; ++i) {
                            ((KObject)objects[i]).setByName("value", (Object)i);
                        }
                        origin.allTimes((KCallback)new KCallback<long[]>(){

                            public void on(final long[] times) {
                                Assert.assertEquals((long)times.length, (long)10L);
                                origin.manager().lookupAllTimes(origin.universe(), times, origin.uuid(), (KCallback)new KCallback<KObject[]>(){

                                    public void on(KObject[] kObjects) {
                                        for (int i = 0; i < kObjects.length; ++i) {
                                            long lastVal = times[i] + 9L;
                                            Assert.assertEquals((Object)("{\"universe\":0,\"time\":" + times[i] + ",\"uuid\":1,\"data\":{\"name\":\"Sensor#1\",\"value\":" + (double)lastVal + "}}"), (Object)kObjects[i].toJSON());
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }
}

