/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.memory.map;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.memory.chunk.KLongMap;
import org.kevoree.modeling.memory.chunk.KLongMapCallBack;
import org.kevoree.modeling.util.PrimitiveHelper;

public abstract class BaseKLongHashMapTest {
    private static final int SIZE = 100;

    public abstract KLongMap createKLongHashMap(int var1, float var2);

    @Test
    public void test() {
        long i;
        KLongMap map = this.createKLongHashMap(16, 0.75f);
        for (i = 0L; i < 100L; ++i) {
            map.put(i, (Object)("" + i));
        }
        Assert.assertEquals((long)map.size(), (long)100L);
        for (i = 0L; i < 100L; ++i) {
            Assert.assertEquals((long)i, (long)PrimitiveHelper.parseLong((String)((String)map.get(i))));
        }
        final int[] nbCall = new int[]{0};
        map.each((KLongMapCallBack)new KLongMapCallBack<String>(){

            public void on(long key, String s) {
                nbCall[0] = nbCall[0] + 1;
                Assert.assertEquals((long)key, (long)PrimitiveHelper.parseLong((String)s));
            }
        });
        Assert.assertEquals((long)nbCall[0], (long)100L);
        map.clear();
        Assert.assertEquals((long)map.size(), (long)0L);
    }
}

