/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.memory.map;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.memory.chunk.KLongLongMap;
import org.kevoree.modeling.memory.chunk.KLongLongMapCallBack;
import org.kevoree.modeling.meta.KMetaClass;
import org.kevoree.modeling.meta.KMetaModel;
import org.kevoree.modeling.meta.impl.MetaModel;

public abstract class BaseKLongLongMapTest {
    private static final int SIZE = 100;

    public abstract KLongLongMap createKLongLongMap();

    @Test
    public void test() {
        long i;
        KLongLongMap map = this.createKLongLongMap();
        MetaModel metaModel = new MetaModel("UniverseOrderMapTest");
        map.init(null, (KMetaModel)metaModel, -1);
        for (i = 0L; i < 100L; ++i) {
            map.put(i, i);
        }
        Assert.assertEquals((long)map.size(), (long)100L);
        for (i = 0L; i < 100L; ++i) {
            Assert.assertEquals((long)i, (long)map.get(i));
        }
        final int[] nbCall = new int[]{0};
        map.each(new KLongLongMapCallBack(){

            public void on(long key, long s) {
                nbCall[0] = nbCall[0] + 1;
                Assert.assertEquals((long)key, (long)s);
            }
        });
        Assert.assertEquals((long)nbCall[0], (long)100L);
        map.clear();
        Assert.assertEquals((long)map.size(), (long)0L);
    }

    @Test
    public void testLoadSave() throws Exception {
        MetaModel metaModel = new MetaModel("UniverseOrderMapTest");
        KMetaClass metaClass = metaModel.addMetaClass("org.kevoree.modeling.Hello");
        KLongLongMap map = this.createKLongLongMap();
        map.init(null, (KMetaModel)metaModel, metaClass.index());
        for (long i = 0L; i < 10L; ++i) {
            map.put(i, i);
        }
        Assert.assertEquals((long)map.size(), (long)10L);
        String saved = map.serialize((KMetaModel)metaModel);
        Assert.assertEquals((Object)"org.kevoree.modeling.Hello,U/A:A,C:C,E:E,G:G,I:I,K:K,M:M,O:O,Q:Q,S:S", (Object)saved);
        map.init(saved, (KMetaModel)metaModel, metaClass.index());
        saved = map.serialize((KMetaModel)metaModel);
        Assert.assertEquals((Object)"org.kevoree.modeling.Hello,U/A:A,C:C,E:E,G:G,I:I,K:K,M:M,O:O,Q:Q,S:S", (Object)saved);
        KLongLongMap map2 = this.createKLongLongMap();
        map2.init(saved, (KMetaModel)metaModel, -1);
        Assert.assertEquals((long)map2.size(), (long)10L);
        for (long i = 0L; i < 10L; ++i) {
            Assert.assertEquals((long)map.get(i), (long)i);
            Assert.assertEquals((long)map2.get(i), (long)i);
        }
        Assert.assertEquals((long)map.size(), (long)map2.size());
        Assert.assertEquals((long)map.metaClassIndex(), (long)map2.metaClassIndex());
        String saved2 = map2.serialize((KMetaModel)metaModel);
        Assert.assertEquals((Object)"org.kevoree.modeling.Hello,U/A:A,C:C,E:E,G:G,I:I,K:K,M:M,O:O,Q:Q,S:S", (Object)saved2);
        KLongLongMap nullClassName = this.createKLongLongMap();
        for (long i = 0L; i < 10L; ++i) {
            nullClassName.put(i, i);
        }
        String nullSaved = nullClassName.serialize((KMetaModel)metaModel);
        Assert.assertEquals((Object)"U/A:A,C:C,E:E,G:G,I:I,K:K,M:M,O:O,Q:Q,S:S", (Object)nullSaved);
        KLongLongMap mapNull2 = this.createKLongLongMap();
        mapNull2.init(nullSaved, (KMetaModel)metaModel, -1);
        String nullSaved2 = mapNull2.serialize((KMetaModel)metaModel);
        Assert.assertEquals((Object)"U/A:A,C:C,E:E,G:G,I:I,K:K,M:M,O:O,Q:Q,S:S", (Object)nullSaved2);
    }

    @Test
    public void testInitThenPut() {
        KLongLongMap map = this.createKLongLongMap();
        map.init(null, null, -1);
        map.put(0L, 0L);
        map.put(1L, 1L);
    }
}

