/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.memory.map;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.memory.chunk.KStringMap;
import org.kevoree.modeling.memory.chunk.KStringMapCallBack;
import org.kevoree.modeling.memory.map.RandomString;

public abstract class BaseKStringHashMapTest {
    public abstract KStringMap createKStringHashMap(int var1, float var2);

    @Test
    public void test() {
        RandomString randomString = new RandomString(10);
        final HashMap<String, String> origin = new HashMap<String, String>();
        KStringMap optimized = this.createKStringHashMap(16, 0.75f);
        int nbLoop = 100;
        for (int i = 0; i < nbLoop; ++i) {
            String newVal = randomString.nextString();
            origin.put(newVal, newVal);
            optimized.put(newVal, (Object)newVal);
        }
        Assert.assertEquals((long)nbLoop, (long)origin.keySet().size());
        Assert.assertEquals((long)nbLoop, (long)optimized.size());
        final int[] loopElem = new int[]{0};
        optimized.each((KStringMapCallBack)new KStringMapCallBack<String>(){

            public void on(String key, String value) {
                Assert.assertEquals((Object)key, (Object)value);
                String originVal = (String)origin.get(key);
                Assert.assertEquals((Object)key, (Object)originVal);
                loopElem[0] = loopElem[0] + 1;
            }
        });
        Assert.assertEquals((long)nbLoop, (long)loopElem[0]);
    }

    @Test
    public void emptyTest() {
        KStringMap optimized = this.createKStringHashMap(0, 0.75f);
        Assert.assertEquals((long)optimized.size(), (long)0L);
        Assert.assertTrue((!optimized.contains("randomKey") ? 1 : 0) != 0);
        Assert.assertNull((Object)optimized.get("randomKey"));
        optimized.put("randomKey", (Object)"randomVal");
        Assert.assertTrue((boolean)optimized.contains("randomKey"));
        Assert.assertNotNull((Object)optimized.get("randomKey"));
    }
}

