/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.memory.space;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KModel;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.defer.KDefer;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.memory.manager.KDataManager;
import org.kevoree.modeling.memory.manager.internal.KInternalDataManager;
import org.kevoree.modeling.meta.KMetaAttribute;
import org.kevoree.modeling.meta.KMetaClass;
import org.kevoree.modeling.meta.KPrimitiveTypes;
import org.kevoree.modeling.meta.impl.MetaModel;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.KTask;
import org.kevoree.modeling.scheduler.impl.AsyncScheduler;

public abstract class BaseKChunkSpaceCleanerTest {
    public abstract KDataManager createDataManager();

    @Test
    public void test() {
        MetaModel dynamicMetaModel = new MetaModel("MyMetaModel");
        final KMetaClass sensorMetaClass = dynamicMetaModel.addMetaClass("Sensor");
        final KDataManager manager = this.createDataManager();
        final KModel universe = dynamicMetaModel.createModel((KInternalDataManager)manager);
        universe.connect((KCallback)new KCallback<Throwable>(){

            public void on(Throwable throwable) {
                KObject sensor = universe.universe(0L).time(0L).create(sensorMetaClass);
                Assert.assertEquals((long)4L, (long)((KInternalDataManager)manager).spaceSize());
                final long sensorID = sensor.uuid();
                sensor = null;
                System.gc();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Assert.assertEquals((long)4L, (long)((KInternalDataManager)manager).spaceSize());
                manager.save((KCallback)new KCallback<Throwable>(){

                    public void on(Throwable throwable) {
                        Assert.assertEquals((long)0L, (long)((KInternalDataManager)manager).spaceSize());
                        universe.universe(0L).time(0L).lookup(sensorID, (KCallback)new KCallback<KObject>(){

                            public void on(KObject kObject) {
                                Assert.assertNotNull((Object)kObject);
                                Assert.assertEquals((long)4L, (long)((KInternalDataManager)manager).spaceSize());
                                kObject.jump(10L, (KCallback)new KCallback<KObject>(){

                                    public void on(KObject kObject2) {
                                        Assert.assertNotNull((Object)kObject2);
                                        Assert.assertEquals((long)4L, (long)((KInternalDataManager)manager).spaceSize());
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    @Test
    public void polyTest() {
        final CountDownLatch latch = new CountDownLatch(1);
        MetaModel dynamicMetaModel = new MetaModel("MyMetaModel");
        final KMetaClass sensorMetaClass = dynamicMetaModel.addMetaClass("Sensor");
        KMetaAttribute sensorMetaValue = sensorMetaClass.addAttribute("value", KPrimitiveTypes.CONTINUOUS);
        KMetaAttribute sensorMetaValue2 = sensorMetaClass.addAttribute("value2", KPrimitiveTypes.DOUBLE);
        final KModel model = dynamicMetaModel.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new AsyncScheduler()).build());
        model.connect((KCallback)new KCallback<Throwable>(){

            public void on(Throwable throwable) {
                KObject sensor = model.create(sensorMetaClass, 0L, 0L);
                long uuid = sensor.uuid();
                sensor = null;
                KDefer defer = model.defer();
                final Random random = new Random();
                for (int i = 0; i < 1000; ++i) {
                    final KCallback waiter = defer.waitResult();
                    model.lookup(0L, (long)i, uuid, (KCallback)new KCallback<KObject>(){

                        public void on(KObject jumpedSensor) {
                            try {
                                jumpedSensor.setByName("value2", (Object)random.nextDouble());
                                if (jumpedSensor.now() % 100L == 0L) {
                                    model.save(null);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            finally {
                                waiter.on(null);
                            }
                        }
                    });
                }
                System.gc();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                defer.then((KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        ((KInternalDataManager)model.manager()).scheduler().dispatch(new KTask(){

                            public void run() {
                                latch.countDown();
                            }
                        });
                    }
                });
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

