/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.memory.space;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.memory.chunk.KLongLongMap;
import org.kevoree.modeling.memory.chunk.KLongTree;
import org.kevoree.modeling.memory.chunk.KObjectChunk;
import org.kevoree.modeling.memory.space.KChunkSpace;

public abstract class BaseKChunkSpaceTest {
    public abstract KChunkSpace createKChunkSpace();

    @Test
    public void test() {
        KChunkSpace chunkSpace = this.createKChunkSpace();
        KLongLongMap map = (KLongLongMap)chunkSpace.create(0x1FFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, (short)3);
        map.put(0L, 0L);
        map.put(1L, 1L);
        KLongLongMap retrievedMap = (KLongLongMap)chunkSpace.get(0x1FFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL);
        Assert.assertEquals((long)0L, (long)retrievedMap.get(0L));
        Assert.assertEquals((long)1L, (long)retrievedMap.get(1L));
        Assert.assertEquals((long)map.size(), (long)retrievedMap.size());
        Assert.assertEquals((Object)((map.getFlags() & 1L) == 1L ? 1 : 0), (Object)((retrievedMap.getFlags() & 1L) == 1L ? 1 : 0));
        Assert.assertEquals((long)map.counter(), (long)retrievedMap.counter());
        KLongTree longTree = (KLongTree)chunkSpace.create(0L, 0x1FFFFFFFFFFFFFL, 0L, (short)2);
        longTree.init(null, null, -1);
        longTree.insertKey(0L);
        longTree.insertKey(1L);
        KLongTree retrievedLongTree = (KLongTree)chunkSpace.get(0L, 0x1FFFFFFFFFFFFFL, 0L);
        Assert.assertEquals((long)0L, (long)retrievedLongTree.lookup(0L));
        Assert.assertEquals((long)1L, (long)retrievedLongTree.lookup(1L));
        Assert.assertEquals((long)longTree.size(), (long)retrievedLongTree.size());
        Assert.assertEquals((Object)((longTree.getFlags() & 1L) == 1L ? 1 : 0), (Object)((retrievedLongTree.getFlags() & 1L) == 1L ? 1 : 0));
        Assert.assertEquals((long)longTree.counter(), (long)retrievedLongTree.counter());
        KObjectChunk chunk = (KObjectChunk)chunkSpace.create(0L, 0L, 0L, (short)0);
        KObjectChunk retrievedChunk = (KObjectChunk)chunkSpace.get(0L, 0L, 0L);
        Assert.assertNotNull((Object)retrievedChunk);
    }
}

