/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.memory.tree;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.memory.chunk.KLongLongTree;

public abstract class BaseKLongLongTreeTest {
    public abstract KLongLongTree createKLongLongTree();

    @Test
    public void saveLoad0() throws Exception {
        KLongLongTree tree = this.createKLongLongTree();
        tree.init(null, null, -1);
        for (long i = 0L; i <= 6L; ++i) {
            tree.insert(i, i);
        }
        KLongLongTree treeBis = this.createKLongLongTree();
        treeBis.init(tree.serialize(null), null, -1);
        Assert.assertEquals((long)tree.size(), (long)treeBis.size());
    }

    @Test
    public void saveLoad() throws Exception {
        KLongLongTree tree = this.createKLongLongTree();
        tree.init(null, null, -1);
        for (long i = 0L; i <= 6L; ++i) {
            tree.insert(i, i);
        }
        KLongLongTree treeBis = this.createKLongLongTree();
        treeBis.init(tree.serialize(null), null, -1);
        Assert.assertEquals((long)tree.size(), (long)treeBis.size());
        for (int i = 0; i < tree.size(); ++i) {
            Long resolved = tree.lookupValue((long)i);
            Long resolvedBis = treeBis.lookupValue((long)i);
            Assert.assertEquals((Object)resolved, (Object)resolvedBis);
        }
    }

    @Test
    public void cacheEffectTest() {
        KLongLongTree tree = this.createKLongLongTree();
        tree.init(null, null, -1);
        for (long i = 0L; i <= 6L; ++i) {
            tree.insert(i, i);
        }
        Assert.assertTrue((tree.previousOrEqualValue(-1L) == 0x1FFFFFFFFFFFFFL ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqualValue(0L) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqualValue(1L) == 1L ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqualValue(0L) == 0L ? 1 : 0) != 0);
        tree.insert(7L, 7L);
        Assert.assertTrue((tree.previousOrEqualValue(7L) == 7L ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqualValue(7L) == 7L ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqualValue(8L) == 7L ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqualValue(9L) == 7L ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqualValue(10L) == 7L ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqualValue(7L) == 7L ? 1 : 0) != 0);
    }
}

