/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.memory.tree;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.memory.chunk.KLongTree;
import org.kevoree.modeling.memory.chunk.KTreeWalker;
import org.kevoree.modeling.memory.tree.MutableInteger;

public abstract class BaseKLongTreeTest {
    private static final int RANGE_TEST_SIZE = 100;

    public abstract KLongTree createKLongTree();

    @Test
    public void saveLoad0() throws Exception {
        KLongTree tree = this.createKLongTree();
        tree.init(null, null, -1);
        for (long i = 0L; i <= 100000L; ++i) {
            tree.insertKey(i);
        }
        KLongTree treeBis = this.createKLongTree();
        treeBis.init(tree.serialize(null), null, -1);
        Assert.assertEquals((long)tree.size(), (long)treeBis.size());
    }

    @Test
    public void saveLoad() throws Exception {
        KLongTree tree = this.createKLongTree();
        tree.init(null, null, -1);
        for (long i = 0L; i <= 2L; ++i) {
            tree.insertKey(i);
        }
        String saved0 = tree.serialize(null);
        Assert.assertEquals((Object)"G,C{A,C]C,}E,C", (Object)saved0);
        KLongTree treeBis = this.createKLongTree();
        treeBis.init(saved0, null, -1);
        Assert.assertEquals((Object)saved0, (Object)treeBis.serialize(null));
        Assert.assertEquals((long)tree.size(), (long)treeBis.size());
        for (int i = 0; i < tree.size(); ++i) {
            Long resolved = tree.lookup((long)i);
            Long resolvedBis = treeBis.lookup((long)i);
            Assert.assertEquals((Object)resolved, (Object)resolvedBis);
        }
    }

    @Test
    public void printTest() {
        long MIN = 0L;
        long MAX = 99L;
        for (long j = MIN; j <= MAX; ++j) {
            KLongTree tree = this.createKLongTree();
            tree.init(null, null, -1);
            for (long i = MIN; i <= j; ++i) {
                if (i % 3L == 0L) {
                    tree.insertKey(i);
                    continue;
                }
                tree.insertKey(i);
            }
        }
    }

    @Test
    public void previousOrEqualTest() {
        KLongTree tree = this.createKLongTree();
        tree.init(null, null, -1);
        for (long i = 0L; i <= 6L; ++i) {
            tree.insertKey(i);
        }
        tree.insertKey(8L);
        tree.insertKey(10L);
        tree.insertKey(11L);
        tree.insertKey(13L);
        Assert.assertEquals((long)tree.previousOrEqual(-1L), (long)0x1FFFFFFFFFFFFFL);
        Assert.assertEquals((long)tree.previousOrEqual(0L), (long)0L);
        Assert.assertEquals((long)tree.previousOrEqual(1L), (long)1L);
        Assert.assertEquals((long)tree.previousOrEqual(7L), (long)6L);
        Assert.assertEquals((long)tree.previousOrEqual(8L), (long)8L);
        Assert.assertEquals((long)tree.previousOrEqual(9L), (long)8L);
        Assert.assertEquals((long)tree.previousOrEqual(10L), (long)10L);
        Assert.assertEquals((long)tree.previousOrEqual(13L), (long)13L);
        Assert.assertEquals((long)tree.previousOrEqual(14L), (long)13L);
    }

    @Test
    public void cacheEffectTest() {
        KLongTree tree = this.createKLongTree();
        tree.init(null, null, -1);
        for (long i = 0L; i <= 6L; ++i) {
            tree.insertKey(i);
        }
        Assert.assertTrue((tree.previousOrEqual(-1L) == 0x1FFFFFFFFFFFFFL ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqual(0L) == 0L ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqual(1L) == 1L ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqual(0L) == 0L ? 1 : 0) != 0);
        tree.insertKey(7L);
        Assert.assertTrue((tree.previousOrEqual(7L) == 7L ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqual(7L) == 7L ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqual(8L) == 7L ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqual(9L) == 7L ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqual(10L) == 7L ? 1 : 0) != 0);
        Assert.assertTrue((tree.previousOrEqual(7L) == 7L ? 1 : 0) != 0);
    }

    @Test
    public void rangeTest() {
        KLongTree tree = this.createKLongTree();
        tree.init(null, null, -1);
        for (int i = 0; i < 100; ++i) {
            tree.insertKey((long)i);
        }
        final MutableInteger integer = new MutableInteger();
        integer.set(0);
        tree.range(0L, 100L, new KTreeWalker(){

            public void elem(long t) {
                integer.increment();
            }
        });
        Assert.assertEquals((long)100L, (long)integer.get());
        integer.set(0);
        tree.range(0L, 20L, new KTreeWalker(){

            public void elem(long t) {
                integer.increment();
            }
        });
        Assert.assertEquals((long)21L, (long)integer.get());
        integer.set(0);
        tree.range(20L, 20L, new KTreeWalker(){

            public void elem(long t) {
                integer.increment();
            }
        });
        Assert.assertEquals((long)1L, (long)integer.get());
        integer.set(0);
        tree.range(20L, 79L, new KTreeWalker(){

            public void elem(long t) {
                integer.increment();
            }
        });
        Assert.assertEquals((long)60L, (long)integer.get());
        integer.set(0);
        tree.range(80L, 100L, new KTreeWalker(){

            public void elem(long t) {
                integer.increment();
            }
        });
        Assert.assertEquals((long)20L, (long)integer.get());
        integer.set(0);
        tree.range(80L, 150L, new KTreeWalker(){

            public void elem(long t) {
                integer.increment();
            }
        });
        Assert.assertEquals((long)20L, (long)integer.get());
        integer.set(0);
        tree.range(-50L, 99L, new KTreeWalker(){

            public void elem(long t) {
                integer.increment();
            }
        });
        Assert.assertEquals((long)100L, (long)integer.get());
        integer.set(0);
        tree.range(-50L, 150L, new KTreeWalker(){

            public void elem(long t) {
                integer.increment();
            }
        });
        Assert.assertEquals((long)100L, (long)integer.get());
    }
}

