/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.traversal;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.cloudmodel.CloudModel;
import org.kevoree.modeling.cloudmodel.CloudUniverse;
import org.kevoree.modeling.cloudmodel.CloudView;
import org.kevoree.modeling.cloudmodel.Node;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public class BasicSelectTest {
    @Test
    public void rootSelectTest() throws Exception {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                CloudView t0 = (CloudView)dimension0.time(0L);
                Node node = t0.createNode();
                node.setName("n0");
                CloudView t1 = (CloudView)dimension0.time(1L);
            }
        });
    }

    @Test
    public void selectTest() throws Exception {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                CloudView t0 = (CloudView)dimension0.time(0L);
                Node node = t0.createNode();
                node.setName("n0");
                final Node node2 = t0.createNode();
                node2.setName("n1");
                node.addChildren(node2);
                final Node node3 = t0.createNode();
                node3.setName("n2");
                node2.addChildren(node3);
                Node node4 = t0.createNode();
                node4.setName("n4");
                node3.addChildren(node4);
                Node node5 = t0.createNode();
                node5.setName("n5");
                node3.addChildren(node5);
                node.select("children[]", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] selecteds) {
                        Assert.assertEquals((long)1L, (long)selecteds.length);
                        Assert.assertEquals((Object)node2, (Object)selecteds[0]);
                    }
                });
                node.select("children[name=*]", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] selecteds) {
                        Assert.assertEquals((long)1L, (long)selecteds.length);
                        Assert.assertEquals((Object)node2, (Object)selecteds[0]);
                    }
                });
                node.select("children[name=n*]", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] selecteds) {
                        Assert.assertEquals((long)1L, (long)selecteds.length);
                        Assert.assertEquals((Object)node2, (Object)selecteds[0]);
                    }
                });
                node.select("children[name=n1]", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] selecteds) {
                        Assert.assertEquals((long)1L, (long)selecteds.length);
                        Assert.assertEquals((Object)node2, (Object)selecteds[0]);
                    }
                });
                node.select("children[name=!n1]", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] selecteds) {
                        Assert.assertEquals((long)0L, (long)selecteds.length);
                    }
                });
                node.select("children[name!=n1]", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] selecteds) {
                        Assert.assertEquals((long)0L, (long)selecteds.length);
                    }
                });
                node.select("children[name=n1]|children[name=n2]", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] selecteds) {
                        Assert.assertEquals((long)1L, (long)selecteds.length);
                        Assert.assertEquals((Object)node3, (Object)selecteds[0]);
                    }
                });
                node.select("children[name=n1]|children[name=n2]", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] selecteds) {
                        Assert.assertEquals((long)1L, (long)selecteds.length);
                        Assert.assertEquals((Object)node3, (Object)selecteds[0]);
                    }
                });
                node.select("children[name=n1]|children[name=n2]|children[name=*]", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] selecteds) {
                        Assert.assertEquals((long)2L, (long)selecteds.length);
                    }
                });
            }
        });
    }

    @Test
    public void selectTest2() throws Exception {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                CloudView t0 = (CloudView)dimension0.time(0L);
                Node n0 = t0.createNode();
                n0.setName("n0");
                n0.setValue("v0");
                Node n1 = t0.createNode();
                n1.setName("n1");
                n1.setValue("v1");
                n0.addChildren(n1);
                Node n2 = t0.createNode();
                n2.setName("n2");
                n2.setValue("v2");
                n0.addChildren(n2);
                n0.select("children[value=v2,name=n1]", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] selecteds) {
                        Assert.assertEquals((long)selecteds.length, (long)0L);
                    }
                });
                n0.select("children[value=v2,name=n2]", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] selecteds) {
                        Assert.assertEquals((long)selecteds.length, (long)1L);
                    }
                });
                n0.select("children[name=*]", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] selecteds) {
                        Assert.assertEquals((long)selecteds.length, (long)2L);
                    }
                });
            }
        });
    }
}

