/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.traversal;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KModel;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.meta.KMetaClass;
import org.kevoree.modeling.meta.KPrimitiveTypes;
import org.kevoree.modeling.meta.impl.MetaModel;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;

public class TraversalExpressionTest {
    @Test
    public void test() {
        MetaModel metaModel = new MetaModel("MyMetaModel");
        final KMetaClass sensorMetaClass = metaModel.addMetaClass("Sensor");
        sensorMetaClass.addAttribute("name", KPrimitiveTypes.STRING);
        sensorMetaClass.addAttribute("value", KPrimitiveTypes.DOUBLE);
        sensorMetaClass.addRelation("siblings", sensorMetaClass, null);
        final KModel universe = metaModel.createModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect((KCallback)new KCallback<Throwable>(){

            public void on(Throwable throwable) {
                KObject sensor = universe.universe(0L).time(0L).create(sensorMetaClass);
                sensor.setByName("name", (Object)"Sensor#1");
                sensor.setByName("value", (Object)"42");
                final int[] i = new int[]{0};
                sensor.traversal().eval("value/2", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        Assert.assertEquals((long)objects.length, (long)1L);
                        Assert.assertEquals((Object)objects[0], (Object)21.0);
                        i[0] = i[0] + 1;
                    }
                });
                sensor.select("=value/2", (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        Assert.assertEquals((long)objects.length, (long)1L);
                        Assert.assertEquals((Object)objects[0], (Object)21.0);
                        i[0] = i[0] + 1;
                    }
                });
                Assert.assertEquals((long)i[0], (long)2L);
            }
        });
    }
}

