/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.traversal;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.KCallback;
import org.kevoree.modeling.KObject;
import org.kevoree.modeling.cloudmodel.CloudModel;
import org.kevoree.modeling.cloudmodel.CloudUniverse;
import org.kevoree.modeling.cloudmodel.CloudView;
import org.kevoree.modeling.cloudmodel.Element;
import org.kevoree.modeling.cloudmodel.Node;
import org.kevoree.modeling.cloudmodel.meta.MetaNode;
import org.kevoree.modeling.memory.manager.DataManagerBuilder;
import org.kevoree.modeling.meta.KMetaRelation;
import org.kevoree.modeling.scheduler.KScheduler;
import org.kevoree.modeling.scheduler.impl.DirectScheduler;
import org.kevoree.modeling.traversal.KTraversalFilter;
import org.kevoree.modeling.util.PrimitiveHelper;

public class TraversalTest {
    @Test
    public void simpleTraversalTest() {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                CloudView t0 = (CloudView)dimension0.time(0L);
                Node node0 = t0.createNode();
                Element elem0_0 = t0.createElement();
                node0.addElement(elem0_0);
                Node node1 = t0.createNode();
                node1.setName("child1");
                Element elem1_0 = t0.createElement();
                node1.addElement(elem1_0);
                Node node2 = t0.createNode();
                node2.setName("child2");
                Element elem2_0 = t0.createElement();
                node2.addElement(elem2_0);
                node0.addChildren(node1);
                node0.addChildren(node2);
                node0.traversal().traverse((KMetaRelation)node0.metaClass().metaByName("children")).then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)kObjects.length, (long)2L);
                    }
                });
                node0.traversal().traverse((KMetaRelation)node0.metaClass().metaByName("children")).withAttribute(MetaNode.ATT_NAME, (Object)"child*").map(MetaNode.ATT_NAME, (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        Assert.assertEquals((long)objects.length, (long)2L);
                    }
                });
                node0.traversal().traverse((KMetaRelation)node0.metaClass().metaByName("children")).withAttribute(MetaNode.ATT_NAME, (Object)"child1").map(MetaNode.ATT_NAME, (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        Assert.assertEquals((long)objects.length, (long)1L);
                        Assert.assertEquals((Object)objects[0], (Object)"child1");
                    }
                });
                node0.traversal().traverse((KMetaRelation)node0.metaClass().metaByName("children")).withoutAttribute(MetaNode.ATT_NAME, (Object)"child1").map(MetaNode.ATT_NAME, (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        Assert.assertEquals((long)objects.length, (long)1L);
                        Assert.assertEquals((Object)objects[0], (Object)"child2");
                    }
                });
                node0.traversal().traverse((KMetaRelation)node0.metaClass().metaByName("children")).withAttribute(MetaNode.ATT_NAME, null).map(MetaNode.ATT_NAME, (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        Assert.assertEquals((long)objects.length, (long)0L);
                    }
                });
                node0.traversal().traverse((KMetaRelation)node0.metaClass().metaByName("children")).withAttribute(MetaNode.ATT_NAME, (Object)"*").map(MetaNode.ATT_NAME, (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        Assert.assertEquals((long)objects.length, (long)2L);
                    }
                });
                node0.traversal().traverse((KMetaRelation)node0.metaClass().metaByName("children")).withoutAttribute(MetaNode.ATT_NAME, null).map(MetaNode.ATT_NAME, (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        Assert.assertEquals((long)objects.length, (long)2L);
                    }
                });
                node0.traversal().traverse((KMetaRelation)node0.metaClass().metaByName("children")).withoutAttribute(MetaNode.ATT_NAME, (Object)"*").map(MetaNode.ATT_NAME, (KCallback)new KCallback<Object[]>(){

                    public void on(Object[] objects) {
                        Assert.assertEquals((long)objects.length, (long)0L);
                    }
                });
            }
        });
    }

    @Test
    public void chainedTraversalTest() {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                CloudView t0 = (CloudView)dimension0.time(0L);
                Node node0 = t0.createNode();
                Element elem0_0 = t0.createElement();
                node0.addElement(elem0_0);
                Node node1 = t0.createNode();
                node1.setName("child1");
                Element elem1_0 = t0.createElement();
                elem1_0.setName("child1_elem1");
                node1.addElement(elem1_0);
                Node node2 = t0.createNode();
                node2.setName("child2");
                Element elem2_0 = t0.createElement();
                elem2_0.setName("child2_elem1");
                node2.addElement(elem2_0);
                node0.addChildren(node1);
                node0.addChildren(node2);
                node0.traversal().traverse((KMetaRelation)node0.metaClass().metaByName("children")).traverse((KMetaRelation)node0.metaClass().metaByName("element")).then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)kObjects.length, (long)2L);
                    }
                });
            }
        });
    }

    @Test
    public void filterTest() {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                CloudView t0 = (CloudView)dimension0.time(0L);
                Node node0 = t0.createNode();
                Element elem0_0 = t0.createElement();
                node0.addElement(elem0_0);
                Node node1 = t0.createNode();
                node1.setName("child1");
                Element elem1_0 = t0.createElement();
                elem1_0.setName("child1_elem1");
                node1.addElement(elem1_0);
                Node node2 = t0.createNode();
                node2.setName("child2");
                Element elem2_0 = t0.createElement();
                elem2_0.setName("child2_elem1");
                node2.addElement(elem2_0);
                node0.addChildren(node1);
                node0.addChildren(node2);
                node0.traversal().traverse((KMetaRelation)node0.metaClass().metaByName("children")).filter(new KTraversalFilter(){

                    public boolean filter(KObject obj) {
                        return PrimitiveHelper.equals((String)((Node)obj).getName(), (String)"child1");
                    }
                }).then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)kObjects.length, (long)1L);
                        Assert.assertEquals((Object)((Node)kObjects[0]).getName(), (Object)"child1");
                    }
                });
            }
        });
    }

    @Test
    public void parentTest() {
        final CloudModel model = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        model.connect((KCallback)new KCallback<Throwable>(){

            public void on(Throwable throwable) {
                CloudUniverse universe = (CloudUniverse)model.newUniverse();
                CloudView t0 = (CloudView)universe.time(0L);
                Node node0 = t0.createNode();
                Element elem0_0 = t0.createElement();
                node0.addElement(elem0_0);
                Node node1 = t0.createNode();
                node1.setName("child1");
                Element elem1_0 = t0.createElement();
                elem1_0.setName("child1_elem1");
                node1.addElement(elem1_0);
                Node node2 = t0.createNode();
                node2.setName("child2");
                Element elem2_0 = t0.createElement();
                elem2_0.setName("child2_elem1");
                node2.addElement(elem2_0);
                node0.addChildren(node1);
                node0.addChildren(node2);
            }
        });
    }

    @Test
    public void traverseQueryTest() {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect((KCallback)new KCallback<Throwable>(){

            public void on(Throwable throwable) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                CloudView t0 = (CloudView)dimension0.time(0L);
                Node node0 = t0.createNode();
                Element elem0_0 = t0.createElement();
                node0.addElement(elem0_0);
                Node node1 = t0.createNode();
                node1.setName("child1");
                Element elem1_0 = t0.createElement();
                elem1_0.setName("child1_elem1");
                node1.addElement(elem1_0);
                Node node2 = t0.createNode();
                node2.setName("child2");
                Element elem2_0 = t0.createElement();
                elem2_0.setName("child2_elem1");
                node2.addElement(elem2_0);
                node0.addChildren(node1);
                node0.addChildren(node2);
                node0.traversal().traverseQuery("children").filter(new KTraversalFilter(){

                    public boolean filter(KObject obj) {
                        return PrimitiveHelper.equals((String)((Node)obj).getName(), (String)"child1");
                    }
                }).then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)kObjects.length, (long)1L);
                        Assert.assertEquals((Object)((Node)kObjects[0]).getName(), (Object)"child1");
                    }
                });
                node0.traversal().traverseQuery("child*").filter(new KTraversalFilter(){

                    public boolean filter(KObject obj) {
                        return PrimitiveHelper.equals((String)((Node)obj).getName(), (String)"child1");
                    }
                }).then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)kObjects.length, (long)1L);
                        Assert.assertEquals((Object)((Node)kObjects[0]).getName(), (Object)"child1");
                    }
                });
                node0.traversal().traverseQuery("*children").filter(new KTraversalFilter(){

                    public boolean filter(KObject obj) {
                        return PrimitiveHelper.equals((String)((Node)obj).getName(), (String)"child1");
                    }
                }).then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)kObjects.length, (long)1L);
                        Assert.assertEquals((Object)((Node)kObjects[0]).getName(), (Object)"child1");
                    }
                });
                node0.traversal().traverseQuery("cc,children").filter(new KTraversalFilter(){

                    public boolean filter(KObject obj) {
                        return PrimitiveHelper.equals((String)((Node)obj).getName(), (String)"child1");
                    }
                }).then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)kObjects.length, (long)1L);
                        Assert.assertEquals((Object)((Node)kObjects[0]).getName(), (Object)"child1");
                    }
                });
            }
        });
    }

    @Test
    public void attributeQueryTest() {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                CloudView t0 = (CloudView)dimension0.time(0L);
                Node node0 = t0.createNode();
                Element elem0_0 = t0.createElement();
                node0.addElement(elem0_0);
                Node node1 = t0.createNode();
                node1.setName("child1");
                Element elem1_0 = t0.createElement();
                node1.addElement(elem1_0);
                Node node2 = t0.createNode();
                node2.setName("child2");
                Element elem2_0 = t0.createElement();
                node2.addElement(elem2_0);
                node0.addChildren(node1);
                node0.addChildren(node2);
                node0.traversal().traverseQuery("children").attributeQuery("name=*").then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)2L, (long)kObjects.length);
                    }
                });
                node0.traversal().traverseQuery("children").attributeQuery("name=child1").then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)1L, (long)kObjects.length);
                        Assert.assertEquals((Object)"child1", (Object)kObjects[0].get(MetaNode.ATT_NAME));
                    }
                });
                node0.traversal().traverseQuery("children").attributeQuery("name=child*,value=null").then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)2L, (long)kObjects.length);
                    }
                });
                node0.traversal().traverseQuery("children").attributeQuery("name=child*,value!=null").then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)0L, (long)kObjects.length);
                    }
                });
                node0.traversal().traverseQuery("children").attributeQuery("name=child*,value=*").then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)2L, (long)kObjects.length);
                    }
                });
                Node node3 = t0.createNode();
                node3.setName("child3");
                node3.setValue("3");
                node0.addChildren(node3);
                node0.traversal().traverseQuery("children").attributeQuery("name=child*,value=*").then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)3L, (long)kObjects.length);
                    }
                });
                node0.traversal().traverseQuery("children").attributeQuery("name=child*,value=null").then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)2L, (long)kObjects.length);
                    }
                });
                node0.traversal().traverseQuery("children").attributeQuery("name=child*,value!=null").then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] kObjects) {
                        Assert.assertEquals((long)1L, (long)kObjects.length);
                    }
                });
            }
        });
    }

    @Test
    public void deepCollectorTest() {
        final CloudModel universe = new CloudModel(DataManagerBuilder.create().withScheduler((KScheduler)new DirectScheduler()).build());
        universe.connect(new KCallback(){

            public void on(Object o) {
                CloudUniverse dimension0 = (CloudUniverse)universe.newUniverse();
                CloudView t0 = (CloudView)dimension0.time(0L);
                Node node0 = t0.createNode();
                node0.setName("c0");
                Element elem0_0 = t0.createElement();
                elem0_0.setName("c0_e1");
                node0.addElement(elem0_0);
                Node node1 = t0.createNode();
                node1.setName("c1");
                Element elem1_0 = t0.createElement();
                elem1_0.setName("c1_e1");
                node1.addElement(elem1_0);
                Node node2 = t0.createNode();
                node2.setName("c2");
                Element elem2_0 = t0.createElement();
                elem2_0.setName("c2_e1");
                node2.addElement(elem2_0);
                node0.addChildren(node1);
                node0.addChildren(node2);
                Node node1_1 = t0.createNode();
                node1_1.setName("c1_1");
                node1.addChildren(node1_1);
                node0.traversal().collect(null, null).then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] collectedObjs) {
                        Assert.assertEquals((long)6L, (long)collectedObjs.length);
                    }
                });
                node0.traversal().collect(MetaNode.REF_CHILDREN, null).then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] collectedObjs) {
                        Assert.assertEquals((long)3L, (long)collectedObjs.length);
                    }
                });
                node0.traversal().collect(null, new KTraversalFilter(){

                    public boolean filter(KObject obj) {
                        return obj.get(MetaNode.ATT_NAME) == null || !PrimitiveHelper.equals((String)obj.get(MetaNode.ATT_NAME).toString(), (String)"c1");
                    }
                }).then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] collectedObjs) {
                        Assert.assertEquals((long)3L, (long)collectedObjs.length);
                    }
                });
                node0.traversal().collect(null, new KTraversalFilter(){

                    public boolean filter(KObject obj) {
                        return obj.get(MetaNode.ATT_NAME) == null || !PrimitiveHelper.equals((String)obj.get(MetaNode.ATT_NAME).toString(), (String)"c1_1");
                    }
                }).then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] collectedObjs) {
                        Assert.assertEquals((long)5L, (long)collectedObjs.length);
                    }
                });
                node0.traversal().collect(MetaNode.REF_CHILDREN, new KTraversalFilter(){

                    public boolean filter(KObject obj) {
                        return obj.get(MetaNode.ATT_NAME) == null || !PrimitiveHelper.equals((String)obj.get(MetaNode.ATT_NAME).toString(), (String)"c1_1");
                    }
                }).then((KCallback)new KCallback<KObject[]>(){

                    public void on(KObject[] collectedObjs) {
                        Assert.assertEquals((long)2L, (long)collectedObjs.length);
                    }
                });
            }
        });
    }
}

