/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.util.maths;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.util.Base64;
import org.kevoree.modeling.util.PrimitiveHelper;

public class Base64Test {
    @Test
    public void beginingOfTimeEncodingTest() {
        this.testLong(-9007199254740990L);
    }

    @Test
    public void endOfTimeEncodingTest() {
        this.testLong(0x1FFFFFFFFFFFFEL);
    }

    @Test
    public void nullEncodingTest() {
        this.testLong(0x1FFFFFFFFFFFFFL);
    }

    @Test
    public void zeroEncodingTest() {
        this.testLong(0L);
    }

    @Test
    public void oneEncodingTest() {
        this.testLong(1L);
    }

    @Test
    public void randomBigNumTest() {
        this.testLong(0x1000000001L);
    }

    private void testLong(long val) {
        String enc = Base64.encodeLong((long)val);
        long dec = Base64.decodeToLong((String)enc);
        Assert.assertEquals((long)val, (long)dec);
        StringBuilder buffer = new StringBuilder();
        Base64.encodeLongToBuffer((long)val, (StringBuilder)buffer);
        dec = Base64.decodeToLong((String)buffer.toString());
        Assert.assertEquals((long)val, (long)dec);
    }

    @Test
    public void minIntEncodingTest() {
        this.testInt(Integer.MIN_VALUE);
    }

    @Test
    public void maxIntEncodingTest() {
        this.testInt(Integer.MAX_VALUE);
    }

    private void testInt(int val) {
        String enc = Base64.encodeInt((int)val);
        int dec = Base64.decodeToInt((String)enc);
        Assert.assertEquals((long)val, (long)dec);
        StringBuilder buffer = new StringBuilder();
        Base64.encodeIntToBuffer((int)val, (StringBuilder)buffer);
        dec = Base64.decodeToInt((String)buffer.toString());
        Assert.assertEquals((long)val, (long)dec);
    }

    @Test
    public void maxDoubleEncodingTest() {
        this.testDouble(Double.MAX_VALUE);
    }

    @Test
    public void minDoubleEncodingTest() {
        this.testDouble(PrimitiveHelper.DOUBLE_MIN_VALUE());
    }

    @Test
    public void negMaxDoubleEncodingTest() {
        this.testDouble(-PrimitiveHelper.DOUBLE_MAX_VALUE());
    }

    @Test
    public void negMinDoubleEncodingTest() {
        this.testDouble(-PrimitiveHelper.DOUBLE_MIN_VALUE());
    }

    @Test
    public void zeroDoubleEncodingTest() {
        this.testDouble(0.0);
        this.testDouble(0.1);
        this.testDouble(0.25);
        this.testDouble(0.5);
        this.testDouble(0.75);
        this.testDouble(1.1);
        this.testDouble(2.1);
        this.testDouble(2.0E-15);
    }

    private void testDouble(double val) {
        String enc = Base64.encodeDouble((double)val);
        double dec = Base64.decodeToDouble((String)enc);
        Assert.assertEquals((double)val, (double)dec, (double)0.0);
        StringBuilder buffer = new StringBuilder();
        Base64.encodeDoubleToBuffer((double)val, (StringBuilder)buffer);
        dec = Base64.decodeToDouble((String)buffer.toString());
        Assert.assertEquals((double)val, (double)dec, (double)0.0);
    }

    @Test
    public void boolArrayEncodingTest() {
        for (int i = 0; i < 255; ++i) {
            boolean[] tmpArray = new boolean[i];
            for (int j = 0; j < i; ++j) {
                tmpArray[j] = Math.random() < 0.5;
            }
            this.boolArrayInnerTest(tmpArray);
        }
    }

    private void boolArrayInnerTest(boolean[] array) {
        String enc = Base64.encodeBoolArray((boolean[])array);
        boolean[] dec = Base64.decodeBoolArray((String)enc, (int)array.length);
        Assert.assertTrue((array.length == dec.length ? 1 : 0) != 0);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((Object)array[i], (Object)dec[i]);
        }
    }
}

