/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.util.maths.expression.impl;

import java.util.Calendar;
import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.util.PrimitiveHelper;
import org.kevoree.modeling.util.maths.expression.KMathExpressionEngine;
import org.kevoree.modeling.util.maths.expression.KMathVariableResolver;
import org.kevoree.modeling.util.maths.expression.impl.MathExpressionEngine;

public class DateMathExpressionTest {
    protected KMathExpressionEngine createEngine() {
        return new MathExpressionEngine();
    }

    public double getDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2015, 2, 11, 20, 53, 47);
        return calendar.getTimeInMillis();
    }

    @Test
    public void date() {
        KMathExpressionEngine ex = this.createEngine();
        ex.setVarResolver(new KMathVariableResolver(){

            public Double resolve(String potentialVarName) {
                if (PrimitiveHelper.equals((String)potentialVarName, (String)"time")) {
                    return DateMathExpressionTest.this.getDate();
                }
                return null;
            }
        });
        Assert.assertTrue((ex.parse("SECONDS(time)").eval(null) == 47.0 ? 1 : 0) != 0);
        Assert.assertTrue((ex.parse("MINUTES(time)").eval(null) == 53.0 ? 1 : 0) != 0);
        Assert.assertTrue((ex.parse("HOURS(time)").eval(null) == 20.0 ? 1 : 0) != 0);
        Assert.assertTrue((ex.parse("DAY(time)").eval(null) == 11.0 ? 1 : 0) != 0);
        Assert.assertTrue((ex.parse("MONTH(time)").eval(null) == 2.0 ? 1 : 0) != 0);
        Assert.assertTrue((ex.parse("YEAR(time)").eval(null) == 2015.0 ? 1 : 0) != 0);
        Assert.assertTrue((ex.parse("DAYOFWEEK(time)").eval(null) == 3.0 ? 1 : 0) != 0);
    }
}

