/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.util.maths.newMatrix;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.util.maths.matrix.CommonOps;
import org.kevoree.modeling.util.maths.matrix.SimpleMatrix;
import org.kevoree.modeling.util.maths.structure.KArray2D;
import org.kevoree.modeling.util.maths.structure.blas.KBlas;
import org.kevoree.modeling.util.maths.structure.blas.impl.JavaBlas;
import org.kevoree.modeling.util.maths.structure.impl.NativeArray2D;
import org.kevoree.modeling.util.maths.structure.matrix.MatrixOperations;

public class MatrixInvertTest {
    @Test
    public void invertMatrix() {
        this.invert(5);
        this.invert(100);
    }

    public void invert(int r) {
        int[] dimA = new int[]{r, r};
        boolean rand = true;
        double eps = 1.0E-5;
        NativeArray2D matA = new NativeArray2D(dimA[0], dimA[1]);
        MatrixOperations.initMatrice((KArray2D)matA, (boolean)rand);
        matA.set(0, 0, 5.0);
        JavaBlas java = new JavaBlas();
        SimpleMatrix ejmlmatA = new SimpleMatrix(dimA[0], dimA[1]);
        CommonOps.copyMatrix((KArray2D)matA, (SimpleMatrix)ejmlmatA);
        KArray2D res = MatrixOperations.invert((KArray2D)matA, (KBlas)java);
        SimpleMatrix resEjml = ejmlmatA.invert();
        boolean test = true;
        int count = 0;
        assert (res != null);
        for (int i = 0; i < matA.rows(); ++i) {
            for (int j = 0; j < matA.columns(); ++j) {
                if (!(Math.abs(resEjml.getValue2D(i, j) - res.get(i, j)) > eps)) continue;
                test = false;
                ++count;
            }
        }
        Assert.assertTrue((boolean)test);
    }
}

