/*
 * Decompiled with CFR 0.152.
 */
package org.kevoree.modeling.util.maths.newMatrix;

import org.junit.Assert;
import org.junit.Test;
import org.kevoree.modeling.util.maths.matrix.CommonOps;
import org.kevoree.modeling.util.maths.matrix.DenseMatrix64F;
import org.kevoree.modeling.util.maths.matrix.SimpleMatrix;
import org.kevoree.modeling.util.maths.matrix.TransposeAlgs;
import org.kevoree.modeling.util.maths.structure.KArray2D;
import org.kevoree.modeling.util.maths.structure.blas.KBlas;
import org.kevoree.modeling.util.maths.structure.blas.KBlasTransposeType;
import org.kevoree.modeling.util.maths.structure.blas.impl.JavaBlas;
import org.kevoree.modeling.util.maths.structure.impl.NativeArray2D;
import org.kevoree.modeling.util.maths.structure.matrix.MatrixOperations;

public class MatrixMultTest {
    @Test
    public void transposeTest() {
        int j;
        int i;
        JavaBlas java = new JavaBlas();
        NativeArray2D matA = new NativeArray2D(3, 5);
        int k = 1;
        for (int i2 = 0; i2 < matA.rows(); ++i2) {
            for (int j2 = 0; j2 < matA.columns(); ++j2) {
                matA.set(i2, j2, (double)k);
                ++k;
            }
        }
        KArray2D matB = MatrixOperations.transpose((KArray2D)matA);
        Assert.assertTrue((matA.columns() == matB.rows() ? 1 : 0) != 0);
        Assert.assertTrue((matA.rows() == matB.columns() ? 1 : 0) != 0);
        for (int i3 = 0; i3 < matA.rows(); ++i3) {
            for (int j3 = 0; j3 < matA.columns(); ++j3) {
                Assert.assertTrue((matA.get(i3, j3) == matB.get(j3, i3) ? 1 : 0) != 0);
            }
        }
        DenseMatrix64F test = new DenseMatrix64F(5, 5);
        matA = new NativeArray2D(5, 5);
        k = 1;
        for (i = 0; i < matA.rows(); ++i) {
            for (j = 0; j < matA.columns(); ++j) {
                matA.set(i, j, (double)k);
                test.set(i, j, (double)k);
                ++k;
            }
        }
        TransposeAlgs.square((DenseMatrix64F)test);
        matB = MatrixOperations.transpose((KArray2D)matA);
        Assert.assertTrue((matA.columns() == matB.rows() ? 1 : 0) != 0);
        Assert.assertTrue((matA.rows() == matB.columns() ? 1 : 0) != 0);
        for (i = 0; i < matA.rows(); ++i) {
            for (j = 0; j < matA.columns(); ++j) {
                Assert.assertTrue((matA.get(i, j) == matB.get(j, i) ? 1 : 0) != 0);
            }
        }
        matA = new NativeArray2D(450, 600);
        k = 1;
        for (i = 0; i < matA.rows(); ++i) {
            for (j = 0; j < matA.columns(); ++j) {
                matA.set(i, j, (double)k);
                ++k;
            }
        }
        matB = MatrixOperations.transpose((KArray2D)matA);
        Assert.assertTrue((matA.columns() == matB.rows() ? 1 : 0) != 0);
        Assert.assertTrue((matA.rows() == matB.columns() ? 1 : 0) != 0);
        for (i = 0; i < matA.rows(); ++i) {
            for (j = 0; j < matA.columns(); ++j) {
                Assert.assertTrue((matA.get(i, j) == matB.get(j, i) ? 1 : 0) != 0);
            }
        }
    }

    private void traditional(KBlasTransposeType transA, KBlasTransposeType transB, KArray2D matA, KArray2D matB, KArray2D matC, double alpha, double beta) {
        int dim = 0;
        dim = transA.equals((Object)KBlasTransposeType.NOTRANSPOSE) ? matA.columns() : matA.rows();
        for (int i = 0; i < matC.rows(); ++i) {
            for (int j = 0; j < matC.columns(); ++j) {
                matC.set(i, j, beta * matC.get(i, j));
                for (int k = 0; k < dim; ++k) {
                    if (transA.equals((Object)KBlasTransposeType.NOTRANSPOSE) && transB.equals((Object)KBlasTransposeType.NOTRANSPOSE)) {
                        matC.add(i, j, alpha * matA.get(i, k) * matB.get(k, j));
                        continue;
                    }
                    if (transA.equals((Object)KBlasTransposeType.TRANSPOSE) && transB.equals((Object)KBlasTransposeType.NOTRANSPOSE)) {
                        matC.add(i, j, alpha * matA.get(k, i) * matB.get(k, j));
                        continue;
                    }
                    if (transA.equals((Object)KBlasTransposeType.NOTRANSPOSE) && transB.equals((Object)KBlasTransposeType.TRANSPOSE)) {
                        matC.add(i, j, alpha * matA.get(i, k) * matB.get(j, k));
                        continue;
                    }
                    matC.add(i, j, alpha * matA.get(k, i) * matB.get(j, k));
                }
            }
        }
    }

    @Test
    public void multiplyTest() {
        JavaBlas java = new JavaBlas();
        int r = 100;
        int[] dimA = new int[]{r, r + 3};
        int[] dimB = new int[]{r + 3, r + 5};
        KBlasTransposeType transA = KBlasTransposeType.NOTRANSPOSE;
        KBlasTransposeType transB = KBlasTransposeType.NOTRANSPOSE;
        boolean rand = true;
        double alpha = 0.8;
        double beta = 0.2;
        double eps = 1.0E-7;
        NativeArray2D matA = new NativeArray2D(dimA[0], dimA[1]);
        MatrixOperations.initMatrice((KArray2D)matA, (boolean)rand);
        NativeArray2D matB = new NativeArray2D(dimB[0], dimB[1]);
        MatrixOperations.initMatrice((KArray2D)matB, (boolean)rand);
        int[] dimC = new int[2];
        if (transA.equals((Object)KBlasTransposeType.NOTRANSPOSE) && transB.equals((Object)KBlasTransposeType.NOTRANSPOSE)) {
            dimC[0] = dimA[0];
            dimC[1] = dimB[1];
        } else if (transA.equals((Object)KBlasTransposeType.TRANSPOSE) && transB.equals((Object)KBlasTransposeType.NOTRANSPOSE)) {
            dimC[0] = dimA[1];
            dimC[1] = dimB[1];
        } else if (transA.equals((Object)KBlasTransposeType.NOTRANSPOSE) && transB.equals((Object)KBlasTransposeType.TRANSPOSE)) {
            dimC[0] = dimA[0];
            dimC[1] = dimB[0];
        } else {
            dimC[0] = dimA[1];
            dimC[1] = dimB[0];
        }
        NativeArray2D matC = new NativeArray2D(dimC[0], dimC[1]);
        MatrixOperations.initMatrice((KArray2D)matC, (boolean)rand);
        KArray2D matresult = matC.clone();
        SimpleMatrix ejmlmatA = new SimpleMatrix(dimA[0], dimA[1]);
        SimpleMatrix ejmlmatB = new SimpleMatrix(dimB[0], dimB[1]);
        SimpleMatrix ejmlmatC = new SimpleMatrix(dimC[0], dimC[1]);
        CommonOps.copyMatrix((KArray2D)matA, (SimpleMatrix)ejmlmatA);
        CommonOps.copyMatrix((KArray2D)matB, (SimpleMatrix)ejmlmatB);
        CommonOps.copyMatrix((KArray2D)matC, (SimpleMatrix)ejmlmatC);
        this.traditional(transA, transB, (KArray2D)matA, (KArray2D)matB, (KArray2D)matC, alpha, beta);
        MatrixOperations.multiplyTransposeAlphaBetaResult((KBlasTransposeType)transA, (KBlasTransposeType)transB, (double)alpha, (KArray2D)matA, (KArray2D)matB, (double)beta, (KArray2D)matresult, (KBlas)java);
        CommonOps.multAlphaBeta((double)alpha, (DenseMatrix64F)ejmlmatA.getMatrix(), (DenseMatrix64F)ejmlmatB.getMatrix(), (DenseMatrix64F)ejmlmatC.getMatrix(), (double)beta);
        for (int i = 0; i < matC.rows(); ++i) {
            for (int j = 0; j < matC.columns(); ++j) {
                Assert.assertEquals((double)matresult.get(i, j), (double)matC.get(i, j), (double)eps);
                Assert.assertEquals((double)ejmlmatC.getValue2D(i, j), (double)matC.get(i, j), (double)eps);
            }
        }
    }
}

